/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import net.sourceforge.plantuml.project.Numeric;
import net.sourceforge.plantuml.project.NumericNumber;
import net.sourceforge.plantuml.project.NumericType;

class Duration
implements Numeric {
    private final long minutes;

    public Duration(long minutes) {
        this.minutes = minutes;
    }

    public Duration(NumericNumber value) {
        this((long)value.getIntValue() * 24L * 60L * 60L);
    }

    @Override
    public Numeric add(Numeric other) {
        return new Duration(((Duration)other).minutes + this.minutes);
    }

    public static Duration of(long days) {
        return new Duration(days * 24L * 60L * 60L);
    }

    @Override
    public NumericType getNumericType() {
        return NumericType.DURATION;
    }

    public long getMinutes() {
        return this.minutes;
    }

    public String toString() {
        return "DURATION:" + this.minutes / 86400L;
    }

    @Override
    public int compareTo(Numeric other) {
        Duration this2 = (Duration)other;
        if (this2.minutes > this.minutes) {
            return -1;
        }
        if (this2.minutes < this.minutes) {
            return 1;
        }
        return 0;
    }
}

