/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.html;

import java.io.PrintWriter;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;

public final class LinkHtmlPrinter {
    private final Link link;
    private final boolean chiral;

    public LinkHtmlPrinter(Link link, IEntity entity) {
        this.link = link;
        if (link.getEntity1() == entity) {
            this.chiral = false;
        } else if (link.getEntity2() == entity) {
            this.chiral = true;
        } else {
            throw new IllegalArgumentException();
        }
    }

    void printLink(PrintWriter pw) {
        String ent2h;
        String ent1h;
        if (this.chiral) {
            ent1h = LinkHtmlPrinter.htmlLink(this.link.getEntity1());
            ent2h = "<i>" + StringUtils.unicodeForHtml(this.link.getEntity2().getCode().getFullName()) + "</i>";
        } else {
            ent1h = "<i>" + StringUtils.unicodeForHtml(this.link.getEntity1().getCode().getFullName()) + "</i>";
            ent2h = LinkHtmlPrinter.htmlLink(this.link.getEntity2());
        }
        String label = this.link.getLabel() == null ? null : StringUtils.unicodeForHtml(this.link.getLabel());
        String ent1 = ent1h;
        String ent2 = ent2h;
        if (this.link.getQualifier1() != null) {
            ent1 = ent1 + " (" + this.link.getQualifier1() + ")";
            if (label != null) {
                label = "(" + this.link.getQualifier1() + " " + ent1h + ") " + label;
            }
        }
        if (this.link.getQualifier2() != null) {
            ent2 = ent2 + " (" + this.link.getQualifier2() + ")";
            if (label != null) {
                label = label + " (" + this.link.getQualifier2() + " " + ent2h + ")";
            }
        }
        if (this.chiral) {
            pw.println(this.getHtmlChiral(ent1, ent2));
        } else {
            pw.println(this.getHtml(ent1, ent2));
        }
        if (label != null) {
            pw.println("&nbsp;:&nbsp;");
            pw.println(label);
        }
    }

    private String getHtml(String ent1, String ent2) {
        LinkDecor decor1 = this.link.getType().getDecor1();
        LinkDecor decor2 = this.link.getType().getDecor2();
        if (decor1 == LinkDecor.NONE && decor2 == LinkDecor.NONE) {
            return ent1 + " is linked to " + ent2;
        }
        if (decor1 == LinkDecor.NONE && decor2 == LinkDecor.EXTENDS) {
            return ent1 + " is extended by " + ent2;
        }
        if (decor1 == LinkDecor.EXTENDS && decor2 == LinkDecor.NONE) {
            return ent1 + " extends " + ent2;
        }
        if (decor2 == LinkDecor.AGREGATION) {
            return ent1 + " is aggregated by  " + ent2;
        }
        if (decor1 == LinkDecor.AGREGATION) {
            return ent1 + " aggregates " + ent2;
        }
        if (decor2 == LinkDecor.COMPOSITION) {
            return ent1 + " is composed by " + ent2;
        }
        if (decor1 == LinkDecor.COMPOSITION) {
            return ent1 + " composes " + ent2;
        }
        if (decor1 == LinkDecor.NONE && decor2 == LinkDecor.ARROW) {
            return ent1 + " is navigable from  " + ent2;
        }
        if (decor1 == LinkDecor.ARROW && decor2 == LinkDecor.NONE) {
            return ent1 + " navigates to  " + ent2;
        }
        return ent1 + " " + (Object)((Object)decor1) + "-" + (Object)((Object)decor2) + " " + ent2;
    }

    private String getHtmlChiral(String ent1, String ent2) {
        LinkDecor decor1 = this.link.getType().getDecor1();
        LinkDecor decor2 = this.link.getType().getDecor2();
        if (decor1 == LinkDecor.NONE && decor2 == LinkDecor.NONE) {
            return ent2 + " is linked to " + ent1;
        }
        if (decor1 == LinkDecor.NONE && decor2 == LinkDecor.EXTENDS) {
            return ent2 + " extends " + ent1;
        }
        if (decor1 == LinkDecor.EXTENDS && decor2 == LinkDecor.NONE) {
            return ent2 + " is extended by " + ent1;
        }
        if (decor2 == LinkDecor.AGREGATION) {
            return ent2 + " aggregates " + ent1;
        }
        if (decor1 == LinkDecor.AGREGATION) {
            return ent2 + " is aggregated by " + ent1;
        }
        if (decor2 == LinkDecor.COMPOSITION) {
            return ent2 + " composes " + ent1;
        }
        if (decor1 == LinkDecor.COMPOSITION) {
            return ent2 + " is composed by " + ent1;
        }
        if (decor1 == LinkDecor.NONE && decor2 == LinkDecor.ARROW) {
            return ent2 + " navigates to  " + ent1;
        }
        if (decor1 == LinkDecor.ARROW && decor2 == LinkDecor.NONE) {
            return ent2 + " is navigable from  " + ent1;
        }
        return ent1 + " " + (Object)((Object)decor1) + "-" + (Object)((Object)decor2) + " " + ent2;
    }

    static String htmlLink(IEntity ent) {
        StringBuilder sb = new StringBuilder();
        sb.append("<a href=\"");
        sb.append(LinkHtmlPrinter.urlOf(ent));
        sb.append("\">");
        sb.append(StringUtils.unicodeForHtml(ent.getCode().getFullName()));
        sb.append("</a>");
        return sb.toString();
    }

    static String urlOf(IEntity ent) {
        if (ent.getEntityType() == LeafType.NOTE) {
            throw new IllegalArgumentException();
        }
        if (ent.getCode().getFullName().matches("[-\\w_ .]+")) {
            return StringUtils.unicodeForHtml(ent.getCode().getFullName()) + ".html";
        }
        return StringUtils.unicodeForHtml(ent.getUid()) + ".html";
    }
}

