/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.AbstractUGraphicHorizontalLine;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UHorizontalLine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class USymbolQueue
extends USymbol {
    private final double dx = 5.0;

    USymbolQueue() {
    }

    @Override
    public SkinParameter getSkinParameter() {
        return SkinParameter.QUEUE;
    }

    private void drawDatabase(UGraphic ug, double width, double height, boolean shadowing) {
        UPath shape = new UPath();
        if (shadowing) {
            shape.setDeltaShadow(3.0);
        }
        shape.moveTo(5.0, 0.0);
        shape.lineTo(width - 5.0, 0.0);
        shape.cubicTo(width, 0.0, width, height / 2.0, width, height / 2.0);
        shape.cubicTo(width, height / 2.0, width, height, width - 5.0, height);
        shape.lineTo(5.0, height);
        shape.cubicTo(0.0, height, 0.0, height / 2.0, 0.0, height / 2.0);
        shape.cubicTo(0.0, height / 2.0, 0.0, 0.0, 5.0, 0.0);
        ug.draw(shape);
        UPath closing = this.getClosingPath(width, height);
        ug.apply(new UChangeBackColor(null)).draw(closing);
    }

    private UPath getClosingPath(double width, double height) {
        UPath closing = new UPath();
        closing.moveTo(width - 5.0, 0.0);
        closing.cubicTo(width - 10.0, 0.0, width - 10.0, height / 2.0, width - 10.0, height / 2.0);
        closing.cubicTo(width - 10.0, height, width - 5.0, height, width - 5.0, height);
        return closing;
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(5.0, 15.0, 5.0, 5.0);
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final SymbolContext symbolContext) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                Dimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = symbolContext.apply(ug);
                USymbolQueue.this.drawDatabase(ug, dim.getWidth(), dim.getHeight(), symbolContext.isShadowing());
                USymbol.Margin margin = USymbolQueue.this.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, HorizontalAlignment.CENTER);
                MyUGraphicDatabase ug2 = new MyUGraphicDatabase(ug, dim.getWidth());
                tb.drawU(ug2.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimLabel = label.calculateDimension(stringBounder);
                Dimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return USymbolQueue.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimStereo, dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(TextBlock title, TextBlock stereotype, double width, double height, SymbolContext symbolContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean manageHorizontalLine() {
        return true;
    }

    class MyUGraphicDatabase
    extends AbstractUGraphicHorizontalLine {
        private final double endingX;

        @Override
        protected AbstractUGraphicHorizontalLine copy(UGraphic ug) {
            return new MyUGraphicDatabase(ug, this.endingX);
        }

        public MyUGraphicDatabase(UGraphic ug, double endingX) {
            super(ug);
            this.endingX = endingX;
        }

        @Override
        protected void drawHline(UGraphic ug, UHorizontalLine line, UTranslate translate) {
            line.drawTitleInternal(ug, 0.0, this.endingX, 0.0, true);
        }
    }
}

