/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class TextBlockMarged
extends AbstractTextBlock
implements TextBlock {
    private final TextBlock textBlock;
    private final double x1;
    private final double x2;
    private final double y1;
    private final double y2;

    public TextBlockMarged(TextBlock textBlock, double x1, double x2, double y1, double y2) {
        this.textBlock = textBlock;
        this.x1 = x1;
        this.x2 = x2;
        this.y1 = y1;
        this.y2 = y2;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dim = this.textBlock.calculateDimension(stringBounder);
        return Dimension2DDouble.delta(dim, this.x1 + this.x2, this.y1 + this.y2);
    }

    @Override
    public void drawU(UGraphic ug) {
        UTranslate translate = new UTranslate(this.x1, this.y1);
        this.textBlock.drawU(ug.apply(translate));
    }

    @Override
    public Rectangle2D getInnerPosition(String member, StringBounder stringBounder) {
        Rectangle2D parent = this.textBlock.getInnerPosition(member, stringBounder);
        if (parent == null) {
            return null;
        }
        UTranslate translate = new UTranslate(this.x1, this.y1);
        return translate.apply(parent);
    }
}

