/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.CharSequence2Impl;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.utils.StartUtils;
import net.sourceforge.plantuml.version.IteratorCounter2;
import net.sourceforge.plantuml.version.IteratorCounter2Impl;

public final class UmlSource {
    private final List<String> source;
    private final List<CharSequence2> source2;

    public UmlSource(List<CharSequence2> source, boolean checkEndingBackslash) {
        ArrayList<String> tmp = new ArrayList<String>();
        ArrayList<CharSequence2> tmp2 = new ArrayList<CharSequence2>();
        if (checkEndingBackslash) {
            StringBuilder pending = new StringBuilder();
            for (CharSequence2 cs : source) {
                String s = cs.toString2();
                if (StringUtils.endsWithBackslash(s)) {
                    pending.append(s.substring(0, s.length() - 1));
                    continue;
                }
                pending.append(s);
                tmp.add(pending.toString());
                tmp2.add(new CharSequence2Impl(pending.toString(), cs.getLocation()));
                pending.setLength(0);
            }
        } else {
            for (CharSequence2 s : source) {
                tmp.add(s.toString2());
                tmp2.add(s);
            }
        }
        this.source = Collections.unmodifiableList(tmp);
        this.source2 = Collections.unmodifiableList(tmp2);
    }

    public DiagramType getDiagramType() {
        return DiagramType.getTypeFromArobaseStart(this.source.get(0));
    }

    public IteratorCounter2 iterator2() {
        return new IteratorCounter2Impl(this.source2);
    }

    public String getPlainString() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.source) {
            sb.append(s);
            sb.append('\r');
            sb.append('\n');
        }
        return sb.toString();
    }

    public String getLine(int n) {
        return this.source.get(n);
    }

    public int getTotalLineCount() {
        return this.source.size();
    }

    public boolean isEmpty() {
        for (String s : this.source) {
            if (StartUtils.isArobaseStartDiagram(s) || StartUtils.isArobaseEndDiagram(s) || s.matches("\\s*'.*") || StringUtils.trin(s).length() == 0) continue;
            return false;
        }
        return true;
    }

    public Display getTitle() {
        Pattern p = MyPattern.cmpile("(?i)^[%s]*title[%s]+(.+)$");
        for (String s : this.source) {
            Matcher m = p.matcher(s);
            boolean ok = m.matches();
            if (!ok) continue;
            return Display.create(m.group(1));
        }
        return Display.empty();
    }
}

