/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.core.Diagram;

public abstract class CommandMultilines<S extends Diagram>
implements Command<S> {
    private final Pattern starting;

    public CommandMultilines(String patternStart) {
        if (!patternStart.startsWith("(?i)^") || !patternStart.endsWith("$")) {
            throw new IllegalArgumentException("Bad pattern " + patternStart);
        }
        this.starting = MyPattern.cmpile(patternStart);
    }

    public abstract String getPatternEnd();

    @Override
    public String[] getDescription() {
        return new String[]{"START: " + this.starting.pattern(), "END: " + this.getPatternEnd()};
    }

    @Override
    public final CommandControl isValid(BlocLines lines) {
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        Matcher m1 = this.starting.matcher(StringUtils.trin(lines.getFirst499()));
        if (!m1.matches()) {
            return CommandControl.NOT_OK;
        }
        if (lines.size() == 1) {
            return CommandControl.OK_PARTIAL;
        }
        m1 = MyPattern.cmpile(this.getPatternEnd()).matcher(StringUtils.trin(lines.getLast499()));
        if (!m1.matches()) {
            return CommandControl.OK_PARTIAL;
        }
        this.actionIfCommandValid();
        return CommandControl.OK;
    }

    protected boolean isCommandForbidden() {
        return false;
    }

    protected void actionIfCommandValid() {
    }

    protected final Pattern getStartingPattern() {
        return this.starting;
    }
}

