#include <gst/gst.h>
#include <gst/pbutils/pbutils.h>

int main()
{
    gst_init(NULL, NULL);
    GError *err = NULL;
    GstDiscoverer *discoverer = gst_discoverer_new (1 * GST_SECOND, &err);
    if (!discoverer)
    {
        g_print ("Error creating discoverer instance: %s\n", err->message);
        g_clear_error (&err);
        err = NULL;
        return -1;
    }
    GstDiscovererInfo *info = NULL;
    GstDiscovererResult result;
    int count = 0;
    while(true)
    {
        info = gst_discoverer_discover_uri(discoverer,"http://193.29.200.243:8000/nashe.aac" , &err);
        if(err)
        {
            g_print ("Error getting stream info: %s\n", err->message);
            g_clear_error (&err);
            err = NULL;
        }
        else
        {
            g_print("%d: ",count);
            result = gst_discoverer_info_get_result (info);
            if(result == GST_DISCOVERER_OK)
            {
                g_print("stream Online\n");
            }
            else
            {
                g_print("stream Offline\n");
            }
        }
        info = NULL;
        count++;
    }
    return 0;
}