#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>
#include <gdk/gdkx.h>

#if GTK_CHECK_VERSION(3,0,0)
#include <gtk/gtkx.h>
#endif 

/* option entries */
static gint32 opt_socket_id = 0;

static GOptionEntry option_entries[] =
{
    { "socket-id", 's', G_OPTION_FLAG_IN_MAIN, G_OPTION_ARG_INT, &opt_socket_id, ("Settings manager socket"), ("SOCKET ID") },
    { NULL }
};

void activate_link_cb ()
{
	printf ("activate-link callback received\n");
}

int main (int argc, char **argv)
{
	GtkWidget *window;
    GtkWidget *plug;
    GtkWidget *label;
    GError *error;

    /* initialize Gtk+ */
    if (!gtk_init_with_args (&argc, &argv, "", option_entries, NULL, &error))
    {
        if (G_LIKELY (error))
        {
            /* print error */
            g_print ("%s: %s.\n", G_LOG_DOMAIN, error->message);
            g_print ("Type '%s --help' for usage.", G_LOG_DOMAIN);
            g_print ("\n");

            /* cleanup */
            g_error_free (error);
        }
        else
        {
            g_error ("Unable to open display.");
        }

        return EXIT_FAILURE;
    }
	label = gtk_label_new (NULL);
	
	gtk_label_set_markup (GTK_LABEL (label), ("<a href=\"test-label-link:\">GtkLabel TEST LINK</a> "));
	g_signal_connect(label, "activate-link", activate_link_cb, NULL);
	gtk_widget_show(label);
		
	if (opt_socket_id == 0)
	{
		window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
     
		gtk_window_set_position(GTK_WINDOW(window),GTK_WIN_POS_CENTER);
		gtk_window_set_default_size(GTK_WINDOW(window),320,200);
		gtk_container_add(GTK_CONTAINER(window), label);
		g_signal_connect (window, "delete-event", G_CALLBACK (gtk_main_quit), NULL);
		gtk_widget_show(window);
	}
	else 
	{
		/* Create plug widget */
		plug = gtk_plug_new (opt_socket_id);
		g_signal_connect (plug, "delete-event", G_CALLBACK (gtk_main_quit), NULL);
		gtk_widget_show (plug);
	    
		
		gtk_container_add (GTK_CONTAINER(plug), label);
		/* Stop startup notification */
		gdk_notify_startup_complete ();
	}
    /* Enter main loop */
	gtk_main();	
    
	return 0;
}
