#include <gst/gst.h>
#include <glib.h>
#include <stdio.h>

GstElement *pipeline;
GstElement *src;

static gboolean
bus_call (GstBus     *bus,
          GstMessage *msg,
          gpointer    data)
{
  GMainLoop *loop = (GMainLoop *) data;

  switch (GST_MESSAGE_TYPE (msg)) {

    case GST_MESSAGE_EOS:
      g_print ("End of stream\n");
//      g_main_loop_quit (loop);
      break;

    case GST_MESSAGE_ERROR: {
      gchar  *debug;
      GError *error;

      gst_message_parse_error (msg, &error, &debug);
      g_free (debug);

      g_printerr ("Error: %s\n", error->message);
      g_error_free (error);

      g_main_loop_quit (loop);
      break;
    }
    default:
      break;
  }

  return TRUE;
}

static gboolean
play_repeat(gpointer user_data)
{
  gint64 pos = 0;

  g_print ("Seek to 0\n");
  if (!gst_element_seek_simple (pipeline, GST_FORMAT_TIME,
          GST_SEEK_FLAG_FLUSH | GST_SEEK_FLAG_KEY_UNIT, pos)) {
    g_print ("Could not seek.\n");
    return FALSE;
  }

  return TRUE;
}

int
main (int   argc,
      char *argv[])
{
  GMainLoop *loop;

  GstBus *bus;
  guint bus_watch_id;
  guint repeat_timer;
  GstElement *sink;

  /* Initialisation */
  gst_init (&argc, &argv);

  loop = g_main_loop_new (NULL, FALSE);

  /* Check input arguments */
  if (argc < 2) {
    g_printerr ("Usage: %s <url>\n", argv[0]);
    return -1;
  }

  /* Create gstreamer elements */
  pipeline = gst_element_factory_make ("playbin", "playbin");
  if (pipeline == NULL)
    return -1;

  sink = gst_element_factory_make ("pulsesink", NULL);

  g_object_set (pipeline, "audio-sink", sink, NULL);
  g_object_set (pipeline, "uri", argv[1], NULL);

  /* we add a message handler */
  bus = gst_pipeline_get_bus (GST_PIPELINE (pipeline));
  bus_watch_id = gst_bus_add_watch (bus, bus_call, loop);
  gst_object_unref (bus);

  /* Set the pipeline to "playing" state*/
  g_print ("Now playing\n");
  gst_element_set_state (pipeline, GST_STATE_PLAYING);

  /* add repeat timer */
  repeat_timer = g_timeout_add_seconds (1, play_repeat, NULL);

  g_print ("Running...\n");
  g_main_loop_run (loop);

  /* Out of the main loop, clean up nicely */
  g_print ("Returned, stopping playback\n");
  gst_element_set_state (pipeline, GST_STATE_READY);

  g_print ("Deleting pipeline\n");
  gst_element_set_state (pipeline, GST_STATE_NULL);
  gst_object_unref (GST_OBJECT (src));
  gst_object_unref (GST_OBJECT (pipeline));
  g_source_remove (bus_watch_id);
  g_source_remove (repeat_timer);
  g_main_loop_unref (loop);

  return 0;
}
