/****************************************************************************/
/*							  	Includes									*/
/****************************************************************************/
#include <libxml/c14n.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <libxml/encoding.h>
#include <libxml/xmlwriter.h>
#include <libxml/xpath.h>
#include <libxml/xpathInternals.h>
#include <libxml/xmlreader.h>
#include <string.h>

#include <libxml/globals.h>	/* must come before xmlmemory.h */
#include <libxml/xmlmemory.h>
#include <libxml/xmlerror.h>
#include <libxml/threads.h>

/****************************************************************************/
/*							  	 Defines									*/
/****************************************************************************/
#ifndef XML_ERR_BUF_SIZE
	#define XML_ERR_BUF_SIZE 512
#endif
#ifndef FALSE
#define FALSE               0
#endif

#ifndef TRUE
#define TRUE                1
#endif
#define CLEANUP(ptr,function)		{if (ptr != NULL) function(ptr); ptr = NULL;}

#define MAX_MEMORY 1000000

/****************************************************************************/
/*									Globals									*/
/****************************************************************************/
char	XMLErrorBuf[XML_ERR_BUF_SIZE] = {0}; 

/****************************************************************************/
/*                                 Prototypes								*/
/****************************************************************************/

void XMLLiblStructuredErrorHandler(void * userData,xmlErrorPtr error);
void XMLLibErrorHandler(void * userData,const char * msg,...);

unsigned int xmlSetMaxMemory(unsigned int NewMaxMemory);
void *TestxmlMemMalloc(size_t size);
void *TestxmlMemMallocAtomic(size_t size);
void *TestxmlMemRealloc(void *ptr,size_t size);
void TestxmlMemFree(void *ptr);
char *TestxmlMemoryStrdup(const char *str);
void TestxmlCleanupMemory(void);
int	 TestxmlMemUsed(void);


/****************************************************************************/
/* m a i n																	*/
/****************************************************************************/
void main(void)
{
	int			XMLMemoryPtrSize = 0;
	int			counter;
	char		*XMLBuf;

	xmlChar		*XMLMemoryPtr = NULL;
	xmlDocPtr	doc = NULL;
	xmlNodePtr	DatasNode = NULL;
	xmlXPathObjectPtr	xpathObj = NULL;
	xmlXPathContextPtr	xpathCtx = NULL;
	/*
	char		*test;
	char		*test1;
	xmlFreeFunc OrigfreeFunc = NULL;
	xmlMallocFunc OrigmallocFunc = NULL;
	xmlMallocFunc OrigmallocAtomicFunc = NULL;
	xmlReallocFunc OrigreallocFunc = NULL;
	xmlStrdupFunc OrigstrdupFunc = NULL;

	// use the debugger to check that everything seems to work how I expect
	
	xmlGcMemGet(&OrigfreeFunc,&OrigmallocFunc,&OrigmallocAtomicFunc,&OrigreallocFunc,&OrigstrdupFunc);
	
	test = OrigstrdupFunc("Test");
	OrigfreeFunc(test);
	test = (char *) OrigmallocFunc(100);
	test1 = NULL;
	test1 = (char *) OrigreallocFunc(test,200);
	OrigfreeFunc(test);
	*/
	XMLErrorBuf[0] = 0;
	xmlGcMemSetup(&TestxmlMemFree,&TestxmlMemMalloc,&TestxmlMemMallocAtomic,&TestxmlMemRealloc,&TestxmlMemoryStrdup); 
	xmlSetMaxMemory(MAX_MEMORY);


	xmlSetGenericErrorFunc(XMLErrorBuf,XMLLibErrorHandler);				
	xmlSetStructuredErrorFunc(XMLErrorBuf,XMLLiblStructuredErrorHandler);

	LIBXML_TEST_VERSION // this calls the old initmemory function but it harmlesly creates a mutex (maybe is should check if the memory functions have been moved to user ones)
	if (XMLErrorBuf[0] != 0)
		printf("Error found in libxml buffer %s\n",XMLErrorBuf);

	XMLBuf = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\
			<TopLevel>\n\
				<SomeNode>2.0</SomeNode>\n\
				<AnothNode>\n\
					<Shizzle>\n\
						<MoreShizzle></MoreShizzle>\n\
						<EvenMoreShizzle></EvenMoreShizzle>\n\
					</Shizzle>\n\
					<ExtraShizzle>\n\
						<MoreExtraShizzle></MoreExtraShizzle>\n\
						<EvenMoreExtraShizzle></EvenMoreExtraShizzle>\n\
					</ExtraShizzle>\n\
				</AnothNode>\n\
				<Header>\n\
					<Keys>\n\
						<Key></Key>\n\
						<Key></Key>\n\
					</Keys>\n\
				</Header>\n\
				<Body>\n\
					<Datas>\n\
						<Data>RandomShizzle</Data>\n\
					</Datas>\n\
				</Body>\n\
			</TopLevel>\n\
			";
	printf("Memory used %u of %u bytes %s\n",TestxmlMemUsed(),MAX_MEMORY,XMLErrorBuf);
	if ((doc = xmlReadMemory((char *)XMLBuf,strlen(XMLBuf),"noname.xml", "UTF-8",XML_PARSE_RECOVER | XML_PARSE_NOWARNING)) == NULL)
	{
		printf("Failed to xmlReadFile %s\n",XMLErrorBuf);
		goto ErrorExit;
	}
	printf("Memory used %u of %u bytes %s\n",TestxmlMemUsed(),MAX_MEMORY,XMLErrorBuf);
	if ((xpathCtx = xmlXPathNewContext(doc)) == NULL)
	{
		printf("Memory used %u of %u bytes %s\n",TestxmlMemUsed(),MAX_MEMORY,XMLErrorBuf);
		goto ErrorExit;
	}

	if ((xpathObj = xmlXPathEvalExpression((const xmlChar *)"//MoreShizzle", xpathCtx)) != NULL)
	{
		int size = (xpathObj->nodesetval) ? xpathObj->nodesetval->nodeNr : 0;
		if (size > 0)
		{
			xmlNodeSetContent(xpathObj->nodesetval->nodeTab[0], (const xmlChar *) "MoreShizzle Contents");
			if (xpathObj->nodesetval->nodeTab[0]->type != XML_NAMESPACE_DECL)
				xpathObj->nodesetval->nodeTab[0] = NULL;
		}
	}
	printf("Memory used %u of %u bytes %s\n",TestxmlMemUsed(),MAX_MEMORY,XMLErrorBuf);
	xmlDocDumpMemoryEnc(doc,&XMLMemoryPtr, &XMLMemoryPtrSize,"UTF-8"); // use debugger and check everything is ok
	CLEANUP(XMLMemoryPtr,xmlFree);
	CLEANUP(xpathObj,xmlXPathFreeObject)
	
	if ((xpathObj = xmlXPathEvalExpression((const xmlChar *)"//Datas", xpathCtx)) != NULL)
		(xpathObj->nodesetval->nodeTab) ? (DatasNode = xpathObj->nodesetval->nodeTab[0]) : (DatasNode = NULL);

	if (DatasNode == NULL)
	{
		printf("Memory used %u of %u bytes %s\n",TestxmlMemUsed(),MAX_MEMORY,XMLErrorBuf);
		goto ErrorExit;
	}
	srand (time(NULL));
	for(counter = 0;counter < 7000;counter++) // too big and xmlNewChild will crash 
	{
		char	tmpbuf[100];
		xmlNodePtr	DataNode;
		sprintf(tmpbuf,"%8.8u",counter);

		if ((DataNode = xmlNewChild(DatasNode,NULL, BAD_CAST "Data",BAD_CAST tmpbuf)) == NULL) // this will crash if you run out of memory
		{
			printf("xmlNewChild Data NULL Memory used %u of %u bytes %s\n",TestxmlMemUsed(),MAX_MEMORY,XMLErrorBuf);
			goto ErrorExit;
		}
		if (rand() % 300 == 0)
		{
			printf("Counter %u Memory used %u of %u bytes %s\n",counter,TestxmlMemUsed(),MAX_MEMORY,XMLErrorBuf);
			if (xmlNewChild(DataNode,NULL, BAD_CAST "DataExtra",BAD_CAST "Some Info") == NULL) // this will crash if you run out of memory
			{
				printf("xmlNewChild DataExtra NULL Memory used %u of %u bytes %s\n",TestxmlMemUsed(),MAX_MEMORY,XMLErrorBuf);
				goto ErrorExit;
			}
		}
	}
	
	xmlDocDumpMemoryEnc(doc,&XMLMemoryPtr, &XMLMemoryPtrSize,"UTF-8");
	
	printf("Memory used %u of %u bytes %s\n",TestxmlMemUsed(),MAX_MEMORY,XMLErrorBuf);

ErrorExit:
	
	xmlMemoryDump();
	CLEANUP(XMLMemoryPtr,xmlFree);
	CLEANUP(xpathObj,xmlXPathFreeObject)
	CLEANUP(xpathCtx,xmlXPathFreeContext)
	CLEANUP(doc,xmlFreeDoc);
	xmlMemoryDump();
	TestxmlCleanupMemory();
	xmlCleanupParser();
	xmlMemoryDump();
	printf("return %s\n",XMLErrorBuf);
	return;
}
/****************************************************************************/
/* X M L L i b E r r o r H a n d l e r										*/
/****************************************************************************/
void XMLLibErrorHandler(void * userData,const char * msg,...)
{
	va_list args;
	if (userData != NULL) 
	{
		int	StrLen = strlen((char *)userData);
		va_start( args, msg );
		vsnprintf( (char *)userData + StrLen,XML_ERR_BUF_SIZE, msg, args );
		va_end(args);
	}
	return;
}
/****************************************************************************/
/* X M L L i b l S t r u c t u r e d E r r o r H a n d l e r				*/
/****************************************************************************/
void XMLLiblStructuredErrorHandler(void * userData,xmlErrorPtr error)
{
	if (userData != NULL)
	{
		int	StrLen = strlen((char *)userData);
		*((char *)userData + XML_ERR_BUF_SIZE - 1) = 0;
		if (error->message != NULL)
			strncpy((char *)userData + StrLen,error->message,XML_ERR_BUF_SIZE - 1);
	}
	return;
}