
from gi.repository import GObject, Gtk, Gedit

class bugtest(GObject.Object, Gedit.WindowActivatable):
	__gtype_name__ = "bugtest"
	window = GObject.property(type=Gedit.Window)

	def __init__(self):
		GObject.Object.__init__(self)

	def do_activate(self):
		self.window.connect("tab-added", self.tab_event)
		self.window.connect("active-tab-changed", self.tab_event)
		for doc in self.window.get_documents():
			self.check_langobj(doc) 

	def do_deactivate(self):
		pass

	def tab_event(self, window, tab, data=None) :
		self.check_langobj(window.get_active_document()) 

	def check_langobj(self, doc):
		if(doc==None): 
			return
		if(doc.get_language() == None):
			print("[" +doc.get_short_name_for_display() + "] doc.get_language() == None [Error]")
		else:	
			print("[" +doc.get_short_name_for_display() + "] doc.get_language() != None [OK]")
		
