/******************************************************************************
 ******************************************************************************/

#include <stdio.h>
#include <string.h>
#include <librsvg/rsvg.h>
#include <librsvg/rsvg-cairo.h>

#include <libxml/parser.h>
#include <libxml/tree.h>

static void _find_sizes(xmlNode * _node, RsvgHandle *rh)
{
    xmlNode *node = 0;
    for (node = _node; node; node = node->next)
    {
	char *id = xmlGetProp(node, "id");

	if (id && *id)
	{
	    char *id2 = malloc(strlen(id)+2);
	    sprintf(id2, "#%s", id);
	    RsvgPositionData pos;
	    RsvgDimensionData dim;
	    rsvg_handle_get_dimensions_sub (rh, &dim, id2);
	    rsvg_handle_get_position_sub (rh, &pos, id2);
	    printf("%-10s: %-10s", node->name, id);
	    printf("%4dx%4d (%4d,%4d)", dim.width, dim.height, pos.x, pos.y);
	    printf("\n");
	    free(id2);
	}
	xmlFree(id);
	_find_sizes(node->children, rh);
    }
}

void find_sizes(char *file)
{
    GError *error = 0;
    xmlDoc *doc = NULL;
    xmlNode *root_element = NULL;
    doc = xmlReadFile(file, NULL, 0);
    root_element = xmlDocGetRootElement(doc);

    RsvgHandle *rh = rsvg_handle_new_from_file(file, &error);

    _find_sizes(root_element, rh);
    xmlFreeDoc(doc);
    xmlCleanupParser();
    rsvg_handle_close(rh, &error);

}

int main(int argc, char *argv[])
{
    int rc = 0;
    GError *error = 0;

    g_type_init();
    argc--;
    argv++;
    if (argc > 0)
	find_sizes(argv[0]);
}
// gcc `pkg-config --cflags librsvg-2.0 libxml-2.0` svgsize.c `pkg-config --libs librsvg-2.0 libxml-2.0` -osvgsize
