/**
 * Test package for reproducing a problem of Doxygen with annotations that have brackets.
 * <p>
 * If a class or method is annotated with an annotation with brackets (e.g. because it takes arguments), 
 * then either the class as a whole is missing in the doxygen output 
 * or the methods beginning with the annotated one (and all that are following in the class) 
 * are missing in the class documentation output. 
 * <u>Following classes are in this package:</u>
 * <ul>
 * <li>{@link at.doxygen.bug.annotations.AnnotatedMethod()} - in output PARTIALLY</li>
 * <li>{@link at.doxygen.bug.annotations.AnnotatedWithSuppressWarnings} - NOT in  output (at all!)</li>
 * <li>{@link at.doxygen.bug.annotations.DeprecatedClass} - in output (complete)</li>
 * <li>{@link at.doxygen.bug.annotations.DeprecatedClassWithBrackets} - NOT in  output (at all!)</li>
 * <li>{@link at.doxygen.bug.annotations.DeprecatedMethod} - in output (complete)</li>
 * <li>{@link at.doxygen.bug.annotations.NoAnnotations} - in output (complete)</li>
 * </ul>
 * </p>
 */
package at.doxygen.bug.annotations;