package at.doxygen.bug.annotations;

/**
 * This is a documented class without any annotations.
 * <p>
 * Doxygen produces documentation as expected.<br>
 * <u>Public methods in this class:</u>
 * <ul>
 * <li>{@link #NoAnnotations()} - in output</li>
 * <li>{@link #toLowerCaseString(CharSequence)} - in output</li>
 * </ul>
 * </p>
 * 
 * @author starfury
 */
public class NoAnnotations {

	/**
	 * This is the default constructor.
	 */
	public NoAnnotations() {
		// does nothing
	}

	/**
	 * This method converts the given {@link CharSequence} to
	 * a lower cased string.
	 * 
	 * @param someText The text to be lowercased
	 * @return The text in lower case letters
	 */
	public String toLowerCaseString(CharSequence someText) {
		return someText.toString().toLowerCase();
	}

}