#include "playback_lib_facade.h"
#include <iostream>
#include <Windows.h>
#include <gst/gst.h>
#include <gst/video/videooverlay.h>
#include <gst/gstbin.h>

static GMainLoop *loop;

int main (int argc, char *argv[]) {

  char *item1 = "C:\\tmp2\\nab_ice_hockey.mp4";

  GstElement *pipeline;
  GstBus *bus;
  GstElement *bin;
  GError *err = NULL;
  guint bus_watch_id;

  gst_init (&argc, &argv);

  pipeline = gst_parse_launch_full ("filesrc name=source ! qtdemux name=dmx dmx.video_0 ! avdec_h264 ! videoconvert ! d3dvideosink", NULL, GST_PARSE_FLAG_NONE, &err);
  while (1)
  {
    bin = gst_bin_get_by_name (GST_BIN (pipeline), "source");
    g_object_set (bin, "location", item1, NULL);
    gst_object_unref(bin);

	if (gst_element_set_state (pipeline, GST_STATE_PLAYING) == GST_STATE_CHANGE_FAILURE)
	{
		return FALSE;
	}
	
		loop = g_main_loop_new (NULL, FALSE);
		g_main_loop_run (loop);
		gst_element_seek(pipeline, 
                        1.0, GST_FORMAT_TIME, GST_SEEK_FLAG_FLUSH,
                        GST_SEEK_TYPE_SET, 0,
                        GST_SEEK_TYPE_NONE, GST_CLOCK_TIME_NONE);
						
		g_main_loop_unref (loop);
	}

  	gst_element_set_state (pipeline, GST_STATE_NULL);
	gst_object_unref (pipeline);
    g_source_remove (bus_watch_id);

	gst_deinit();
}