package com.gst_sdk_tutorials.tutorial_3;

import android.app.Activity;
import android.content.Context;
import android.net.wifi.WifiManager;
import android.net.wifi.WifiManager.MulticastLock;
import android.os.Bundle;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.ImageButton;
import android.widget.TextView;
import android.widget.Toast;

import com.gstreamer.GStreamer;

public class Tutorial3 extends Activity implements SurfaceHolder.Callback {
    private native void nativeInit();     // Initialize native code, build pipeline, etc
    private native void nativeFinalize(); // Destroy pipeline and shutdown native code
    private native void nativePlay();     // Set pipeline to PLAYING
    private native void nativePause();    // Set pipeline to PAUSED
    private static native boolean nativeClassInit(); // Initialize native class: cache Method IDs for callbacks
    private native void nativeSurfaceInit(Object surface1,Object surface2);
    private native void nativeSurfaceFinalize();
    private long native_custom_data;      // Native code will use this to keep private data

    SurfaceView sv1;     
    SurfaceView sv2;     
    
    SurfaceHolder sh1; 
    SurfaceHolder sh2; 
    
    boolean bInit1=false;
    boolean bInit2=false;
    
    // Called when the activity is first created.
    @Override
    public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);

        // Initialize GStreamer and warn if it fails
        try {
            GStreamer.init(this);
        } catch (Exception e) {
            Toast.makeText(this, e.getMessage(), Toast.LENGTH_LONG).show();
            finish(); 
            return;
        }

        setContentView(R.layout.main);

        sv1 = (SurfaceView) this.findViewById(R.id.surface_video1);
        sh1 = sv1.getHolder();
        sh1.addCallback(this);

        sv2 = (SurfaceView) this.findViewById(R.id.surface_video2);
        sh2 = sv2.getHolder();
        sh2.addCallback(this);
        
        nativeInit();
    }

    protected void onSaveInstanceState (Bundle outState) {
    }

    protected void onDestroy() 
    {
        nativeFinalize();
        super.onDestroy();
    }


    // Called from native code. Native code calls this once it has created its pipeline and
    // the main loop is running, so it is ready to accept commands.
    private void onGStreamerInitialized () {
            nativePlay();
    }

    static {
        System.loadLibrary("gstreamer_android");
        System.loadLibrary("tutorial-3");
        nativeClassInit();
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width,
            int height) {
        Log.d("GStreamer", "Surface changed to format " + format + " width "
                + width + " height " + height);
        
        if (holder==sh1) bInit1 = true;
        if (holder==sh2) bInit2 = true;
        
        if (bInit1 && bInit2)
        {
        	nativeSurfaceInit (sv1.getHolder().getSurface(),sv2.getHolder().getSurface());
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        Log.d("GStreamer", "Surface created: " + holder.getSurface());
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        Log.d("GStreamer", "Surface destroyed");
        nativeSurfaceFinalize ();
    }

}
