﻿/** \file hanwasen.h
    \brief Defines 阪和線, hanwa(-sen) line

Hanwa(-sen) line is the railway owned and operated by West Japan Railway Company.

*/

/** \brief 

Hanwa(-sen) line is the railway owned and operated by West Japan Railway Company.

*/
*/
namespace 阪和線
{

/** \brief the stations rapid service stops
*/
enum 快速停車駅
{
	天王寺, ///< ten-nou-zi (as si-ten-nou-zi temple)
	堺市, ///< sakai-si (sakai city)
	三国ヶ丘, ///< mikuni-ga-oka
	鳳, ///< ootori
	和泉府中, ///< izumi-hutyuu
	東岸和田, ///< higasi-kisiwada (east kisiwada station)
	熊取, ///< kumatori
	日根野, ///< hineno
	和泉砂川, ///< izumi-sunagawa
	紀伊, ///< kii
	六十谷, ///< musota
	和歌山, ///< wakayama
};

/** \brief the stations regional rapid service stops

This enumeration does not include the stations defined by 快速停車駅.
*/
enum 区間快速停車駅
{
	富木, ///< tonoki
	北信太, ///< kita-sinoda (north sinoda)
	信太山, ///< sinoda-yama
	久米田, ///< kumeda
	下松, ///< simomatu
	東貝塚, ///< higasi-kaiduka(east kaiduka)
	和泉橋本, ///< izumi-hasimoto
	東佐野, ///< higasi-sano
	長滝, ///< nagataki
	新家, ///< singe
	和泉鳥取, ///< izumi-tottori
	山中渓, ///< yamanakadani
	紀伊中ノ島, ///< kii-nakanosima
};

/** \brief the stations only local service stops

This enumeration does not include the stations defined by 快速停車駅 and 区間快速停車駅.
*/
enum その他の停車駅
{
	美章園, ///< bisyouen
	南田辺, ///< minami-tanabe
	鶴ケ丘, ///< turugaoka
	長居, ///< nagai
	我孫子町, ///< abiko-tyou
	杉本町, ///< sugimoto-tyou
	浅香, ///< asaka
	百舌鳥, ///< mozu
	上野芝, ///< uenosiba
	津久野, ///< tukuno
};

}