﻿/** \file movecost.h
    \brief Defines the class 移動費用

*/

/** \brief This class represents the transfer cost

The transfer cost is given by each methods.
*/
class 移動費用
{
public:
	/** \brief constructor
	
	\param i場所 the place you want to transfer
	*/
	移動費用( const wchar_t* i場所 ) : 場所( i場所 )
	{
	}
	
	/** \brief destructor
	
	Only to make this class inheritable. Do nothing.
	*/
	virtual ~移動費用()
	{
	}
	
	/** \brief by walking
	
	Returns tho cost by walking.
	
	\return the cost 
	*/
	int 徒歩()
	{
		return 1000;
	}

	/** \brief by bicycle
	
	Returns tho cost by bicycle.
	
	\return the cost 
	*/
	int 自転車()
	{
		return 500;
	}
	
	/** \brief by car
	
	Returns tho cost by car.
	
	\return the cost 
	*/
	int 自動車()
	{
		return 50;
	}
	
	/** \brief by train
	
	Returns tho cost by train.
	
	\return the cost 
	*/
	int 鉄道()
	{
		return 20;
	}
	
	/** \brief by ship
	
	Returns tho cost by ship.
	
	\return the cost 
	*/
	int 船舶()
	{
		return 100;
	}
	
	/** \brief by airplane
	
	Returns tho cost by airplane.
	
	\return the cost 
	*/
	int 飛行機()
	{
		return 3;
	}
	
	/** \brief by teleportation
	
	Returns tho cost by teleportation.
	
	\return the cost 
	*/
	int 瞬間移動()
	{
		return 1;
	}

protected:
	wchar_t* 場所; ///< The place to trasfer, given by constructor
};
