/// @file doxybug.cpp
///
/// @brief This file is a reproducer for the "operator minus-minus copydoc bug".
///
/// The bug appears in the documentation of class B. The bug is that when
/// Doxygen processes the command 
///
///     @ copydoc A::operator - - ()
///
/// it translates the `--` to `&ndash`, resulting in much confusion.
/// (Spaces added to the markdown code sample above, because otherwise 
/// the same bug triggers there, too.)

/// @brief Class A defines and documents the `operator --`.
struct A {
    /// Pre-decrement.
    A& operator--() { return *this; }
};

/// @brief Class B copies the documentation of `operator --` from class A, but
/// transforms "hyphen hyphen" to "\&ndash"!
struct B {
    /// @copydoc A::operator--()
    B& operator--() { return *this; }
};

/// @brief Class C also copies the documentation of `operator --` from class A,
/// but escaping the second hyphen works around the bug.
struct C {
    /// @copydoc A::operator-\-()
    C& operator--() { return *this; }
};