﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using HPS;

namespace Tests_cs
{
    class test_00750_publish_complex_export : Test
    {
        protected override Test.Result RunImpl(CppThread cpp, driver_data dtt)
        {
            WindowKey wk = dtt.window;
            Canvas canvas;
            canvas = Factory.CreateCanvas(wk);

            View view = Factory.CreateView();
            canvas.AttachViewAsLayout(view);
            Model model = Factory.CreateModel();
            view.AttachModel(model);

            SegmentKey modelKey = model.GetSegmentKey();
            modelKey.InsertDistantLight(new Vector(1, 1, 0));

            string INPUT_FOLDER = HMF_MASTER + "/exchange/prc";
            string OUTPUT_FOLDER = HMF_MASTER + "/ashtray";

//! [declarations]
HPS.Publish.DocumentKit documentKit = new HPS.Publish.DocumentKit();	    // corresponds to a particular view of the model
HPS.Publish.ViewKit viewKit = new HPS.Publish.ViewKit();                    // container for Javascript (if any) and views
HPS.Publish.ArtworkKit artworkKit = new Publish.ArtworkKit();           // represents the model as an object in the PDF
HPS.Publish.AnnotationKit annotationKit = new HPS.Publish.AnnotationKit();  // corresponds to a page inside the PDF
HPS.Publish.PageKit pageKit = new HPS.Publish.PageKit();                    // corresponds to the document itself as a whole
//! [declarations]


//! [setup_view]
CameraKit cameraKit;
cameraKit = CameraKit.GetDefault();
viewKit.SetCamera(cameraKit);
viewKit.SetExternalName("My custom view #1");
 
artworkKit.AddView(viewKit);
 
// add a second view
cameraKit.SetPosition(new Point(1, 1, 1));
viewKit.SetCamera(cameraKit);
viewKit.SetExternalName("My custom view #2");
 
artworkKit.AddView(viewKit);
//! [setup_view]


//! [annotation_kit]
SprocketPath sprocketPath = new SprocketPath(canvas, canvas.GetAttachedLayout(), view, model);
 
annotationKit.SetArtwork(artworkKit);
annotationKit.SetSource(sprocketPath);
 
// set B-rep ccompression to Medium
annotationKit.SetPRCBRepCompression(Publish.PRC.BRepCompression.Medium);
// use tessellation compression
annotationKit.SetPRCTessellationCompression(true);
 
// the IntRectangle specifies the area of the page this model will use
pageKit.SetAnnotation(annotationKit, new IntRectangle(50, 562, 50, 742));
documentKit.AddPage(pageKit);
 
Publish.File.Export(documentKit, "<filename>", new Publish.ExportOptionsKit());
//! [annotation_kit]


//! [template_kit]
Publish.TemplateKit templateKit = new Publish.TemplateKit();
templateKit.SetFile("<path to template file>");
 
// see note below about the "_1" suffix
templateKit.SetAnnotation("My3DWindow_1", annotationKit);
 
// filling out a few of the template's text fields
templateKit.SetTextValue("DocumentTitle_1", "BILL OF MATERIALS");
templateKit.SetTextValue("Part NameRow1_1", "Turbine engine");
templateKit.SetTextValue("SupplierRow1_1", "Tech Soft 3D");
 
documentKit.AddPage(templateKit);
 
Publish.File.Export(documentKit, "<filename>", new Publish.ExportOptionsKit());
//! [template_kit]

            return Test.Result.Success;
        }
    }
}
