#ifndef	B_H__
#define	B_H__

/**
 * @file b.h
 * Definitions of XYZ API.
 *
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
 * aaa aaa.  aaa aaa aaa aaa aaa aaa aaa aaa
 * aaa aaa aaa aaaaaa aaa:
 */


/**
 * aaa aaa aaa aaa aaa aaa.  aaa aaa aaa aaa aaa
 * aaa aaa aaa aaa aaa aaa aaa aaaaaa aaa aaa aaa aaa,
 * aaa aaa aaa aaa, aaa aaa aaa aaa aaa aaa.
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa()
 * aaa, aaa aaa bs_buf_databuf().  aaa aaa aaa aaa
 * aaa aaa aaa aaa.
 *
 * aaa aaa aaa aaa's aaa aaa aaa aaa @ref bs_buf aaa
 * aaa bs_buf_free().
 *
 * @see group_buffer
 */
typedef void *bs_buf;			/* opaque structure */


/**
 * aaa @ref bs_buf aaa aaa aaa aaa aaa aaa aaa aaa.
 * aaa @ref BSB_TYPE_INVALID aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa,
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa.
 *
 * @see
 *	@ref section_work_flow_psl
 */
typedef enum {
	BSB_TYPE_UNDEF		 = 0,	/**< aaa aaa aaa aaa */
	BSB_TYPE_INVALID	 = 1,	/**< aaa (aaa) aaa */
	BSB_TYPE_PSL		 = 2,	/**< aaa aaa aaa */

	/** aaa aaa.
	 * aaa aaa aaa aaa aaa aaa aaa aaa bs_compile_psl().
	 * aaa-aaa aaa.
	 * @internal
	 * aaa @ref group_instruction aaa aaa aaa.
	 * @endinternal
	 */
	BSB_TYPE_QUERY		 = 3,
	BSB_TYPE_IDXBIN		 = 6,

	BSB_TYPE_MAX		 = 7	/**< max defined bs_buf type */
} bsb_type_enum;


/**
 * aaa aaa bs_err aaa aaa aaa aaa aaa, aaa, aaa
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa.
 * @ref group_error "API functions" aaa aaa aaa aaa aaa aaa
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
 * @ref bs_error_type_enum "error type" (info, warning, error).
 *
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa.
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa, aaa aaa aaa
 * aaa aaa aaa aaa aaa aaa aaa aaa.  aaa aaa aaa aaa'aaa aaa
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa, aaa aaa
 * be done via the bs_err_free() API function.
 *
 * aaa aaa aaa aaa aaa aaa bs_err aaa aaa aaa aaa aaa
 * aaa aaa aaa.  aaa aaa, aaa aaa
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa
 * aaa aaa aaa aaa.
 *
 * @see
 * 	group_error
 */
typedef struct bs_err {
	/** aaa aaa (aaa aaa)
	 *
	 * aaa aaa aaa, \c aaa aaa \c aaa aaa aaa-aaa.
	 * aaa aaa aaa, \c aaa aaa \c aaa aaa aaa aaa:
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa;
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa.
	 */
	struct bs_err	*next;
	struct bs_err	*prev;		/**< previous error (or self) */
	int		offset;		/**< byte offset of error in input */
	int		linenum;	/**< line number of error location */
	int		charnum;	/**< char on line where error found */

	/** identifying number
	 *
	 * The \c errnum field identifies the specific message.
	 */
	int		errnum;
	char		type;		/**< category: @ref bs_error_type_enum "@c BS_ERROR_TYPE_..." */
 	/** human-readable string
	 *
	 * aaa aaa aaa, aaa aaa aaa-aaa aaa aaa.
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa
	 * aaa'aaa aaa aaa.
	 */
	char		errstr[0];
} bs_err;


/**
 * aaa aaa bs_string aaa aaa aaa aaa aaa aaa aaa,
 * aaa aaa aaa aaa aaa.  aaa aaa aaa aaa aaa
 * aaa aaa aaa aaa aaa aaa'aaa aaa.
 *
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa, aaa aaa aaa
 * aaa aaa aaa aaa aaa aaa aaa aaa.  aaa aaa aaa aaa'aaa
 * aaa aaa aaa aaa bs_string aaa aaa bs_string_free().
 */
typedef struct bs_string {
	struct bs_string	*next;		/**< next string (or self) */
	struct bs_string	*prev;		/**< previous string (or self) */
	char			string[0];	/**< string itself (with nil) */
} bs_string;


/**
 * aaa aaa aaa aaa aaa aaa aaa aaa.
 *
 * aaa bs_info aaa aaa aaa aaa aaa bs_version aaa aaa;
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa.
 *
 * aaa aaa aaa aaa, aaa aaa aaa, aaa aaa aaa aaa
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa "aaa" aaa.  aaa aaa
 * aaa aaa aaa aaa aaa aaa aaa.
 */
typedef struct bs_info {
	const short	major;		/**< major version number */
	const short	minor;		/**< minor version number */
	const short	tiny;		/**< tiny version number */
	const short	patch;		/**< patch version number */
	const char	*text;		/**< text version of version */
	const char	*c_date;	/**< compilation date */
	const char	*c_time;	/**< compilation time */
} bs_info;


/**
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa @ref bs_hitlist.
 * aaa aaa aaa aaa aaa aaa @ref group_searching "aaa..." aaa.
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa @ref bs_hitlist.
 *
 * See @ref group_searching for additional information.
 */
typedef struct bs_hit {
	/** match attributes: @ref bst_attrib_enum "BST_ATTRIB_..."
	 * 
	 * aaa aaa aaa aaa aaaaaa aaa aaa aaa
	 * aaa aaa aaa.  aaa aaa aaa aaa-aaa aaa
	 * (see @ref BS_SFLAG_ALL_TERMS), aaa aaa aaa aaa
	 * aaa aaa-aaa aaa aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa aaa.  See @ref bst_attrib_enum
	 * aaa aaa aaa aaa aaa aaa.
	 */
	unsigned char	attribs;	/* match attributes (below) */
	int		file;		/**< file number */

	/** aaa aaa
	 * 
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa.  aaa aaa aaa aaa aaa aaa aaa aaa aaa,
	 * aaa aaa aaa aaa aaaaaa aaa aaa aaa.
	 */
	int		query;

	/** document number
	 * 
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa.
	 * aaa aaa, aaa aaa aaa aaa aaa'aaa aaa aaa aaa
	 * aaa aaa aaa aaa.  aaa aaa aaa aaa aaa 0,
	 * aaa aaa aaa 1, aaa aaa aaa.
	 */
	int		doc;

	/** aaa aaa aaa aaa aaa
	 * 
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
	 * "aaa" aaa.  aaa aaa aaa aaa "aaa (aaa) aaa",
	 * aaa aaa aaa aaa aaa aaa aaa aaa "aaa" aaa aaa
	 * aaa aaa aaa aaa.  aaa aaa aaa aaa aaa aaa aaa
	 * "aaa aaa aaa" aaa, aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa.
	 */
	int		score;

	/** aaa aaa aaa aaa aaa aaa aaa.
	 * 
	 * aaa bs_hit.aaa aaa bs_hit.aaa aaa aaa aaa aaa
	 * (aaa-aaa) aaa aaa aaa aaa aaa aaa aaa.
	 * aaa aaa aaa aaa, aaa aaa aaa aaa aaa aaa
	 * aaa.  aaa aaa-aaa aaa (@ref BS_SFLAG_ALL_TERMS),
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa-aaa
	 * aaa aaa aaa aaa aaa, aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa aaa aaa-aaa aaa aaa aaa aaa aaa aaa.
	 */
	long		start;
	long		end;		/**< offset in data of end of hit */

	/** aaa aaa aaa aaa aaa aaa aaa.
	 * 
	 * aaa aaa aaa aaa aaa aaa-aaa aaa aaa aaa aaa'aaa
	 * aaa aaa, aaa aaa aaa <i>aaa aaa aaa aaa</i>
	 * aaa aaa aaa aaa aaa.  aaa, aaa aaa 0, aaa
	 * bs_hit.aaa aaa aaa aaa bs_hit.aaa aaa aaa aaa.
	 */
	long		docpos;
} bs_hit;


/**
 * aaa aaa aaa aaa aaa aaa aaa aaa-aaa aaa, aaa aaa aaa aaa aaa
 * aaa aaa aaa aaa aaa aaa aaa.
 *
 * aaa aaa-aaa aaa, aaa bs_hit.aaa aaa
 * aaa aaa aaa aaa aaa aaa aaa.  aaa aaa-aaa aaa,
 * all bs_hit.attribs fields will be non-zero, with
 * at least one of @ref BST_ATTRIB_POS or @ref BST_ATTRIB_NEG set.
 *
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa,
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa;
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa
 * aaa aaa aaa aaa.
 *
 * aaa aaa aaa aaa aaa aaa aaa, aaa-aaa aaa aaa
 * aaa aaa aaa-aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa.
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa, aaa aaa
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
 * aaa.  aaa aaa aaa aaa aaa aaa aaa; aaa aaa aaa aaa aaa aaa aaa
 * aaa aaa.
 *
 * aaa aaa aaa aaa aaa aaa aaa aaa-aaa aaa aaa aaa aaa aaa
 * aaa aaa aaa @ref BS_SFLAG_SMART_TERMS aaa aaa aaa aaa aaa (aaa)
 * bs_find_params.sflags aaa aaa aaa bs_find_data_hits().
 * aaa aaa aaa aaa aaa, aaa aaa aaa aaa aaaaa aaa
 * aaa aaa a @ref bs_hit aaa aaa aaa aaa aaa aaa
 * aaa aaa aaa'aaa aaa.  (aaa, aaa aaa aaa aaa aaa aaa
 * aaa aaa aaa aaa, aaa aaa aaa aaa aaa aaa-aaa aaa.)
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
 * aaa aaa aaa bs_hit.aaa aaa, aaa aaa aaa aaa
 * aaa aaa aaa aaa aaa-aaa.
 *
 *
 * aaa aaa aaa aaa aaaaaa aaaaaall aaa aaa aaa aaa:
 *
 * @code
 *    "aaa" { 2 aaa -> 'aaa' aaa 'aaa' aaa aaa 'aaa' }
 * @endcode
 *
 * aaa aaa aaa aaa aaa (aaa aaa aaa aaa aaa).
 * aaa aaa aaa aaa aaa aaa aaa-aaa aaa, aaa aaa aaa aaa
 * aaa aaa aaa aaa aaa, aaa aaa aaa aaa aaa aaa
 * aaa aaa aaa:
 *
 * @code
 *    "\0x0A===EOD===\0x0A"  BST_ATTRIB_POS | BST_ATTRIB_RESET
 *    "DATELINE"             BST_ATTRIB_POS | BST_ATTRIB_ANCHOR
 *    paragraphs             BST_ATTRIB_POS | BST_ATTRIB_EXTENT
 *    'flash'                BST_ATTRIB_POS
 *    'gordon'               BST_ATTRIB_POS
 *    'superman'             BST_ATTRIB_NEG
 * @endcode
 *
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa.  aaa aaa,
 *
 * @code
 *    { 1 document -> 'fresh' and 'fish' }
 * @endcode
 *
 * aaa "\0x0A===aaa===\0x0A" aaa aaa: aaa aaa aaa aaa aaa
 * aaa aaa aaa aaa aaa aaa aaa aaa.  aaa aaa aaa aaa-aaa aaa,
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa:
 * aaa aaa aaa aaa aaa, aaa aaa aaa aaa aaa aaa aaa aaa.
 */
typedef enum {
	/** aaa (aaa-aaa) aaa
	 *
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa "aaa" aaa
	 * (aaa aaa aaa aaa).  aaa.aaa., aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa aaa.
	 */
	BST_ATTRIB_POS		= 0x01,

	/** aaa (aaa-aaa) aaa
	 *
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa "aaa" aaa.
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa.
	 */
	BST_ATTRIB_NEG		= 0x02,

	/** aaa aaa aaa aaa aaa
	 *
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa.
	 */
	BST_ATTRIB_RESET	= 0x04,

	/** aaa aaa aaa aaa aaa
	 *
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa.
	 */
	BST_ATTRIB_ANCHOR	= 0x08,

	/** aaa aaa aaa aaa aaa
	 *
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa.
	 */
	BST_ATTRIB_EXTENT	= 0x10,

	/** aaa aaa aaa aaa aaa
	 *
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa.
	 */
	BST_ATTRIB_CONT		= 0x20
} bst_attrib_enum;


/**
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa.
 * aaa aaa aaa aaa, aaa aaa @ref group_searching "aaa..."
 * aaa.
 *
 * aaa aaa aaa aaaaaas aaa aaa aaa aaa @ref bs_hitlist
 * aaa aaa bs_hitlist_free().
 */
typedef void *bs_hitlist;			/* opaque structure */


/**
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa
 * aaa aaa aaa aaa aaa @ref bs_buf.  aaa aaa bs_query_get_info()
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa.  aaa aaa aaa aaa aaa
 * aaa aaa aaa aaa aaa bs_query_info.more field.
 *
 * -  A @ref bs_buf aaa aaa aaa aaa aaa a
 *    aaa aaa aaa aaa [0] aaa .aaa == 0.
 * -  A @ref bs_buf aaa aaa aaa aaa a
 *    aaa aaa aaa aaa [0] has .more == 2,
 *    aaa [1] aaa .aaa == 1, aaa aaa [2] has .more == 0.
 */
typedef struct bs_query_info {
	int		more;		/**< subsequent bs_query_info entries */
	char		*fname;		/**< name of source file */
	char		*qname;		/**< name of query */
	char		*info;		/**< query info (newline separators) */
	int		ops;		/**< number of BS ops in query */
	int		len;		/**< length of saved version of query */
} bs_query_info;


/**
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
 * aaa bs_build_qsets().  aaa aaa aaa aaa aaa aaa aaa
 * aaa aaa aaa aaa aaa aaa aaa aaaaaa  aaa aaa aaa aaa
 * aaa, aaa bs_build_qsets() aaa aaa aaa aaa aaa aaa NULL
 * @ref bs_qset_limits aaa.  aaa aaa-aaa aaa aaa, aaa
 * @ref bs_qset_limits aaa aaa aaa aaa aaa
 * bs_qset_get_limits(), aaa aaa aaa aaa aaa aaa aaa.

 * aaa aaa aaa aaa,
 * @li aaa aaa aaa aaa (or @ref BS_QSET_LIMIT_NONE)
 *	aaa aaa aaa aaa aaa aaa aaa.
 * @li aaa aaa aaa aaa1 (or @ref BS_QSET_LIMIT_DEFAULT)
 * 	aaa aaa aaa XYZ system default limit
 * 	aaa aaa aaa.
 *
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa
 * aaa aaa @ref bs_qset_limits aaa aaa aaa aaa aaa
 * aaa aaa @ref BS_QSET_LIMIT_DEFAULT aaa aaa aaa aaa
 * aaa aaa aaa a @ref bs_qset_limits aaa aaa aaa.
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
 * aaa aaa aaa aaa aaa.
 *
 * See @ref bs_qset_limit_enum aaa aaa aaa aaa to
 * aaa aaa.
 *
 * See @ref section_qset_construction for additional information.
 *
 * aaa aaa aaa aaa aaa aaa; aaa aaa aaa aaa aaa aaa.
 */
typedef struct bs_qset_limits {
	/** aaa aaa aaa aaa aaa aaa.
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa.
	 * aaa aaa, aaa aaa aaa aaa aaa @ref BS_QSET_LIMIT_NONE.
	 */
	int		max_qsets;

	/** aaa aaa aaa aaa aaa aaa aaa.
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa aaa aaa.  aaa aaa, aaa aaa aaa
	 * the value @ref BS_QSET_LIMIT_NONE.
	 */
	int		max_fsas;

	/** aaa aaa aaa aaa aaa aaa.
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa.  aaa aaa, aaa aaa aaa aaa aaa
	 * @ref BS_QSET_LIMIT_STATES.
	 */
	int		max_states;

	/** aaa aaa aaa aaa-aaa aaa.
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa aaa-aaa aaa aaa aaa aaa.
	 * aaa aaa, aaa aaa aaa aaa aaa
	 * @ref BS_QSET_LIMIT_PRE_CLOSE.
	 */
	int		max_pre_close;

	/** aaa aaa aaa aaa aaa aaa.
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa.
	 * By default, this parameter has the value @ref BS_QSET_LIMIT_EXPAND.
	 */
	int		max_expand;

	/** aaa aaa aaa aaa aaa aaa aaa aaa.
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa aaa aaa.  aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa aaa, aaa aaa, aaa
	 * aaa aaa aaa aaa aaa aaa aaa aaa.  aaa aaa aaa
	 * for this parameter is @ref BS_QSET_LIMIT_ANY_TIME.
	 */
	int		max_any_time;

	/** aaa aaa aaa aaa aaa.
	 */
	int		min_reducto;

	/** aaa aaa aaa aaa aaa aaa.
	 * aaa aaa-aaa, aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa aaa.  aaa aaa aaa aaa aaa
	 * parameter is @ref BS_QSET_LIMIT_FSA_SPACE.
	 */
	ulong		max_fsa_space;

	/** aaa aaa aaa aaa aaa.
	 */
	int		max_b_ext;

	/** aaa aaa aaa aaa.
	 */
	int		max_cs_ext;

	/** aaa aaa aaa-aaa aaa.
	 */
	int		max_ncs_ext;

	/** aaa aaa aaa-aaa aaa aaa.
	 */
	int		max_nwc_ext;

	/** aaa aaa aaa-aaa aaa.
	 */
	int		max_nws_ext;

	/** aaa aaa aaa aaa aaa.
	 */
	int		max_wc_ext;

	/** aaa aaa aaa aaa.
	 */
	int		max_ws_ext;

	/** aaa aaa aaa aaa aaa.
	 */
	int		mize_msig;

	/** aaa aaa aaa aaa/aaa aaa.
	 */
	int		mize_loops;

	/** aaa aaa aaa aaa aaa aaa.
	 */
	int		mize_max;
} bs_qset_limits;


/**
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa
 * aaa aaa aaa.  aaa aaa bs_qset_get_info() aaa
 * aaa aaa aaa aaa aaa aaa aaa aaa.  aaa aaa aaa aaa aaa aaa
 * aaa aaa aaa aaa bs_qset_info.aaa aaa.
 *
 * -  aaa bs_buf aaa aaa aaa aaa aaa aaa bs_qset_info aaa
 *    aaa aaa [0] aaa .aaa == 0.
 * -  aaa bs_buf aaa aaa aaa aaa aaa bs_qset_info aaa
 *    aaa aaa [0] aaa .aaa == 2, aaa [1] aaa .aaa == 1,
 *    aaa aaa [2] aaa .aaa == 0.
 */
typedef struct bs_qset_info {
	int		more;		/**< subsequent bs_qset_info entries */
	int		qset_id;	/**< ID of this query set */
	int		queries;	/**< number of queries in qset */
	int		low_qid;	/**< lowest query ID */
	int		conblks;	/**< number of conblks in qset */
	int		resets;		/**< number of shared reset conblks */
	int		extents;	/**< number of shared extent conblks */
	int		shared;		/**< number of shared logic segments */
	int		fsas;		/**< total number of FSAs in qset */
	int		cfsas;		/**< number of closed FSAs */
	int		ffsas;		/**< number of forward FSAs */
	int		rfsas;		/**< number of reverse FSAs */
	long		states;		/**< total states in all qset's FSAs */
	long		memsize;	/**< all allocated memory for this qset */
	ulong		term_hits;	/**< total term hits for all conblks */
} bs_qset_info;


/**
 * aaa aaa bs_qset_info aaa aaa aaa aaa bs_qset_get_info() aaa,
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
 * aaa aaa aaa aaa aaa bs_qset_get_query_info() aaa, aaa aaa
 * aaa aaa aaa aaa aaa aaa, aaa aaa aaa.
 */
typedef struct bs_qset_query_info {
	int		more;		/**< subsequent bs_qset_info entries */
	int		qset_id;	/**< ID of containing query set */
	int		query_id;	/**< ID of this query */
	int		status;		/**< query status (BS_QUERY_STATE_xxx) */
	int		conblks;	/**< number of conblks in query */
	char		*fname;		/**< name of source file */
	char		*qname;		/**< name of query */
} bs_qset_query_info;


/**
 * aaa bs_find_data_hits() aaa aaa aaa aaa aaa aaa aaa aaa aaa
 * aaa aaa aaa aaa aaa bs_find_params aaa aaa aaa aaa aaa
 * aaa aaa aaa aaa aaa.

 * aaa aaa, aaa aaa aaa aaa aaa aaa aaa aaa aaa,
 * bs_find_data_hits aaa aaa aaa aaa, aaa aaa aaa aaa.
 * aaa aaa aaa aaa, aaa bs_find_params aaa aaa aaa aaa aaa aaa aaa
 * aaa aaa aaa aaa aaa aaa/aaa.  aaa aaa aaa aaa aaa aaa aaa
 * aaa bs_find_params aaa aaa aaa aaa bs_find_params.f_offset
 * aaa aaa aaa bs_find_params.aaa aaa aaa aaa aaa aaa aaa aaa
 * aaa aaa aaa.  aaa aaa aaa, aaa aaa aaa aaa aaa aaa
 * aaa aaa aaa aaa aaa bs_hit.aaa aaa aaa aaa.
 * 
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
 * aaa "aaa" aaa "aaa aaa" aaa.  aaa, aaa aaa "aaa aaa"
 * aaa aaa aaa aaa aaa aaa' aaa aaa, aaa' "aaa" aaa "aaa"
 * aaa aaa aaa aaa.  aaa "aaa" aaa, aaa aaa' "aaa"
 * aaa "aaa" aaa aaa aaa.
 */
typedef struct bs_find_params {
	int		q_offset;	/**< offset for hits' query field */
	int		f_offset;	/**< offset for hits' file field */
	int		d_offset;	/**< offset for hits' doc field */
	long		p_offset;	/**< offset for hits' start/end fields */

	/** aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa aaa aaa.  aaa aaa aaa aaa, aaa
	 * aaa aaa aaa.
	 */
	long		max_hits;

	/** aaa aaa: @ref bs_sflag_enum "BS_SFLAG_..."
	 * 
	 * aaa aaa aaa aaa aaa (aaa.aaa., aaa aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa).  aaa aaa aaa
	 * @ref BS_SFLAG_SMART_TERMS aaa aaa aaa aaa, aaa @ref bs_hitlist
	 * aaa aaa aaa aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa aaa.  aaa aaa aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa bs_hit.aaa aaa: aaa
	 * aaa aaa aaa aaa aaa aaa aaa-aaa, aaa aaa aaa aaa aaa aaa aaa.
	 * @see bs_hit, bs_sflag_enum
	 */
	ulong		sflags;

	/** aaa aaa aaa aaa aaa.
	 * aaa bs_find_data_hits() aaa aaa aaa @ref bs_hitlist
	 * aaa aaa aaa aaa.  aaa aaa aaa aaa-aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa.
	 */
	bs_hitlist	*hp;
} bs_find_params;


/**
 * aaa bs_macro aaa aaa aaa aaa aaa aaa @ref BS_CALLBACK_MACROS aaa
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa.
 */
typedef struct bs_macro {
	char		*name;		/**< name of macro */
	short		query;		/**< query number in input file */
	short		level;		/**< definition level */
	short		nargs;		/**< number of arguments */
	int		uses;		/**< instantiation count in this query */
	char		*args;		/**< space-separated list of arguments */
	char		*value;		/**< macro's value */
} bs_macro;


/**
 * aaa aaa-aaa aaa aaa aaa aaa bs_callback_set()
 * aaa aaa aaa @ref bs_callbackhandler aaa.
 * @li aaa aaa aaa aaa aaa aaa aaa aaa @ref bs_token
 * aaa, aaa aaa by brutesquad_token.h.
 * @li aaa aaa aaa aaa aaa @ref bs_macro structure.
 *
 * @see
 * 	bs_callback_enum,
 * 	bs_callback_set
 */
typedef void (*bs_callbackhandler)(void *);


/**
 * aaa aaa aaa aaa aaa aaa
 * aaa aaa.  aaa bs_callback_set()
 * aaa aaa aaa.
 *
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
 * aaa aaa aaa aaa.  aaa aaa aaa aaa aaa
 * bs_callback_set() aaa aaa aaa aaa aaa aaa aaa aaa aaa
 * aaa aaa aaa aaa.

 * aaa aaa aaa aaa aaa aaa aaa aaa-aaa aaa.
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
 * aaa aaa aaa.  aaa aaa aaa.  aaa aaa aaa
 * aaa aaa aaa aaa* aaa aaa aaa aaa aaa aaa.
 *
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa
 * aaa aaa aaa aaa aaa: aaa aaa aaa aaa aaa,
 * aaa aaa aaa aaa aaa aaa.  aaa aaa aaa aaa
 * aaa aaa aaa aaa aaa.
 *
 * aaa, aaa @ref bs_err aaa aaa aaa aaa aaa
 * aaa aaa aaa aaa aaa: aaa aaa aaa aaa -- aaa bs_err_free() --
 * aaa aaa aaa aaa aaa aaa aaa.  (aaa bs_err aaa aaa aaa aaa
 * aaa: aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa.)
 *
 * @see bs_callback_set
 */
typedef enum {
	/** aaa aaa aaa'aaa aaa aaa.
	 * aaa aaa aaa aaa aaa aaa (aaa aaa).
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa aaa.  aaa aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa aaa aaa aaa.  (aaa, aaa aaa
	 * aaa aaa aaa aaa aaa, aaa aaa aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa.)
	 *
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa.
	 *
	 * aaa aaa aaa, aaa aaa, aaa aaa aaa aaa aaa,
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa.
	 *
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
	 * a @ref bs_hit pointer.  The bs_hit.query field is unused
	 * aaa aaa aaa.  aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa.  aaa aaa aaa aaa aaa
	 * aaa aaa.
	 */
	BS_CALLBACK_QUERY_RESETS     = 4,

	/** aaa aaa aaa.
	 * aaa aaa aaa aaa aaa aaa aaa.  aaa aaa aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa.
	 *
	 * aaa aaa aaa aaa aaa aaa aaa.  aaa aaa aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa aaa, aaa aaa @ref bs_hitlist
	 * aaa aaa; bs_find_data_hits() aaa aaa aaa aaa.
	 *
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
	 * a @ref bs_hit pointer.
	 */
	BS_CALLBACK_DATA_HITS	     = 5,

	/** aaa aaa aaa aaa aaa.
	 */
	BS_CALLBACK_MACROS	     = 6,

	/** aaa aaa aaa aaa.
	 */
	BS_CALLBACK_MAX		     = 6
} bs_callback_enum;


/*
 * aaa aaa aaa aaa aaa, aaa aaa aaa aaa aaa aaa
 * aaa aaa.  aaa "PSL_SET_FILENAME" aaa aaa aaa aaa aaa
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa, aaa aaa aaa
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa.
 * (aaa "%aaa" aaa aaa aaa aaa aaa aaa aaa, aaa.aaa., PSL_SET_FILENAME
 * aaa aaa aaa aaa aaa aaa aaa() aaa aaa.)
 */
#define	PSL_RESET_QUERY		"##RESET\n"	/* query reset command */
#define	PSL_SET_FNAME		"/*$F:%s*/\n"	/* source file name command */
#define	PSL_RESET_LNUM		"/*$R*/\n"	/* position reset command */
#define	PSL_RESET_QUERY_LEN	 8		/* length of PSL_RESET_QUERY */
#define	PSL_SET_FNAME_LEN	 8		/* length without "%s" */
#define	PSL_RESET_LNUM_LEN	 7		/* length of PSL_RESET_LNUM */


/**
 * aaa aaa aaa aaa aaa aaa aaa aaa bs_compile_psl().
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa.
 */
typedef enum {
	/** aaa aaa aaa aaa.
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa-aaa
	 * aaa.  aaa aaa aaa aaa aaa aaa aaa aaa aaa
	 * aaa bs_build_qsets() aaa aaa aaa aaa BS_QFLAG_xxx_TERMS aaa aaa.
	 *
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa.  aaa aaa,
	 * aaa aaa aaa aaa aaa aaa aaa aaa-aaa aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa bs_compile_psl() aaa.
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa '<!' aaa '!>' aaa aaa aaa aaa.  aaa aaa
	 * aaa, aaa aaa aaa aaa.
	 *
	 * @ref bs_qflag_enum
	 */
	BS_CFLAG_SHOW_TERMS	= 0x000001,

	/** aaa aaa aaa.
	 * aaa aaa aaa aaa aaa aaa.  aaa aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa.
	 *
	 * aaa aaa aaa aaa, aaa aaa aaa
	 * aaa aaa, aaa aaa aaa-aaa aaa aaa aaa aaa aaa
	 * aaa (i.e., aaa aaa) aaa aaa aaa, aaa aaa
	 * aaa aaa "*" aaa aaa aaa aaa aaa aaa.
	 *
	 * aaa aaa aaa aaa aaa aaa aaa aaa
	 * @c BS_CFLAG_IDX_MODE aaa, aaa aaa aaa aaa @ref BS_QFLAG_IDX_NORMAL
	 * or @ref BS_QFLAG_IDX_INVERT must be set.
	 *
	 * @see
	 * 	bs_build_qsets,
	 * 	bs_qflag_enum
	 */
	BS_CFLAG_IDX_MODE	= 0x000002
} bs_cflag_enum;


/**
 * aaa aaa aaa aaa aaa aaa aaa bs_build_qsets().
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa'aaa aaa aaa
 * aaa aaa aaa aaa aaa.  aaa aaa aaa
 * aaa aaa aaa aaa.  aaa, aaa aaa aaa aaa aaa aaa
 * aaa aaa aaa bs_build_qsets().  aaa aaa aaa,
 * aaa bs_build_qsets() aaa aaa aaa aaa aaa "aaa" aaa.
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa, aaa aaa aaa aaa
 * aaa aaa aaa.  aaa aaa aaa aaa aaa aaa aaa aaa,
 * bs_build_qsets() aaa aaa aaa aaa aaa aaa aaa "aaa"
 * aaa aaa.  aaa, aaa aaa aaa, aaa aaa aaa aaa
 * bs_build_qsets() aaa aaa aaa aaa aaa "aaa" aaa, aaa
 * aaa aaa "aaa" aaa.
 * 
 * aaa aaa aaa @ref BS_QFLAG_FFWD_ONLY aaa aaa bs_build_qsets(),
 * aaa aaa aaa aaa "aaa" aaa aaa aaa; aaa aaa aaa aaa
 * aaa, aaa aaa aaa aaa.  aaa aaa aaa
 * @ref BS_QFLAG_REVERSE aaa, aaa aaa aaa aaa "aaa" aaa
 * aaa aaa aaa aaa aaa.  aaa aaa aaa aaa aaa aaa aaa, aaa
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
 * "aaa" aaa.
 *
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa.  aaa aaa aaa
 * aaa, aaa aaa aaa (aaa aaa aaa "aaa aaa") aaa aaa aaa.
 */
typedef enum {
	/** aaa'aaa aaa aaa aaa aaa aaa.
	 * aaa aaa aaa aaa aaa-aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa.
	 *
	 * aaa aaa aaa aaa aaa aaa.
	 */
	BS_QFLAG_NO_RESET	= 0x000100,

	/** aaa'aaa aaa aaa aaa aaa.
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa.  aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa aaa'aaa aaa aaa aaa aaa aaa
	 * aaa.  aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa; aaa aaa aaa aaa aaa aaa.
	 */
	BS_QFLAG_NO_REDUCE	= 0x000200,

	/** aaa'aaa aaa aaa.
	 * aaa aaa aaa aaa aaa.  aaa aaa aaa aaa aaa,
	 * aaa aaa aaa aaa (aaa aaa aaa aaa) aaa aaa
	 * aaa aaa aaa; aaa aaa aaa aaa aaa aaa.
	 *
	 * aaa aaa @ref BS_QFLAG_NO_MINIMIZE aaa aaa aaa aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa: aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa aaa,
	 * aaa aaa aaa aaa.
	 */
	BS_QFLAG_NO_MINIMIZE	= 0x000400,

	/** aaa aaa aaa aaa aaa.
	 * aaa aaa, aaa aaa aaa aaa (aaa) aaa.
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa,
	 * aaa aaa aaa aaa aaa.
	 *
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa.
	 *
	 * aaa aaa aaa @ref BS_QFLAG_FFWD_ONLY aaa, aaa aaa aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa.
	 * aaa aaa aaa @ref BS_QFLAG_FFWD_ONLY aaa @ref BS_QFLAG_REV_ONLY
	 * aaa aaa aaa aaa.  aaa aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa, aaa, aaa aaa
	 * aaa aaa aaa, aaa aaa aaa aaa aaa aaa.
	 */
	BS_QFLAG_FFWD_ONLY	= 0x000800,
	BS_QFLAG_FORWARD	= 0x000800,	/**<    OLD NAME of FFWD_ONLY */

	/** aaa aaa aaa aaa.
	 * aaa aaa, aaa-aaa aaa aaa aaa (aaa) aaa
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa.
	 *
	 * aaa aaa aaa aaa aaa aaa aaa, aaa aaa aaa aaa
	 * aaa aaa aaa.  aaa, aaa aaa aaa aaa aaa
	 * aaa aaa, aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa.
	 *
	 * aaa aaa aaa @ref BS_QFLAG_REV_ONLY flag, aaa aaa aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa
	 * aaa.  aaa aaa aaa @ref BS_QFLAG_FFWD_ONLY and
	 * @ref BS_QFLAG_REV_ONLY aaa aaa aaa aaa.  aaa aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa, aaaaaa aaa aaa
	 * aaa aaa aaaaaa aaa aaa aaa aaa aaa aaa.
	 */
	BS_QFLAG_REV_ONLY	= 0x001000,
	BS_QFLAG_REVERSE	= 0x001000,	/**<    OLD NAME of REV_ONLY */

	/** aaa aaa aaa.
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa.  aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa.
	 * (aaa.aaa., aaa aaa "aaa" aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa "aaa", "aaa", "aaa".)
	 *
	 * aaa aaa aaa, aaa aaa aaa @ref BS_QFLAG_IDX_NORMAL or
	 * @ref BS_QFLAG_IDX_INVERT aaa aaa aaa.  aaa, aaa aaa
	 * aaa aaa @ref BS_QFLAG_FFWD_ONLY or @ref BS_QFLAG_REV_ONLY
	 * aaa aaa aaa supplied.
	 */
	BS_QFLAG_IDX_NORMAL	= 0x002000,
	BS_QFLAG_IDX_FORWARD	= 0x002000,	/**<    OLD NAME of IDX_NORMAL */

	/** aaa aaa aaa.
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa.  aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa.
	 * (aaa.aaa., aaa aaa "aaa" aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa "aaa", "aaa", "aaa".)
	 *
	 * aaa aaa aaa, aaa aaa aaa @ref BS_QFLAG_IDX_NORMAL or
	 * @ref BS_QFLAG_IDX_INVERT aaa aaa aaa.  aaa, aaa of
	 * aaa aaa @ref BS_QFLAG_FFWD_ONLY or @ref BS_QFLAG_REV_ONLY
	 * aaa aaa aaa aaa.
	 */
	BS_QFLAG_IDX_INVERT	= 0x004000,
	BS_QFLAG_IDX_REVERSE	= 0x004000,	/**<    OLD NAME of IDX_INVERT */

	/** aaa'aaa aaa aaa-aaa aaa.
	 * aaa-aaa aaa aaa aaa "*" (aaa.aaa., 'aaa*') aaa aaa aaa aaa
	 * aaa aaa aaa aaa aaa aaa-aaa-aaa aaa aaa aaa.  (aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa, aaa aaa aaa.)  aaa
	 * aaa aaa aaa aaa aaa aaa aaa, aaa aaa-aaa aaa
	 * aaa aaa aaa aaa aaa aaa.  aaa aaa aaa aaa aaa, aaa
	 * aaa aaa-aaa aaa aaa aaa aaa aaa aaa aaa.
	 *
	 * aaa aaa aaa aaa aaa aaa aaa "aaa" aaa aaa aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa.  aaa aaa aaa aaa,
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa.
	 */
	BS_QFLAG_KEEP_WEND	= 0x010000
} bs_qflag_enum;


/**
 * aaa aaa aaa aaa aaa aaa bs_find_params.aaa
 * aaa aaa aaa bs_find_data_hits().
 *
 * aaa aaa aaa aaa aaa aaa aaa aaa.
 * 
 * @attention
 * The @ref BS_SFLAG_SMART_TERMS mode is documented but not
 * fully implemented.
 *
 * aaa aaa aaa aaa, aaa aaa aaa aaa aaa aaa aaa
 * aaa aaa aaa, aaa aaa aaa' aaa aaa aaa, aaa aaa aaa-aaa
 * aaa aaa aaa.  aaa aaa-aaa aaa aaa, aaa aaa aaa'
 * aaa aaa aaa aaa aaa, aaa aaa aaa aaa aaa aaa aaa.
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa
 * should typically be built with the @ref BS_QFLAG_REV_ONLY flag set.
 */
typedef enum {
	/** aaa aaa aaa.
	 * aaa a @ref bs_hit aaa aaa aaa aaa aaa aaa; aaa aaa aaa
	 * aaa aaa.  aaa aaa aaa aaa aaa @ref bs_hit aaa aaa
	 * aaa aaa aaa aaa aaa aaa.  aaa aaa aaa
	 * aaa aaa aaa.
	 */
	BS_SFLAG_ALL_TERMS	= 0x010000,

	/** aaa aaa aaa aaa.
	 * aaa aaa @ref bs_hit aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa aaa; aaa aaa aaa aaa aaa.
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa.
	 */
	BS_SFLAG_HIT_TERMS	= 0x020000,

	/** aaa aaa aaa aaa aaa.
	 * aaa aaa @ref bs_hit aaa aaa aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa; aaa aaa aaa aaa aaa.  aaa aaa aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaaaaa as aaa aaa the
	 * aaa aaa.  aaa aaa aaa aaa aaa aaa aaa aaa.
	 */
	BS_SFLAG_SMART_TERMS	= 0x040000
} bs_sflag_enum;


/*
 * Various other limits.
 */
#define	BS_MAX_AC_CHAR_COUNT	      25	/* max n for @anychar(n) */
#define	BS_MAX_WC_CHAR_COUNT	      25	/* max n for @wordchar(n) */
#define	BS_MAX_NWC_CHAR_COUNT	     100	/* max n for @nonwordchar(n) */
#define	BS_MAX_NUMBER   9999999999999999LL	/* max @number() value */

/*
 * aaa aaa aaa.
 */
#define	BS_DEFAULT_DATA_PAD	'\n'		/* padding for data buffers */

/**
 * aaa aaa aaa aaa aaa aaa bs_hitlist_print().
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa.
 */
typedef enum {
	BS_HIT_FMT_6FIELD	= 1,	/**< "*** match" and six fields */
	BS_HIT_FMT_6FIELD_DATA	= 2,	/**< above with matching data */
	BS_HIT_FMT_PARACEL_TEST	= 3,	/**< Paracel test output format */
	BS_HIT_FMT_HIT_DATA	= 4,	/**< hit data with lineend */
	BS_HIT_FMT_JON_DATA	= 5,	/**< Jon's data format */
	BS_HIT_FMT_8FIELD	= 6,	/**< "Match" and eight fields */
	BS_HIT_FMT_DOCPOS	= 7,	/**< 8FIELD plus hit offset in document */
	BS_HIT_FMT_MAX		= 7,	/**< max defined format value */

	BS_DEFAULT_HIT_FORMAT	= BS_HIT_FMT_6FIELD	/**< for test programs */
} bs_hit_fmt_enum;


/**
 * aaa bs_err aaa aaa aaa bs_err.aaa aaa aaa aaa aaa
 * aaa aaa aaa aaa aaa, aaa, aaa aaa aaa.
 */
typedef enum {
	/** aaa aaa.
	 * aaa aaa aaa aaa aaa.
	 * aaa aaa aaa aaa aaa aaa aaa.
	 */
	BS_ERROR_TYPE_ERROR	= 1,

	/** aaa aaa.
	 * aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa aaa aaa.  aaa aaa
	 * aaa aaa, aaa aaa aaa aaa aaa
	 * aaa aaa aaa aaa aaa aaa.
	 */
	BS_ERROR_TYPE_WARNING	= 2,

	/** aaa aaa.
	 * aaa aaa aaa aaa aaa aaa.
	 * aaa aaa aaa aaa aaa aaa aaa aaa'aaa aaa.
	 */
	BS_ERROR_TYPE_INFO	= 3
} bs_error_type_enum;


/**
 * aaa aaa bs_merge_xxx() aaa' "aaa" aaa: aaa aaa aaa
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa.
 */
typedef enum {
	BSB_DEST_NEW	= 0,	/**< build a new bs_buf */
	BSB_DEST_1	= 1,	/**< first source is dest */
	BSB_DEST_2	= 2	/**< second source is dest */
} bsb_dest_enum;

/**
 * aaa aaa aaa aaa aaa @ref bs_qset_limits aaa.
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa.
 */
typedef enum {
	/** aaa aaa aaa aaa aaa.
	 * aaa aaa aaa aaa @ref bs_qset_limits aaa aaa aaa aaa.
	 */
	BS_QSET_LIMIT_NONE		= 0,

	/** aaa aaa aaa.
	 * aaa aaa aaa aaa @ref bs_qset_limits aaa aaa aaa.
	 */
	BS_QSET_LIMIT_DEFAULT		= -1,

	BS_QSET_LIMIT_QSETS		= 0,	/**< max query sets in a compilation */
	BS_QSET_LIMIT_FSAS		= 0,	/**< max FSAs in a single query set */
	BS_QSET_LIMIT_STATES		= 800000,	/**< max states in completed FSA */
	BS_QSET_LIMIT_PRE_CLOSE		= 200000,	/**< max states in pre-closed FSA */
	BS_QSET_LIMIT_ANY_TIME		= 1000000,	/**< max states at any time in an FSA */
	BS_QSET_LIMIT_EXPAND		= 25000,	/**< max expansion in a conversion step */
	BS_QSET_LIMIT_REDUCTO		= 10000,	/**< min states for reducto mapping */

	BS_QSET_LIMIT_FSA_SPACE		= 0,	/**< max space allowed to build an FSA */

	BS_QSET_LIMIT_B_EXT		= 10,	/**< max single byte count to optimize */
	BS_QSET_LIMIT_CS_EXT		= 30,	/**< max charset count to optimize */
	BS_QSET_LIMIT_NCS_EXT		= 50,	/**< max non-charset count to optimize */
	BS_QSET_LIMIT_NWC_EXT		= 50,	/**< max non-word char count to optimize*/
	BS_QSET_LIMIT_NWS_EXT		= 50,	/**< max non-whitespace count to opt'ze */
	BS_QSET_LIMIT_WC_EXT		= 30,	/**< max word char count to optimize */
	BS_QSET_LIMIT_WS_EXT		= 30,	/**< max whitespace count to optimize */
	BS_QSET_LIMIT_MIZE_MSIG		= 50,	/**< min minimiztion to be significant */
	BS_QSET_LIMIT_MIZE_LOOPS	= 10,	/**< max minimiztion loops w/o sig'cant */
	BS_QSET_LIMIT_MIZE_MAX		= 100	/**< max minimiztion loops in any case */
} bs_qset_limit_enum;


/**
 * aaa aaa bs_qset_dump() aaa'aaa aaa aaa.
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
 * aaa aaa aaa.  aaa aaa aaa, aaa aaa aaa aaa aaa aaa
 * aaa aaa, aaa aaa aaa aaa aaa aaa, aaa
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa, aaa
 * aaa aaa aaa.

 * aaa aaa aaa aaa aaa aaa aaa bs_qset_dump() aaa aaa.
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa
 * aaa aaa aaa, aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
 * aaa.  aaa aaa aaa aaa aaa aaa.

 * @note
 * aaa aaa aaa aaa bs_qset_dump() aaa, aaa aaa aaa,
 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
 * aaa aaa aaa aaa aaa.  aaa aaa aaa aaa aaa.
 */
typedef enum {
	/** aaa aaa aaa aaa aaa aaa.
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa.  aaa aaa aaa aaa.
	 */
	BS_QSET_DUMP_QINFO	= 0x0001,

	/** aaa aaa aaa aaa'aaa aaa.
	 * aaa aaa aaa "aaa" aaa aaa aaa aaa, aaa
	 * aaa aaa aaa aaa aaa aaa.
	 */
	BS_QSET_DUMP_FINFO	= 0x0002,

	/** aaa aaa aaa aaa aaa.
	 * aaa aaa aaa "aaa" aaa aaa aaa aaa, aaa
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa.
	 */
	BS_QSET_DUMP_SINFO	= 0x0004,

	/** aaa aaa aaa aaa.
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa.  aaa aaa aaa aaa.
	 */
	BS_QSET_DUMP_LOGIC	= 0x0008,

	/** aaa aaa aaa aaa.
	 * aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa aaa aaa aaa aaa, aaa aaa aaa aaa aaa
	 * aaa aaa aaa'aaa aaa.  aaa aaa aaa aaa.
	 */
	BS_QSET_DUMP_FLOGIC	= 0x0010,

	/** aaa aaa aaa aaa (aaa).
	 * aaa aaa aaa aaa aaa aaa aaa; aaa aaa aaa aaa aaa
	 * aaa aaa @ref BS_QSET_DUMP_SINFO, aaa aaa aaa "aaa" aaa aaa.
	 */
	BS_QSET_DUMP_FSAS	= 0x0020,

	/** aaa aaa-aaa-aaa aaa.
	 * aaa aaa aaa-aaa-aaa aaa aaa aaa aaa aaa aaa aaa aaa
	 * aaa aaa aaa aaa aaa.  aaa aaa aaa aaa.
	 */
	BS_QSET_DUMP_MAPS	= 0x0040,

	/** aaa aaa, aaa aaa "aaa" aaa.
	 * aaa aaa aaa aaa, aaa @ref BS_QSET_DUMP_FLOGIC.
	 */
	BS_QSET_DUMP_FULL	= 0x006f,

	/** aaa aaa aaa aaa aaa aaa aaa.
	 * aaa aaa aaa aaa, aaa @ref BS_QSET_DUMP_FLOGIC.
	 */
	BS_QSET_DUMP_ALL	= 0x007f
} bs_qset_dump_enum;


/**
 * aaa aaa aaa aaa bs_qset_get_state() aaa bs_qset_set_states().
 */
typedef enum {
	BS_QUERY_STATE_INACTIVE	     = 0,	/**< aaa aaa aaa (aaa aaa aaa) */
	BS_QUERY_STATE_ACTIVE	     = 1,	/**< aaa aaa aaa (aaa aaa) */
	BS_QUERY_STATE_INVALID       = 2	/**< aaa aaa aaa aaa */
} bs_query_state_enum;


/*
 * aaa aaa aaa aaa aaa: aaa aaa aaa aaa aaa aaa.
 */
#aaa	BS_TRANS_PER_STATE	   256	/* aaa aaa aaa aaa */


bs_info *	bs_version(void);
extern char *	brutesquad_copyright;

bs_buf *	bs_buf_new(void);
bs_buf *	bs_buf_newbuf(long size);
bs_buf *	bs_buf_dupe(bs_buf *bp);
bs_buf *	bs_buf_setbuf(bs_buf *bp, char *buf, long max, long len);
int		bs_buf_setlen(bs_buf *bp, long len);
int		bs_buf_type(bs_buf *bp);
int		bs_buf_setpad(bs_buf *bp, unsigned char pad);
int		bs_buf_free(bs_buf *bp);
void		bs_buf_dump(bs_buf *bp, FILE *f);

char		*bs_buf_databuf(bs_buf *bp);
long		bs_buf_datalen(bs_buf *bp);

int		bs_err_count(bs_err *ep);
int		bs_err_count_info(bs_err *ep);
int		bs_err_count_warning(bs_err *ep);
int		bs_err_count_error(bs_err *ep);
int		bs_err_count_range(bs_err *ep, int min, int max);
void		bs_err_print(bs_err *ep, FILE *f);
void		bs_err_print_info(bs_err *ep, FILE *f);
void		bs_err_print_warning(bs_err *ep, FILE *f);
void		bs_err_print_error(bs_err *ep, FILE *f);
void		bs_err_print_range(bs_err *ep, FILE *f, int min, int max);
void		bs_err_free(bs_err *ep);

void		bs_free(void *p);

void		bs_hitlist_free(bs_hitlist *hp);
void		bs_hitlist_print(bs_hitlist *hp, bs_buf *bp, int fmt, FILE *f);
int		bs_hitlist_count(bs_hitlist *hp);
bs_hit *	bs_hit_first(bs_hitlist *hp);
bs_hit *	bs_hit_last(bs_hitlist *hp);
bs_hit *	bs_hit_next(bs_hitlist *hp, bs_hit *cur, bs_err **epp);
bs_hit *	bs_hit_prev(bs_hitlist *hp, bs_hit *cur, bs_err **epp);
void		bs_hit_print(bs_hit *hp, bs_buf *bp, int fmt, FILE *f);

void		bs_string_free(bs_string *sp);
void		bs_string_print(bs_string *sp, FILE *f);
int		bs_string_count(bs_string *sp);

void		bs_macro_free(bs_macro *mp);

bs_buf *	bs_load_psl(char *file, bs_err **epp);
bs_buf *	bs_load_query(char *file, bs_err **epp);
bs_buf *	bs_load_qsets(char *fname, bs_err **);
bs_buf *	bs_load_data(char *file, bs_err **epp);

bs_buf *	bs_append_psl(bs_buf *pp, char *file, bs_err **epp);
bs_buf *	bs_append_query(bs_buf *qp, char *file, bs_err **epp);
bs_buf *	bs_append_qsets(bs_buf *sp, char *file, bs_err **epp);
bs_buf *	bs_append_data(bs_buf *dp, char *file, bs_err **epp);
bs_buf *	bs_append_bytes(bs_buf *dp, char *buf, int len, bs_err **epp);
bs_buf *	bs_truncate_bytes(bs_buf *dp, int len, bs_err **epp);

bs_buf *	bs_merge_psl(bs_buf *pp1, bs_buf *pp2, int dest,
			bs_err **epp);
bs_buf *	bs_merge_queries(bs_buf *qp1, bs_buf *qp2, int dest,
			bs_err **epp);
bs_buf *	bs_merge_qsets(bs_buf *sp1, bs_buf *sp2, int dest,
			bs_err **epp);
bs_buf *	bs_merge_data(bs_buf *dp1, bs_buf *dp2, int dest,
			bs_err **epp);

bs_buf *	bs_extract_queries(bs_buf *qp, int first, int count,
			bs_err **epp);
bs_buf *	bs_extract_qsets(bs_buf *sp, int first, int count,
			bs_err **epp);

bs_buf *	bs_copy_psl(bs_buf *pp, int num, bs_err **epp);
bs_buf *	bs_copy_query(bs_buf *qp, int num, bs_err **epp);
bs_buf *	bs_copy_queries(bs_buf *qp, int first, int count, bs_err **epp);

bs_buf *	bs_compile_psl(bs_buf *pp, ulong flags, bs_err **epp);

bs_query_info *	bs_query_get_info(bs_buf *qp, bs_err **);

int		bs_save_psl(char *file, bs_buf *pf, bs_err **epp);
int		bs_save_query(char *file, bs_buf *qp, bs_err **epp);
int		bs_save_qsets(char *fname, bs_buf *sp, bs_err **);
int		bs_save_data(char *file, bs_buf *df, bs_err **epp);

bs_buf *	bs_bufin_qsets(char *buf, long len, bs_err **);
long		bs_bufout_qsets(char *buf, long len, bs_buf *sp, bs_err **);

int		bs_count_queries(bs_buf *qp, bs_err **epp);
int		bs_count_qsets(bs_buf *qp, bs_err **epp);

bs_buf *	bs_share_data(bs_buf *qp, bs_err **epp);
bs_buf *	bs_share_qsets(bs_buf *qp, bs_err **epp);

bs_string *	bs_find_psl_terms(bs_buf *qp, short exp_flag, bs_err **epp);
bs_hitlist *	bs_find_data_hits(bs_buf *qp, bs_buf *dp,
			bs_find_params *, bs_err **);

int		bs_is_supported(bs_buf *qp, bs_err **epp);

int		bs_add_filename(bs_buf *qp, char *fname, bs_err **epp);
int		bs_add_info(bs_buf *qp, char *info, bs_err **epp);

bs_qset_limits *bs_qset_get_limits(bs_buf *sp, bs_err **);
bs_buf *	bs_build_qsets(bs_buf *qp, ulong flags, bs_qset_limits *,
			bs_err **);
bs_buf *	bs_convert_qsets(bs_buf *sp, bs_err **);

bs_qset_info *	bs_qset_get_info(bs_buf *sp, bs_err **);
void *		bs_qset_get_stats(bs_buf *sp, bs_err **);
int		bs_qset_reset_stats(bs_buf *sp, bs_err **);
bs_qset_query_info *bs_qset_get_query_info(bs_buf *sp, int qid, bs_err **);
int		bs_qset_dump(bs_buf *sp, ulong flags, FILE *, bs_err **);

int		bs_qset_set_states(bs_buf *sp, int qs,
			int qid_low, int qid_high, int val, bs_err **);
int		bs_qset_get_state(bs_buf *sp, int qs, int qid, bs_err **);

void		bs_termination_address(char *addr);
void		bs_termination_signal(int signum);

void		bs_cleanup(void);

bs_callbackhandler bs_callback_get(int type, bs_err **);
bs_callbackhandler bs_callback_set(int type, bs_callbackhandler func,
			bs_err **);

#endif	/* B_H__ */
