
#include <boost::scoped_ptr.hpp>
#include <string>

/// This is a base class with a private implementation.
class ClassA 
{
public:
  ClassA();
private:
  class Implementation;
  boost::scoped_ptr< Implementation > mImpl;
};

/// This is a derived class with its own independent private implementation.
class ClassB : public ClassA
{
public:
  ClassB();
private:
  class Implementation;
  boost::scoped_ptr< Implementation > mImpl;
};

ClassA::ClassA() : mImpl() {}
ClassB::ClassB() : ClassA(), mImpl() {}

///  This is the private implementation for ClassA.
class ClassA::Implementation 
{
public:
  Implementation() {}
  std::string mData;
};

/// This is the private implementation for ClassB.
class ClassB::Implementation 
{
public:
  Implementation() {}
  std::string mData;
};
