/*
 * Copyright (C) 2008-2010 Ole Andr Vadla Ravns <ole.andre.ravnas@tandberg.com>
 * Copyright (C) 2008 Christian Berentsen <christian.berentsen@tandberg.com>
 * Copyright (C) 2009 Haakon Sporsheim <haakon.sporsheim@tandberg.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __TEST_UTIL_H__
#define __TEST_UTIL_H__

#include "gsttestclock.h"

#define TEST_LIST_BEGIN(NAME)       void test_ ##NAME## _add_tests (void) {
#define TEST_LIST_END()             }

#define TEST_ENTRY_SIMPLE(NAME, PREFIX, FUNC)                             \
  G_STMT_START                                                            \
  {                                                                       \
    extern void PREFIX## _ ##FUNC (void);                                 \
    g_test_add_func ("/" NAME "/" #FUNC, PREFIX## _ ##FUNC);              \
  }                                                                       \
  G_STMT_END;
#define TEST_ENTRY_WITH_FIXTURE(NAME, PREFIX, FUNC, STRUCT)               \
  G_STMT_START                                                            \
  {                                                                       \
    extern void PREFIX## _ ##FUNC (STRUCT * fixture, gconstpointer data); \
    g_test_add ("/" NAME "/" #FUNC,                                       \
        STRUCT,                                                           \
        NULL,                                                             \
        PREFIX## _fixture_setup,                                          \
        PREFIX## _ ##FUNC,                                                \
        PREFIX## _fixture_teardown);                                      \
  }                                                                       \
  G_STMT_END;

#define TEST_RUN_LIST(NAME)                                               \
  G_STMT_START                                                            \
  {                                                                       \
    extern void test_ ##NAME## _add_tests (void);                         \
    test_ ##NAME## _add_tests ();                                         \
  }                                                                       \
  G_STMT_END

typedef struct _GtuClockWaitContext GtuClockWaitContext;

G_BEGIN_DECLS

void gtu_dump_rtp_buffers (const GstBuffer ** rtp_buffers,
    guint num_rtp_buffers);

void gtu_shift_buffer_timestamps_from_first (GstBuffer ** buffers,
    guint num_buffers);

GtuClockWaitContext * gst_test_util_wait_for_clock_id_begin (
    GstTestClock * test_clock, GstClockID clock_id, GstClockTimeDiff * jitter);
gboolean gst_test_util_clock_wait_context_has_completed (
    GtuClockWaitContext * wait_ctx);
GstClockReturn gst_test_util_wait_for_clock_id_end (
    GtuClockWaitContext * wait_ctx);

G_END_DECLS

#endif