<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "&#160;">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:date="http://exslt.org/dates-and-times" xmlns:fox="http://xml.apache.org/fop/extensions">
	<xsl:import href="C:/Strata42/Desktop/Advanced_Strategy_Publisher/Tools/docbook-xsl-1.74.3/fo/docbook.xsl"/>
	<!--<xsl:import href="AddPrefixes.xsl"/>-->
	<xsl:include href="PDFTitlePage_External.xsl"/>
	<xsl:param name="footer.image.filename" select="'images/Logo_CGI1.gif'"/>
	<xsl:param name="paper.type">USletter</xsl:param>
	<xsl:param name="page.orientation" select="'landscape'"/>
		<!-- BEGIN: # 41115 (Defect 6969 & 7327) STRATA
						  Modified by: Vasavi, Date Modified 07/31/07-->		
	<xsl:param name="page.margin.inner">1in</xsl:param>
	<xsl:param name="page.margin.outer">1in</xsl:param>
	<!-- <xsl:param name="page.margin.top">0.75in</xsl:param>
	<xsl:param name="page.margin.bottom">0.65in</xsl:param> -->
	<xsl:param name="page.margin.top">0.2in</xsl:param>
	<xsl:param name="page.margin.bottom">0.2in</xsl:param>
	<!-- END: # 41115 ( Defect 6969 & 7327) -->
	<!--<xsl:param name="page.width.portrait">8.5in</xsl:param>
	<xsl:param name="page.height.portrait">11in</xsl:param>
	<xsl:param name="page.margin.inner">1.1in</xsl:param>
	<xsl:param name="page.margin.outer">1.3in</xsl:param>
	<xsl:param name="page.margin.top">0.75in</xsl:param>
	<xsl:param name="page.margin.bottom">0.65in</xsl:param>-->
	<!-- Old page margins
	<xsl:param name="page.margin.inner">1in</xsl:param>
	<xsl:param name="page.margin.outer">1in</xsl:param>
	<xsl:param name="page.margin.top">0.75in</xsl:param>
	<xsl:param name="page.margin.bottom">0.65in</xsl:param>
	-->
	<xsl:param name="ulink.show" select="1"/>
	<xsl:param name="region.before.extent">0.4in</xsl:param>
	<xsl:param name="region.after.extent">0.4in</xsl:param>
		<!-- BEGIN: # 41115 (Defect 6969 & 7327) STRATA
						  Modified by: Vasavi, Date Modified 07/31/07-->		
	<!-- <xsl:param name="body.margin.top">0.5in</xsl:param> -->
	<!-- <xsl:param name="body.margin.bottom">0.5in</xsl:param> -->
	<!-- END: # 41115 ( Defect 6969 & 7327) -->
	<xsl:param name="fop.extensions" select="1"/>
	<xsl:param name="fop1.extensions" select="1"/>
	<!-- Image Scaling	
	<xsl:param name="ignore.image.scaling" select="1"></xsl:param>
	<xsl:param name="default.image.width" select="'auto'"></xsl:param>-->
	<xsl:param name="use.svg" select="1"/>
	<xsl:param name="double.sided" select="1"/>
	<xsl:param name="autotoc.label.separator" select="'  '"/>
	<xsl:param name="generate.toc">
/appendix toc,title
article/appendix  nop
/article  toc,title
book      toc,title
/chapter  toc,title
part       title
/preface  toc,title
qandadiv  toc
qandaset  toc
reference toc,title
/section  toc
set       toc,title
</xsl:param>
<!-- indent text with 1.67 xsl-->
<xsl:param name="title.margin.left">.5pt</xsl:param>

	<xsl:param name="draft.watermark.image" select="'images/draft.gif'"/>
	<xsl:param name="draft.mode" select="'no'"/>
	<xsl:param name="chapter.autolabel">1</xsl:param>
	<xsl:param name="section.autolabel">1</xsl:param>
	<xsl:param name="section.autolabel.max.depth" select="4"/>
	<xsl:param name="section.label.includes.component.label" select="1"/>
	<xsl:param name="body.font.family">Times</xsl:param>
	<xsl:param name="body.font.master">11</xsl:param>
	<xsl:param name="body.font.size">
		<xsl:value-of select="$body.font.master"/>
		<xsl:text>pt</xsl:text>
	</xsl:param>
	<xsl:param name="title.font.family">Verdana</xsl:param>
	<xsl:param name="generate.component.toc" select="1"/>
	<xsl:param name="toc.section.depth" select="2"/>
	<!--Indenting/Aligning Lists margin-left=".25in" or text-aligh="left"-->
	<xsl:template match="orderedlist|itemizedlist">
		<xsl:choose>
			<xsl:when test="not(ancestor::itemizedlist or ancestor::orderedlist)">
				<fo:block text-align="left">
					<xsl:apply-imports/>
				</fo:block>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-imports/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--<xsl:template match="para">
	  <fo:block xsl:use-attribute-sets="normal.para.spacing">
		<xsl:call-template name="anchor"/>
		<xsl:apply-templates/>
	  </fo:block>
</xsl:template>-->
<!-- BEGIN: Defect# 5376, STRATA 4.1.4, Modified by: Bela Patel, Date Modified 10/15/09-->
<!-- Start table numbering based off the section above it-->
<xsl:template match="table" mode="label.markup">
  <xsl:variable name="pchap"
                select="ancestor::section[1]"/>

  <xsl:variable name="prefix">
    <xsl:if test="count($pchap) &gt; 0">
      <xsl:apply-templates select="$pchap" mode="label.markup"/>
    </xsl:if>
  </xsl:variable>

  <xsl:choose>
    <xsl:when test="@label">
      <xsl:value-of select="@label"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:choose>
        <xsl:when test="$prefix != ''">
            <xsl:apply-templates select="$pchap" mode="label.markup"/>
            <xsl:apply-templates select="$pchap" mode="intralabel.punctuation"/>
          <xsl:number format="1" from="section" level="any"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:number format="1" from="book|article" level="any"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>
<!-- END: Defect# 5376 -->
	<xsl:attribute-set name="component.title.properties">
		<xsl:attribute name="keep-with-next.within-column">always</xsl:attribute>
		<xsl:attribute name="font-size"><xsl:text>22pt</xsl:text></xsl:attribute>
		<xsl:attribute name="space-before">2pt</xsl:attribute>
		<xsl:attribute name="space-after">2pt</xsl:attribute>
		<xsl:attribute name="font-family">Verdana</xsl:attribute>
		<xsl:attribute name="line-height">normal</xsl:attribute>
		<xsl:attribute name="text-align"><xsl:text>left</xsl:text></xsl:attribute>
	</xsl:attribute-set>
	<!-- Setting title properties for all sections in a book, article-->
	<xsl:attribute-set name="section.title.level1.properties">
		<xsl:attribute name="font-size"><xsl:text>14pt</xsl:text></xsl:attribute>
		<xsl:attribute name="space-before">1pt</xsl:attribute>
		<xsl:attribute name="space-after">1pt</xsl:attribute>
		<xsl:attribute name="font-family">Verdana</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="line-height">normal</xsl:attribute>
		<xsl:attribute name="text-align"><xsl:text>left</xsl:text></xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-width">.25pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="section.title.level2.properties">
		<xsl:attribute name="font-size"><xsl:text>10pt</xsl:text></xsl:attribute>
		<xsl:attribute name="space-before">0pt</xsl:attribute>
		<xsl:attribute name="space-after">0pt</xsl:attribute>
		<xsl:attribute name="font-family">Verdana</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="line-height">normal</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="section.title.level3.properties">
		<xsl:attribute name="font-size"><xsl:text>10pt</xsl:text></xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="space-before">0pt</xsl:attribute>
		<xsl:attribute name="space-after">0pt</xsl:attribute>
		<xsl:attribute name="font-family">Verdana</xsl:attribute>
		<!--	<xsl:attribute name="font-weight">bold</xsl:attribute>-->
		<xsl:attribute name="line-height">normal</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="section.title.level4.properties">
		<xsl:attribute name="font-size"><xsl:text>10pt</xsl:text></xsl:attribute>
		<xsl:attribute name="space-before">0pt</xsl:attribute>
		<xsl:attribute name="space-after">0pt</xsl:attribute>
		<xsl:attribute name="font-family">Verdana</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<!--	<xsl:attribute name="font-weight">bold</xsl:attribute>-->
		<xsl:attribute name="line-height">normal</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="section.title.level5.properties">
		<xsl:attribute name="font-size"><xsl:text>10pt</xsl:text></xsl:attribute>
		<xsl:attribute name="space-before">0pt</xsl:attribute>
		<xsl:attribute name="space-after">0pt</xsl:attribute>
		<xsl:attribute name="font-family">Verdana</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<!--	<xsl:attribute name="font-weight">bold</xsl:attribute>-->
		<xsl:attribute name="line-height">normal</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="section.title.level6.properties">
		<xsl:attribute name="font-size"><xsl:text>11pt</xsl:text></xsl:attribute>
		<xsl:attribute name="space-before">0pt</xsl:attribute>
		<xsl:attribute name="space-after">0pt</xsl:attribute>
		<xsl:attribute name="font-family">Times</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<!--	<xsl:attribute name="font-weight">bold</xsl:attribute>-->
		<xsl:attribute name="line-height">normal</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="section.title.level7.properties">
		<xsl:attribute name="font-size"><xsl:text>11pt</xsl:text></xsl:attribute>
		<xsl:attribute name="space-before">0pt</xsl:attribute>
		<xsl:attribute name="space-after">0pt</xsl:attribute>
		<xsl:attribute name="font-family">Times</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="line-height">normal</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="section.title.level8.properties">
		<xsl:attribute name="font-size"><xsl:text>11pt</xsl:text></xsl:attribute>
		<xsl:attribute name="space-before">0pt</xsl:attribute>
		<xsl:attribute name="space-after">0pt</xsl:attribute>
		<xsl:attribute name="font-family">Times</xsl:attribute>
		<xsl:attribute name="font-weight">italic</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="line-height">normal</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="section.title.level9.properties">
		<xsl:attribute name="font-size"><xsl:text>9pt</xsl:text></xsl:attribute>
		<xsl:attribute name="space-before">0pt</xsl:attribute>
		<xsl:attribute name="space-after">0pt</xsl:attribute>
		<xsl:attribute name="font-family">Verdana</xsl:attribute>
		<xsl:attribute name="font-weight">italic</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="line-height">normal</xsl:attribute>
	</xsl:attribute-set>
	<!--Set a wrap option for XML data in programlisting-->
	<xsl:attribute-set name="monospace.verbatim.properties" use-attribute-sets="verbatim.properties">
		<xsl:attribute name="font-family"><xsl:value-of select="$monospace.font.family"/></xsl:attribute>
		<xsl:attribute name="font-size"><xsl:text>9pt</xsl:text></xsl:attribute>
		<xsl:attribute name="wrap-option">wrap</xsl:attribute>
		<xsl:attribute name="border-color">#25297c</xsl:attribute>
		<xsl:attribute name="border-style">solid</xsl:attribute>
		<xsl:attribute name="border-width">heavy</xsl:attribute>
		<xsl:attribute name="background-color">#25297c</xsl:attribute>
	</xsl:attribute-set>
	<!-- Update Note Properties-->
	<xsl:attribute-set name="admonition.title.properties">
		<xsl:attribute name="font-size">10pt</xsl:attribute>
		<xsl:attribute name="font-family">Verdana</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="hyphenate">false</xsl:attribute>
		<xsl:attribute name="keep-with-next.within-column">always</xsl:attribute>
	</xsl:attribute-set>
	<!-- #10831 Docbook 1.74.3 upgrade - Modified by/Date: Saroja, 03/11/09 -->
	<xsl:param name="local.l10n.xml" select="document('')"/>
	<l:i18n xmlns:l="http://docbook.sourceforge.net/xmlns/l10n/1.0">
		<l:l10n language="en">
			<l:context name="title-numbered">
				<l:template name="chapter" text="%n %t"/>
			</l:context>
		</l:l10n>
	</l:i18n>
	<!-- #10831 Docbook 1.74.3 upgrade - Modified by/Date: Saroja, 02/11/09 -->
	<!--Table properties -->
	<!--<xsl:param name="ulink.hyphenate" select="''"></xsl:param>-->
	<xsl:param name="hyphenate">false</xsl:param>
	<!--====================================HEADER CONTENT=================================-->
	<xsl:template name="header.content">
		<xsl:param name="pageclass" select="''"/>
		<xsl:param name="sequence" select="''"/>
		<xsl:param name="position" select="''"/>
		<xsl:param name="gentext-key" select="''"/>
		<xsl:variable name="candidate">
			<!-- sequence can be odd, even, first, blank -->
			<!-- position can be left, center, right -->
			<xsl:choose>
				<xsl:when test="$sequence = 'odd' and $position = 'left'">  
        </xsl:when>
				<xsl:when test="$sequence = 'odd' and $position = 'center'">
        </xsl:when>
				<xsl:when test="$sequence = 'odd' and $position = 'right'">
					<fo:block>
						<xsl:text>CGI</xsl:text>
					</fo:block>
					<fo:block border-bottom-style="solid" border-bottom-width="1.5pt" border-start-width="22pt" border-end-width="24pt" border-bottom-color="#696969">
						<xsl:value-of select="ancestor-or-self::book/bookinfo/title"/>
					</fo:block>
				</xsl:when>
				<xsl:when test="$sequence = 'even' and $position = 'left'">
					<fo:block>
						<xsl:text>CGI</xsl:text>
					</fo:block>
					<fo:block border-bottom-style="solid" border-bottom-width="1.5pt" border-start-width="22pt" border-end-width="24pt" border-bottom-color="#696969">
						<xsl:value-of select="ancestor-or-self::book/bookinfo/title"/>
					</fo:block>
				</xsl:when>
				<xsl:when test="$sequence = 'even' and $position = 'center'">
        </xsl:when>
				<xsl:when test="$sequence = 'even' and $position = 'right'">
			
				</xsl:when>
				<xsl:when test="$sequence = 'first' and $position = 'left'"> 
        </xsl:when>
				<xsl:when test="$sequence = 'first' and $position = 'right'">
					<fo:block>
						<xsl:text>CGI</xsl:text>
					</fo:block>
					<fo:block border-bottom-style="solid" border-bottom-width="1.5pt" border-start-width="22pt" border-end-width="24pt" border-bottom-color="#696969">
						<xsl:value-of select="ancestor-or-self::book/bookinfo/title"/>
					</fo:block>
				</xsl:when>
				<xsl:when test="$sequence = 'first' and $position = 'center'"> 
        </xsl:when>
				<xsl:when test="$sequence = 'blank' and $position = 'left'">
					<fo:block>
						<xsl:text>CGI</xsl:text>
					</fo:block>
					<fo:block>
						<xsl:value-of select="ancestor-or-self::book/bookinfo/title"/>
					</fo:block>
				</xsl:when>
				<xsl:when test="$sequence = 'blank' and $position = 'center'">
					<!-- no output -->
				</xsl:when>
				<xsl:when test="$sequence = 'blank' and $position = 'right'">
        </xsl:when>
			</xsl:choose>
		</xsl:variable>
		<!-- Does runtime parameter turn off blank page headers? -->
		<xsl:choose>
			<xsl:when test="$sequence='blank' and $headers.on.blank.pages=1">
				<!-- no output -->
			</xsl:when>
			<!-- titlepages have no headers -->
			<xsl:when test="$pageclass = 'titlepage'">
				<!-- no output -->
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy-of select="$candidate"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--Header fonts and font size. -->
	<xsl:attribute-set name="header.content.properties">
		<xsl:attribute name="font-family">Verdana</xsl:attribute>
		<xsl:attribute name="font-size">6pt</xsl:attribute>
		<xsl:attribute name="line-height">normal</xsl:attribute>
	</xsl:attribute-set>
	<!-- Header rule line -->
	<xsl:template name="head.sep.rule">
		<xsl:param name="sequence" select="''"/>
		<xsl:if test="$header.rule != 0">
			<xsl:attribute name="border-bottom-width">0.25pt</xsl:attribute>
			<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
			<xsl:attribute name="border-bottom-color">black</xsl:attribute>
		</xsl:if>
		<xsl:if test="$sequence='blank'">
			<xsl:if test="$header.rule != 0">
				<xsl:attribute name="border-bottom-width">0pt</xsl:attribute>
				<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
				<xsl:attribute name="border-bottom-color">black</xsl:attribute>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template match="hr">
</xsl:template>
	<!--====================================FOOTER CONTENT=================================-->
	<!-- Footer content and placement. -->
	<xsl:template name="footer.content">
		<xsl:param name="pageclass" select="''"/>
		<xsl:param name="sequence" select="''"/>
		<xsl:param name="position" select="''"/>
		<xsl:param name="gentext-key" select="''"/>
		<xsl:variable name="candidate">
			<!-- sequence can be odd, even, first, blank -->
			<!-- position can be left, center, right -->
			<xsl:choose>
				<xsl:when test="$sequence = 'odd' and $position = 'left'">
					<!--content-height="1.2cm"-->
					<fo:external-graphic width="2.3cm" text-align="left" scaling="uniform">
						<xsl:attribute name="src"><xsl:call-template name="fo-external-image"><xsl:with-param name="filename" select="$footer.image.filename"/></xsl:call-template></xsl:attribute>
					</fo:external-graphic>
				</xsl:when>
				<xsl:when test="$sequence = 'odd' and $position = 'center'">
					<fo:block>
						<xsl:text>Proprietary and Confidential </xsl:text>
					</fo:block>
					<fo:block>
						<xsl:text>&nbsp;</xsl:text>
					</fo:block>
					<fo:block>
						<xsl:text>&nbsp;</xsl:text>
					</fo:block>
				</xsl:when>
				<xsl:when test="$sequence = 'odd' and $position = 'right'">
					<fo:block font-weight="bold">
						<xsl:apply-templates select="." mode="titleabbrev.markup"/>
					</fo:block>
					<fo:block>
						<xsl:value-of select="ancestor-or-self::book/bookinfo/title"/>
					</fo:block>
					<fo:block>
						<xsl:apply-templates mode="page-number-prefix" select="."/>
						<fo:page-number/>
					</fo:block>
				</xsl:when>
				<xsl:when test="$sequence = 'even' and $position = 'right'">
					<fo:external-graphic width="2.3cm" scaling="uniform" text-align="right">
						<xsl:attribute name="src"><xsl:call-template name="fo-external-image"><xsl:with-param name="filename" select="$footer.image.filename"/></xsl:call-template></xsl:attribute>
					</fo:external-graphic>
				</xsl:when>
				<xsl:when test="$sequence = 'even' and $position = 'left'">
					<fo:block font-weight="bold">
						<xsl:apply-templates select="." mode="titleabbrev.markup"/>
					</fo:block>
					<fo:block>
						<xsl:value-of select="ancestor-or-self::book/bookinfo/title"/>
					</fo:block>
					<fo:block>
						<xsl:apply-templates mode="page-number-prefix" select="."/>
						<fo:page-number/>
					</fo:block>
				</xsl:when>
				<xsl:when test="$sequence = 'even' and $position = 'center'">
					<fo:block>
						<xsl:text>Proprietary and Confidential </xsl:text>
					</fo:block>
					<fo:block>
						<xsl:text>&nbsp;</xsl:text>
					</fo:block>
					<fo:block>
						<xsl:text>&nbsp;</xsl:text>
					</fo:block>
				</xsl:when>
				<xsl:when test="$sequence = 'first' and $position = 'left'">
					<fo:external-graphic width="2.3cm" scaling="uniform" text-align="left">
						<xsl:attribute name="src"><xsl:call-template name="fo-external-image"><xsl:with-param name="filename" select="$footer.image.filename"/></xsl:call-template></xsl:attribute>
					</fo:external-graphic>
				</xsl:when>
				<xsl:when test="$sequence = 'first' and $position = 'right'">
					<fo:block font-weight="bold">
						<xsl:apply-templates select="." mode="titleabbrev.markup"/>
					</fo:block>
					<fo:block>
						<xsl:value-of select="ancestor-or-self::book/bookinfo/title"/>
					</fo:block>
					<fo:block>
						<xsl:apply-templates mode="page-number-prefix" select="."/>
						<fo:page-number/>
					</fo:block>
				</xsl:when>
				<xsl:when test="$sequence = 'first' and $position = 'center'">
					<fo:block>
						<xsl:text>Proprietary and Confidential </xsl:text>
					</fo:block>
					<fo:block>
						<xsl:text>&nbsp;</xsl:text>
					</fo:block>
					<fo:block>
						<xsl:text>&nbsp;</xsl:text>
					</fo:block>
				</xsl:when>
				<xsl:when test="$sequence = 'blank' and $position = 'left'">
					<fo:block>
						<xsl:text>CGI</xsl:text>
					</fo:block>
					<fo:block>
						<xsl:value-of select="ancestor-or-self::book/bookinfo/title"/>
					</fo:block>
				</xsl:when>
				<xsl:when test="$sequence = 'blank' and $position = 'center'">
			</xsl:when>
				<xsl:when test="$sequence = 'blank' and $position = 'right'">
			</xsl:when>
			</xsl:choose>
		</xsl:variable>
		<!-- Does runtime parameter turn off blank page footers? -->
		<xsl:choose>
			<xsl:when test="$sequence='blank' and $footers.on.blank.pages=1">
				<!-- no output -->
			</xsl:when>
			<!-- titlepages have no footers -->
			<xsl:when test="$pageclass = 'titlepage'">
				<!-- no output -->
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy-of select="$candidate"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- Footer fonts and font size. -->
	<xsl:attribute-set name="footer.content.properties">
		<xsl:attribute name="font-family">Verdana</xsl:attribute>
		<xsl:attribute name="font-size">6pt</xsl:attribute>
		<xsl:attribute name="line-height">normal</xsl:attribute>
	</xsl:attribute-set>
	<!-- Footer rule line -->
	<xsl:template name="foot.sep.rule">
		<xsl:param name="sequence" select="''"/>
		<xsl:if test="$footer.rule != 0">
			<xsl:attribute name="border-top-width">0.25pt</xsl:attribute>
			<xsl:attribute name="border-top-style">solid</xsl:attribute>
			<xsl:attribute name="border-top-color">black</xsl:attribute>
		</xsl:if>
		<xsl:if test="$sequence='blank'">
			<xsl:if test="$footer.rule != 0">
				<xsl:attribute name="border-top-width">0pt</xsl:attribute>
				<xsl:attribute name="border-top-style">solid</xsl:attribute>
				<xsl:attribute name="border-top-color">black</xsl:attribute>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<!--  Spacing between paragraphs    -->
	<xsl:attribute-set name="normal.para.spacing">
		<xsl:attribute name="space-before.optimum">0.5em</xsl:attribute>
		<xsl:attribute name="space-before.minimum">0.4em</xsl:attribute>
		<xsl:attribute name="space-before.maximum">0.6em</xsl:attribute>
		<xsl:attribute name="text-align"><xsl:value-of select="'left'"/></xsl:attribute>
	</xsl:attribute-set>
	<!-- Setting properties for titles of tables, figures -->
	<xsl:attribute-set name="formal.title.properties" use-attribute-sets="normal.para.spacing">
		<xsl:attribute name="font-family">Verdana</xsl:attribute>
		<xsl:attribute name="font-style">italic</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="line-height">6pt</xsl:attribute>
	</xsl:attribute-set>
	<!--Setting space for Itemized lists if they are set as blocks-->
	<xsl:attribute-set name="list.block.spacing">
		<xsl:attribute name="space-before.optimum">0em</xsl:attribute>
		<xsl:attribute name="space-before.minimum">0em</xsl:attribute>
		<xsl:attribute name="space-before.maximum">0em</xsl:attribute>
		<xsl:attribute name="space-after.optimum">0.3em</xsl:attribute>
		<xsl:attribute name="space-after.minimum">0.3em</xsl:attribute>
		<xsl:attribute name="space-after.maximum">0.3em</xsl:attribute>
	</xsl:attribute-set>
	<!--Attribute set used by table properties -->
	<xsl:attribute-set name="formal.object.properties">
		<xsl:attribute name="space-before.minimum">0.5em</xsl:attribute>
		<xsl:attribute name="space-before.optimum">1em</xsl:attribute>
		<xsl:attribute name="space-before.maximum">2em</xsl:attribute>
		<xsl:attribute name="space-after.minimum">0.5em</xsl:attribute>
		<xsl:attribute name="space-after.optimum">1em</xsl:attribute>
		<xsl:attribute name="space-after.maximum">2em</xsl:attribute>
		<xsl:attribute name="keep-together.within-column">always</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
	</xsl:attribute-set>
	<!-- Setting properties for formal tables-->
	<xsl:attribute-set name="table.properties" use-attribute-sets="formal.object.properties">
		<xsl:attribute name="font-family">Verdana</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="hyphenate">true</xsl:attribute>
	</xsl:attribute-set>
	<!-- Adding table borders-->
	<xsl:param name="table.frame.border.style" select="'solid'"/>
	<xsl:param name="table.frame.border.thickness" select="'1.5pt'"/>
	<xsl:param name="table.frame.border.color" select="'black'"/>
	<!--Setting properties for informal figures, tables...-->
	<xsl:attribute-set name="informal.object.properties">
		<xsl:attribute name="space-before.minimum">0.5em</xsl:attribute>
		<xsl:attribute name="space-before.optimum">1em</xsl:attribute>
		<xsl:attribute name="space-before.maximum">2em</xsl:attribute>
		<xsl:attribute name="space-after.minimum">0.5em</xsl:attribute>
		<xsl:attribute name="space-after.optimum">1em</xsl:attribute>
		<xsl:attribute name="space-after.maximum">2em</xsl:attribute>
	</xsl:attribute-set>
	<!--Setting properties for informal tables-->
	<xsl:attribute-set name="informaltable.properties" use-attribute-sets="table.properties"/>
	<!--Margin properties for table of contents -->
	<xsl:attribute-set name="toc.margin.properties">
		<xsl:attribute name="space-before.minimum">0.5em</xsl:attribute>
		<xsl:attribute name="space-before.optimum">1em</xsl:attribute>
		<xsl:attribute name="space-before.maximum">2em</xsl:attribute>
		<xsl:attribute name="space-after.minimum">0.5em</xsl:attribute>
		<xsl:attribute name="space-after.optimum">1em</xsl:attribute>
		<xsl:attribute name="space-after.maximum">2em</xsl:attribute>
	</xsl:attribute-set>
	<!--Controlling space between itemized lists-->
	<xsl:attribute-set name="list.item.spacing">
		<xsl:attribute name="space-before.optimum">0.3em</xsl:attribute>
		<!--before: 1em-->
		<xsl:attribute name="space-before.minimum">0.3em</xsl:attribute>
		<!--before: 0.8em-->
		<xsl:attribute name="space-before.maximum">0.3em</xsl:attribute>
		<!-- before: 1em-->
		<xsl:attribute name="line-height">normal</xsl:attribute>
	</xsl:attribute-set>
	<!--Setting Glossary as Blocks to remove indentation before the definition-->
	<xsl:param name="glossary.as.blocks" select="1"/>
	<xsl:param name="glossterm.width" select="'2in'"/>
	<xsl:param name="variablelist.as.blocks" select="1"/>
	<!-- control what symbols are used in lists, copied from 
       common/common.xsl -->
	<xsl:template name="next.itemsymbol">
		<xsl:param name="itemsymbol" select="'default'"/>
		<xsl:choose>
			<!-- Change this list if you want to change the order of symbols -->
			<xsl:when test="$itemsymbol = 'disc'">square</xsl:when>
			<xsl:when test="$itemsymbol = 'circle'">smallsquare</xsl:when>
			<!--  I added the next line.  -->
			<xsl:when test="$itemsymbol = 'ndash'">ndash</xsl:when>
			<xsl:otherwise>square</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--  Entire template copied from fo/lists.xsl  Solved the bullet bug-->
	<xsl:template match="itemizedlist/listitem">
		<xsl:variable name="id">
			<xsl:call-template name="object.id"/>
		</xsl:variable>
		<xsl:variable name="itemsymbol">
			<xsl:call-template name="list.itemsymbol">
				<xsl:with-param name="node" select="parent::itemizedlist"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="item.contents">
			<fo:list-item-label end-indent="label-end()">
				<fo:block>
					<xsl:choose>
						<xsl:when test="$itemsymbol='disc'">
							<fo:block font-family="ZapfDingbats" font-size="7pt">&#x25A0;</fo:block>
						</xsl:when>
						<xsl:when test="$itemsymbol='bullet'">
							<fo:block font-family="ZapfDingbats" font-size="7pt">&#x25A0;</fo:block>
						</xsl:when>
						<!-- FOP deficiency-->
						<xsl:when test="$itemsymbol='ndash'">
							<fo:block font-family="ZapfDingbats" font-size="7pt" color="#747170">&#x2012;</fo:block>
						</xsl:when>
						<xsl:when test="$itemsymbol='circle'">
							<fo:block font-family="ZapfDingbats" font-size="7pt">&#x25A0;</fo:block>
						</xsl:when>
						<xsl:when test="$itemsymbol='round'">
							<fo:block font-family="ZapfDingbats" font-size="7pt">&#x25A0;</fo:block>
						</xsl:when>
						<xsl:when test="$itemsymbol='square'">
							<!--	<fo:block font-family="ZapfDingbats" color="#FF0000" font-size="7pt">&#x25A0;</fo:block>-->
							<fo:inline font-family="ZapfDingbats" color="#FF0000" font-size="7pt">&#x25A0;</fo:inline>
						</xsl:when>
						<xsl:when test="$itemsymbol='smallsquare'">
							<fo:block font-family="ZapfDingbats" font-size="3pt" color="#747170">&#x25A0;</fo:block>
						</xsl:when>
						<xsl:otherwise>
							<fo:block font-family="ZapfDingbats" font-size="7pt" color="#747170">&#x25A0;</fo:block>
						</xsl:otherwise>
					</xsl:choose>
				</fo:block>
			</fo:list-item-label>
			<fo:list-item-body start-indent="body-start()">
				<!-- #10831 FOP 95 upgrade - Modified by/Date: Saroja, 02/27/09 -->
				<!--<fo:inline>-->
					<xsl:apply-templates/>
				<!-- #10831 FOP 95 upgrade - Modified by/Date: Saroja, 02/27/09 -->
				<!--</fo:inline>-->
			</fo:list-item-body>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="parent::*/@spacing = 'compact'">
				<fo:list-item id="{$id}" xsl:use-attribute-sets="compact.list.item.spacing">
					<xsl:copy-of select="$item.contents"/>
				</fo:list-item>
			</xsl:when>
			<xsl:otherwise>
				<fo:list-item id="{$id}" xsl:use-attribute-sets="list.item.spacing">
					<xsl:copy-of select="$item.contents"/>
				</fo:list-item>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="table.cell.properties">
		<xsl:if test="ancestor::thead">
			<xsl:attribute name="start-indent">-0.5pt</xsl:attribute>
		</xsl:if>
		<xsl:if test="ancestor::tbody">
			<xsl:attribute name="start-indent">-0.5pt</xsl:attribute>
		</xsl:if>
	</xsl:template>
	<!-- removes couple of blank pages after titlepage caused by FOP bug 
	<xsl:template name="book.titlepage.separator">
</xsl:template>-->
	<!-- Generating Published Date -->
	<xsl:template match="pubdate[@role='now']" mode="titlepage.mode">
		<xsl:variable name="now" select="date:date-time()"/>
		<fo:block color="black">
			<xsl:text>Generated on </xsl:text>
			<xsl:value-of select="date:month-name($now)"/>
			<xsl:text> </xsl:text>
			<xsl:value-of select="date:day-in-month($now)"/>
			<xsl:text>, </xsl:text>
			<xsl:value-of select="date:year($now)"/>
			<xsl:text> at </xsl:text>
			<xsl:value-of select="date:hour-in-day($now)"/>
			<xsl:text>:</xsl:text>
			<xsl:value-of select="date:minute-in-hour($now)"/>
			<xsl:text>:</xsl:text>
			<xsl:value-of select="date:second-in-minute($now)"/>
		</fo:block>
	</xsl:template>
	<xsl:template name="initial.page.number">
		<xsl:param name="element" select="local-name(.)"/>
		<xsl:param name="master-reference" select="''"/>
		<xsl:param name="starting.page.number" select="1"/>
		<xsl:choose>
			<!-- double-sided output -->
			<xsl:when test="$double.sided != 0">
				<xsl:choose>
					<xsl:when test="$element = 'toc'">auto-odd</xsl:when>
					<xsl:when test="$element = 'book'">2</xsl:when>
					<xsl:when test="$element = 'preface'">auto-odd</xsl:when>
					<xsl:when test="$element = 'part' and not(preceding::chapter)
                        and not(preceding::part)">2</xsl:when>
					<xsl:when test="($element = 'dedication' or $element = 'article') and
                        not(preceding::chapter
                            or preceding::preface
                            or preceding::appendix
                            or preceding::article
                            or preceding::dedication
                            or parent::part
                            or parent::reference)">2</xsl:when>
					<xsl:when test="($element = 'chapter' or $element = 'appendix') and
						   (preceding::chapter
                            or preceding::appendix
                            or preceding::article
                            or preceding::preface
                            or parent::book
                            or preceding::dedication
                            or parent::part
                            or parent::reference)">
						<xsl:value-of select="$starting.page.number"/>
					</xsl:when>
					<xsl:otherwise>auto-odd</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<!-- single-sided output -->
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="$element = 'toc'">auto</xsl:when>
					<xsl:when test="$element = 'preface'">auto</xsl:when>
					<xsl:when test="($element = 'dedication' or $element = 'article') and
                        not(preceding::chapter
                            or preceding::preface
                            or preceding::appendix
                            or preceding::article
                            or preceding::dedication
                            or parent::part
                            or parent::reference)">1</xsl:when>
					<xsl:when test="($element = 'chapter' or $element = 'appendix') and
                       (preceding::chapter
                            or preceding::appendix
                            or preceding::preface                            
                            or preceding::article
                            or parent::book
                            or preceding::dedication
                            or parent::part
                            or parent::reference)">
						<xsl:value-of select="$starting.page.number"/>
					</xsl:when>
					<xsl:otherwise>auto</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:param name="local.l10n.xml" select="document(' ')"/>
	<l:i18n xmlns:l="http://docbook.sourceforge.net/xmlns/l10n/1.0">
		<l:l10n language="en">
			<l:context name="title-numbered">
				<l:template name="appendix" text="%n %t"/>
				<l:template name="chapter" text="%n %t"/>
				<l:template name="sect1" text="%n %t"/>
				<l:template name="sect2" text="%n %t"/>
				<l:template name="sect3" text="%n %t"/>
				<l:template name="sect4" text="%n %t"/>
				<l:template name="sect5" text="%n %t"/>
				<l:template name="section" text="%n %t"/>
				<l:template name="simplesect" text="%n %t"/>
			</l:context>
			<l:context name="xref-number-and-title">
				<l:template name="appendix" text="Appendix&#160;%n, %t"/>
				<l:template name="bridgehead" text="Section&#160;%n, &#8220;%t&#8221;"/>
				<l:template name="chapter" text=" Chapter&#160;%n, %t"/>
				<l:template name="equation" text="Equation&#160;%n, &#8220;%t&#8221;"/>
				<l:template name="example" text="Example&#160;%n, &#8220;%t&#8221;"/>
				<l:template name="figure" text="Figure&#160;%n, %t"/>
				<l:template name="part" text="Part&#160;%n, &#8220;%t&#8221;"/>
				<l:template name="procedure" text="Procedure&#160;%n, &#8220;%t&#8221;"/>
				<l:template name="productionset" text="Production&#160;%n, &#8220;%t&#8221;"/>
				<l:template name="qandadiv" text="Q &amp; A&#160;%n, &#8220;%t&#8221;"/>
				<l:template name="refsect1" text="the section called &#8220;%t&#8221;"/>
				<l:template name="refsect2" text="the section called &#8220;%t&#8221;"/>
				<l:template name="refsect3" text="the section called &#8220;%t&#8221;"/>
				<l:template name="refsection" text="the section called &#8220;%t&#8221;"/>
				<l:template name="sect1" text="Section&#160;%n, &#8220;%t&#8221;"/>
				<l:template name="sect2" text="Section&#160;%n, &#8220;%t&#8221;"/>
				<l:template name="sect3" text="Section&#160;%n, &#8220;%t&#8221;"/>
				<l:template name="sect4" text="Section&#160;%n, &#8220;%t&#8221;"/>
				<l:template name="sect5" text="Section&#160;%n, &#8220;%t&#8221;"/>
				<l:template name="section" text="Section&#160;%n, %t"/>
				<l:template name="simplesect" text="the section called &#8220;%t&#8221;"/>
				<l:template name="table" text="Table&#160;%n, &#8220;%t&#8221;"/>
			</l:context>
			<l:context name="title">
				<l:template name="figure" text="Figure&#160;%n&#160;%t"/>
				<l:template name="table" text="Table&#160;%n&#160;%t"/>
			</l:context>
			<l:gentext key="Edition" text="Release"/>
			<l:gentext key="edition" text="Release"/>
		</l:l10n>
	</l:i18n>
	<xsl:template match="edition" mode="titlepage.mode">
		<xsl:call-template name="gentext">
			<xsl:with-param name="key" select="'Edition'"/>
		</xsl:call-template>
		<xsl:call-template name="gentext.space"/>
		<xsl:apply-templates mode="titlepage.mode"/>
	</xsl:template>
	<!-- Changing xref element format -->
	<xsl:template match="section|sect1|sect2|sect3|sect4|sect5
                     |refsect1|refsect2|refsect3|refsection|figure" mode="insert.title.markup">
		<xsl:param name="purpose"/>
		<xsl:param name="title"/>
		<xsl:param name="xrefstyle"/>
		<xsl:choose>
			<xsl:when test="$purpose = 'xref' ">
				<fo:inline font-style="italic">
					<xsl:copy-of select="$title"/>
				</fo:inline>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy-of select="$title"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--StepAlternatives template (style change)-->
	<xsl:template match="procedure/step|substeps/step">
		<xsl:variable name="id">
			<xsl:call-template name="object.id"/>
		</xsl:variable>
		<fo:list-item xsl:use-attribute-sets="list.item.spacing">
			<fo:list-item-label end-indent="label-end()">
				<fo:block id="{$id}">
					<!-- dwc: fix for one step procedures. Use a bullet if there's no step 2 -->
					<!--  <xsl:choose>
          <xsl:when test="count(../step) = 1">
            <xsl:text>&#x2022;</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="." mode="number">
              <xsl:with-param name="recursive" select="0"/>
            </xsl:apply-templates>.
          </xsl:otherwise>
        </xsl:choose>-->
					<xsl:apply-templates select="." mode="number">
						<xsl:with-param name="recursive" select="0"/>
					</xsl:apply-templates>.
      </fo:block>
			</fo:list-item-label>
			<fo:list-item-body start-indent="body-start()">
				<fo:block>
					<xsl:apply-templates/>
				</fo:block>
			</fo:list-item-body>
		</fo:list-item>
	</xsl:template>
	<xsl:template match="stepalternatives">
		<!--<fo:list-block provisional-distance-between-starts="2em"
		 provisional-label-separation="0.2em">
    <xsl:apply-templates select="step"/>
  </fo:list-block>-->
		<xsl:call-template name="getAlt">
			<xsl:with-param name="data" select="."/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="getAlt">
		<xsl:param name="data"/>
		<xsl:for-each select="$data/step">
			<fo:block space-before.optimum="0.5em" space-before.minimum="0.4em" space-before.maximum="0.6em" text-align="left" margin-left="0.4in">
				<fo:inline font-style="italic">Alternative: </fo:inline>
				<xsl:apply-templates/>
			</fo:block>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="step/*[1][local-name()='para' or 
                                   local-name()='simpara' or 
                                   local-name()='formalpara']" priority="2">
		<xsl:call-template name="anchor"/>
		<xsl:apply-templates/>
	</xsl:template>
	<!--
<xsl:template match="stepalternatives/step">
  <xsl:variable name="id">
    <xsl:call-template name="object.id"/>
  </xsl:variable>

  <fo:list-item xsl:use-attribute-sets="list.item.spacing">
    <fo:list-item-label end-indent="label-end()">
      <fo:block id="{$id}">
	<xsl:text>&#x2022;</xsl:text>
      </fo:block>
    </fo:list-item-label>
    <fo:list-item-body start-indent="body-start()">
      <fo:block>
	<xsl:apply-templates/>
      </fo:block>
    </fo:list-item-body>
  </fo:list-item>
</xsl:template>
-->
	<!--	
<xsl:template match="figure">
   <fo:table table-layout="fixed" width="100%">
      <fo:table-column column-width="proportional-column-width(1)"/>
      <fo:table-body>
         <fo:table-row padding-bottom="0.5em">
            <fo:table-cell>
               <fo:block font-family="Verdana"
                         font-style="italic"
                         font-weight="bold"
                         font-size="8pt"
                         line-height="6pt">
                  <xsl:value-of select="title"/>
               </fo:block>
            </fo:table-cell>
         </fo:table-row>
         <fo:table-row keep-with-previous="always">
            <fo:table-cell>
               <fo:block>
                  <fo:external-graphic src="url({@fileref})"
                                       width="{@width}"
                                       height="{@height}"/>
                </fo:block>
            </fo:table-cell>
         </fo:table-row>
     </fo:table-body>
  </fo:table>
</xsl:template>
-->
	<xsl:template match="figure">
		<xsl:variable name="param.placement" select="substring-after(normalize-space($formal.title.placement),
                                        concat(local-name(.), ' '))"/>
		<xsl:variable name="placement">
			<xsl:choose>
				<xsl:when test="contains($param.placement, ' ')">
					<xsl:value-of select="substring-before($param.placement, ' ')"/>
				</xsl:when>
				<xsl:when test="$param.placement = ''">before</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$param.placement"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- Get align value from internal mediaobject -->
		<xsl:variable name="align">
			<xsl:if test="mediaobject|mediaobjectco|screenshot|graphic|graphicco">
				<xsl:variable name="olist" select="mediaobject/imageobject
                                         |mediaobject/imageobjectco
                                         |mediaobject/videoobject
                                         |mediaobject/audioobject
                                         |mediaobject/textobject

                                         |mediaobjectco/imageobject
                                         |mediaobjectco/imageobjectco
                                         |mediaobjectco/videoobject
                                         |mediaobjectco/audioobject
                                         |mediaobjectco/textobject

                                         |screenshot/mediaobject/imageobject
                                         |screenshot/mediaobject/imageobjectco
                                         |screenshot/mediaobject/videoobject
                                         |screenshot/mediaobject/audioobject
                                         |screenshot/mediaobject/textobject

                                         |screenshot/mediaobjectco/imageobject
                                         |screenshot/mediaobjectco/imageobjectco
                                         |screenshot/mediaobjectco/videoobject
                                         |screenshot/mediaobjectco/audioobject
                                         |screenshot/mediaobjectco/textobject

                                         |graphic
                                         |graphicco/graphic
                                         |screenshot/graphic
                                         |screenshot/graphicco/graphic"/>
				<xsl:variable name="object.index">
					<xsl:call-template name="select.mediaobject.index">
						<xsl:with-param name="olist" select="$olist"/>
						<xsl:with-param name="count" select="1"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="object" select="$olist[position() = $object.index]"/>
				<xsl:value-of select="$object/imagedata[@align][1]/@align"/>
			</xsl:if>
		</xsl:variable>
		<xsl:variable name="figure">
			<xsl:choose>
				<xsl:when test="$align != ''">
					<fo:block>
						<xsl:attribute name="text-align"><xsl:value-of select="$align"/></xsl:attribute>
						<xsl:call-template name="formal.object">
							<xsl:with-param name="placement" select="$placement"/>
						</xsl:call-template>
					</fo:block>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="formal.object">
						<xsl:with-param name="placement" select="$placement"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="@float and @float != '0'">
				<fo:float>
					<xsl:attribute name="float"><xsl:choose><xsl:when test="@float = '1'"><xsl:value-of select="$default.float.class"/></xsl:when><xsl:otherwise><xsl:value-of select="@float"/></xsl:otherwise></xsl:choose></xsl:attribute>
					<xsl:copy-of select="$figure"/>
				</fo:float>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy-of select="$figure"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="formal.object">
		<xsl:param name="placement" select="'before'"/>
		<xsl:variable name="id">
			<xsl:call-template name="object.id"/>
		</xsl:variable>
		<xsl:variable name="content">
			<xsl:if test="$placement = 'before'">
				<xsl:call-template name="formal.object.heading">
					<xsl:with-param name="placement" select="$placement"/>
				</xsl:call-template>
			</xsl:if>
			<xsl:apply-templates/>
			<xsl:if test="$placement != 'before'">
				<xsl:call-template name="formal.object.heading">
					<xsl:with-param name="placement" select="$placement"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:variable>
		<xsl:variable name="keep.together">
			<xsl:call-template name="dbfo-attribute">
				<xsl:with-param name="pis" select="processing-instruction('dbfo')"/>
				<xsl:with-param name="attribute" select="'keep-together'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="self::figure">
				<fo:table table-layout="fixed" width="100%">
					<fo:table-column column-width="proportional-column-width(1)"/>
					<fo:table-body>
						<fo:table-row padding-bottom="0.5em">
							<fo:table-cell>
								<fo:block id="{$id}" xsl:use-attribute-sets="figure.properties">
									<xsl:if test="$keep.together != ''">
										<xsl:attribute name="keep-together.within-column"><xsl:value-of select="$keep.together"/></xsl:attribute>
									</xsl:if>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row keep-with-previous="always">
							<fo:table-cell>
								<fo:block>
									<xsl:copy-of select="$content"/>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
				<!--      <fo:block id="{$id}"
                xsl:use-attribute-sets="figure.properties">
        <xsl:if test="$keep.together != ''">
          <xsl:attribute name="keep-together.within-column"><xsl:value-of
                          select="$keep.together"/></xsl:attribute>
        </xsl:if>
        <xsl:copy-of select="$content"/>
      </fo:block>-->
			</xsl:when>
			<xsl:when test="self::example">
				<!--     <fo:block id="{$id}"
                xsl:use-attribute-sets="example.properties">
        <xsl:if test="$keep.together != ''">
          <xsl:attribute name="keep-together.within-column"><xsl:value-of
                          select="$keep.together"/></xsl:attribute>
        </xsl:if>
        <xsl:copy-of select="$content"/>
      </fo:block>-->
				<fo:table table-layout="fixed" width="100%">
					<fo:table-column column-width="proportional-column-width(1)"/>
					<fo:table-body>
						<fo:table-row padding-bottom="0.5em">
							<fo:table-cell>
								<fo:block id="{$id}" xsl:use-attribute-sets="example.properties">
									<xsl:if test="$keep.together != ''">
										<xsl:attribute name="keep-together.within-column"><xsl:value-of select="$keep.together"/></xsl:attribute>
									</xsl:if>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row keep-with-previous="always">
							<fo:table-cell>
								<fo:block>
									<xsl:copy-of select="$content"/>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
			</xsl:when>
			<xsl:when test="self::equation">
				<!--<fo:block id="{$id}"
                xsl:use-attribute-sets="equation.properties">
        <xsl:if test="$keep.together != ''">
          <xsl:attribute name="keep-together.within-column"><xsl:value-of
                          select="$keep.together"/></xsl:attribute>
        </xsl:if>
        <xsl:copy-of select="$content"/>
      </fo:block>-->
				<fo:table table-layout="fixed" width="100%">
					<fo:table-column column-width="proportional-column-width(1)"/>
					<fo:table-body>
						<fo:table-row padding-bottom="0.5em">
							<fo:table-cell>
								<fo:block id="{$id}" xsl:use-attribute-sets="equation.properties">
									<xsl:if test="$keep.together != ''">
										<xsl:attribute name="keep-together.within-column"><xsl:value-of select="$keep.together"/></xsl:attribute>
									</xsl:if>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row keep-with-previous="always">
							<fo:table-cell>
								<fo:block>
									<xsl:copy-of select="$content"/>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
			</xsl:when>
			<xsl:when test="self::table">
				<fo:block id="{$id}" xsl:use-attribute-sets="table.properties">
					<xsl:if test="$keep.together != ''">
						<xsl:attribute name="keep-together.within-column"><xsl:value-of select="$keep.together"/></xsl:attribute>
					</xsl:if>
					<xsl:copy-of select="$content"/>
				</fo:block>
			</xsl:when>
			<xsl:when test="self::procedure">
				<!--  <fo:block id="{$id}"
                xsl:use-attribute-sets="procedure.properties">
        <xsl:if test="$keep.together != ''">
          <xsl:attribute name="keep-together.within-column"><xsl:value-of
                          select="$keep.together"/></xsl:attribute>
        </xsl:if>
        <xsl:copy-of select="$content"/>
      </fo:block>-->
				<fo:table table-layout="fixed" width="100%">
					<fo:table-column column-width="proportional-column-width(1)"/>
					<fo:table-body>
						<fo:table-row padding-bottom="0.5em">
							<fo:table-cell>
								<fo:block id="{$id}" xsl:use-attribute-sets="procedure.properties">
									<xsl:if test="$keep.together != ''">
										<xsl:attribute name="keep-together.within-column"><xsl:value-of select="$keep.together"/></xsl:attribute>
									</xsl:if>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row keep-with-previous="always">
							<fo:table-cell>
								<fo:block>
									<xsl:copy-of select="$content"/>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
			</xsl:when>
			<xsl:otherwise>
				<fo:block id="{$id}" xsl:use-attribute-sets="formal.object.properties">
					<xsl:if test="$keep.together != ''">
						<xsl:attribute name="keep-together.within-column"><xsl:value-of select="$keep.together"/></xsl:attribute>
					</xsl:if>
					<xsl:copy-of select="$content"/>
				</fo:block>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="formal.object.heading">
		<xsl:param name="object" select="."/>
		<xsl:param name="placement" select="'before'"/>
		<fo:block xsl:use-attribute-sets="formal.title.properties">
			<xsl:choose>
				<xsl:when test="$placement = 'before'">
					<xsl:attribute name="keep-with-next.within-column">always</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="keep-with-previous.within-column">always</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:apply-templates select="$object" mode="object.title.markup">
				<xsl:with-param name="allow-anchors" select="1"/>
			</xsl:apply-templates>
		</fo:block>
	</xsl:template>
	<!--Add style to links-->
	<xsl:attribute-set name="xref.properties">
		<xsl:attribute name="color"><xsl:choose><xsl:when test="self::ulink">blue</xsl:when><xsl:when test="self::link">blue</xsl:when><xsl:when test="self::xref">blue</xsl:when><xsl:when test="self::olink">blue</xsl:when><xsl:otherwise>inherit</xsl:otherwise></xsl:choose></xsl:attribute>
		<xsl:attribute name="text-decoration"><xsl:choose><xsl:when test="self::ulink">underline</xsl:when><xsl:when test="self::link">underline</xsl:when><xsl:when test="self::xref">underline</xsl:when><xsl:when test="self::olink">underline</xsl:when><xsl:otherwise>inherit</xsl:otherwise></xsl:choose></xsl:attribute>
		<xsl:attribute name="font-style"><xsl:choose><xsl:when test="self::olink">italic</xsl:when><xsl:otherwise>normal</xsl:otherwise></xsl:choose></xsl:attribute>
	</xsl:attribute-set>
	<!-- To Keep Rows together-->
	<xsl:param name="keep.row.together">1</xsl:param>
<!-- #10831 FOP 95 upgrade - Modified by/Date: Saroja, 02/27/09 BEGIN -->
	<!-- <xsl:template match="row">
		<xsl:param name="spans"/>
		<fo:table-row>
			<xsl:if test="$keep.row.together != '0'">
				<xsl:attribute name="keep-together">always</xsl:attribute>
			</xsl:if>
			<xsl:call-template name="anchor"/>
			<xsl:apply-templates select="(entry|entrytbl)[1]">
				<xsl:with-param name="spans" select="$spans"/>
			</xsl:apply-templates>
		</fo:table-row>
		<xsl:if test="following-sibling::row">
			<xsl:variable name="nextspans">
				<xsl:apply-templates select="(entry|entrytbl)[1]" mode="span">
					<xsl:with-param name="spans" select="$spans"/>
				</xsl:apply-templates>
			</xsl:variable>
			<xsl:apply-templates select="following-sibling::row[1]">
				<xsl:with-param name="spans" select="$nextspans"/>
			</xsl:apply-templates>
		</xsl:if>
	</xsl:template> -->
<!-- #10831 FOP 95 upgrade - Modified by/Date: Saroja, 02/27/09 END -->
	<!-- Customize the titlepage: adding background image and output the bookinfo text on the titlepage-->
	<!-- Define the path to your cover here. -->
	<xsl:param name="cover.path">
		<xsl:value-of select="normalize-space(//bookinfo//imagedata/@fileref)"/>
	</xsl:param>
	<xsl:template name="user.pagemasters">
		<fo:simple-page-master margin-right="0in" margin-left="0in" margin-bottom="0in" margin-top="0in" page-height="11in" page-width="8.5in" master-name="cover">
			<fo:region-body margin-bottom="0in" margin-top="0in" margin-left="0in" margin-right="0in" background-repeat="no-repeat" background-image="{$cover.path}"> 
	  </fo:region-body>
			<fo:region-before extent="0pt" display-align="after" region-name="xsl-region-before-first"/>
			<fo:region-after extent="0pt" display-align="after" region-name="xsl-region-after-first"/>
		</fo:simple-page-master>
		<fo:page-sequence-master master-name="coversequence">
			<fo:repeatable-page-master-alternatives>
				<fo:conditional-page-master-reference master-reference="cover" page-position="first"/>
				<fo:conditional-page-master-reference master-reference="blank" blank-or-not-blank="blank"/>
			</fo:repeatable-page-master-alternatives>
		</fo:page-sequence-master>
	</xsl:template>
	<xsl:template match="*" mode="process.root">
		<xsl:variable name="document.element" select="self::*"/>
		<xsl:call-template name="root.messages"/>
		<xsl:variable name="title">
			<xsl:choose>
				<xsl:when test="$document.element/title[1]">
					<xsl:value-of select="$document.element/title[1]"/>
				</xsl:when>
				<xsl:otherwise>[could not find document title]</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<fo:root xsl:use-attribute-sets="root.properties">
			<xsl:attribute name="language"><xsl:call-template name="l10n.language"><xsl:with-param name="target" select="/*[1]"/></xsl:call-template></xsl:attribute>
			<xsl:if test="$xep.extensions != 0">
				<xsl:call-template name="xep-document-information"/>
			</xsl:if>
			<xsl:if test="$axf.extensions != 0">
				<xsl:call-template name="axf-document-information"/>
			</xsl:if>
			<xsl:call-template name="setup.pagemasters"/>
			<xsl:if test="$fop.extensions != 0">
				<xsl:apply-templates select="$document.element" mode="fop.outline"/>
			</xsl:if>
			<!-- #10831 FOP 95 upgrade - Modified by/Date: Saroja, 03/05/09 BEGIN -->
			<xsl:if test="$fop1.extensions != 0">
				<xsl:variable name="bookmarks">
					<xsl:apply-templates select="$document.element" mode="fop1.outline"/>
				</xsl:variable>
				<xsl:if test="string($bookmarks) != ''">
					<fo:bookmark-tree>
						<xsl:copy-of select="$bookmarks"/>
					</fo:bookmark-tree>
				</xsl:if>
			</xsl:if>
			<!-- #10831 FOP 95 upgrade - Modified by/Date: Saroja, 03/05/09 END -->
			<xsl:if test="$xep.extensions != 0">
				<xsl:variable name="bookmarks">
					<xsl:apply-templates select="$document.element" mode="xep.outline"/>
				</xsl:variable>
				<xsl:if test="string($bookmarks) != ''">
					<rx:outline xmlns:rx="http://www.renderx.com/XSL/Extensions">
						<xsl:copy-of select="$bookmarks"/>
					</rx:outline>
				</xsl:if>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="$rootid != ''">
					<xsl:choose>
						<xsl:when test="count(id($rootid)) = 0">
							<xsl:message terminate="yes">
								<xsl:text>ID '</xsl:text>
								<xsl:value-of select="$rootid"/>
								<xsl:text>' not found in document.</xsl:text>
							</xsl:message>
						</xsl:when>
						<xsl:otherwise>
							<xsl:if test="$fop.extensions != 0">
								<xsl:apply-templates select="id($rootid)" mode="outline"/>
							</xsl:if>
							<xsl:apply-templates select="id($rootid)"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="$fop.extensions != 0">
						<!-- #10831 FOP 95 upgrade - Modified by/Date: Saroja, 02/27/09 -->
						<!--<xsl:apply-templates mode="outline"/>-->
					</xsl:if>
					<fo:page-sequence master-reference="coversequence">
						<!-- Use no-force to prevent a blank page after the
			cover. -->
						<xsl:attribute name="force-page-count"><xsl:value-of select="'no-force'"/></xsl:attribute>
						<fo:flow flow-name="xsl-region-body">
							<!-- #10831 FOP 95 upgrade - Modified by/Date: Saroja, 02/27/09 -->
							<!-- BEGIN: TITLEPAGE_CHANGES, STRATA 4.1.5, Modified by: Bela Patel, Date Modified 08/11/02011-->
						<!--	<fo:block margin-top="5in" margin-left="0.1in" margin-right="0in" text-align="left" color="#003399" font-weight="bold" font-family="Verdana" font-size="17pt" space-before="390px">
								<xsl:value-of select="$title"/>
								<xsl:if test="$document.element/bookinfo/releaseinfo[1]">
									<fo:block space-before="11px" text-align="left" margin-left="6.31in">
										<xsl:text>Release </xsl:text>
										<xsl:value-of select="$document.element/bookinfo/edition[1]"/>
									</fo:block>
									<fo:block space-before="0px" font-size="12pt" font-weight="normal" text-align="left" margin-left="6.31in">
										<xsl:text>Revision </xsl:text>
										<xsl:value-of select="$document.element/bookinfo/releaseinfo[1]"/>
									</fo:block>
								</xsl:if>
								<xsl:if test="not($document.element/bookinfo/releaseinfo[1])">
									<fo:block space-before="20px" text-align="left" margin-left="6.31in">
										<xsl:text>Release </xsl:text>
										<xsl:value-of select="$document.element/bookinfo/edition[1]"/>
									</fo:block>
								</xsl:if>
							</fo:block>-->
							<fo:block margin-top="5.6in" margin-left="0.45in" margin-right="0in" text-align="left" color="#c60c30" font-weight="bold" font-family="Arial" font-size="24pt" space-before="390px">
								<!--<xsl:text>Strata Enterprise</xsl:text>
								<fo:inline color="#c60c30" vertical-align="super" font-size="16pt">&#xae;</fo:inline>-->
								<xsl:text>Strata</xsl:text>
								<fo:inline color="#c60c30" vertical-align="super" font-size="16pt">&#xae;</fo:inline>
								<xsl:text> Enterprise</xsl:text>
								
								<fo:block space-before="20px" text-align="left" color="#000000" font-size="18pt" margin-left="0in">
									<xsl:value-of select="$title"/>
								</fo:block>
								<fo:block space-before="105px"/>
								<xsl:if test="$document.element/bookinfo/releaseinfo[1]">
									<fo:block space-before="5px" text-align="left" color="black" font-size="18pt" margin-left="0in">
										<xsl:text>Release </xsl:text>
										<xsl:value-of select="$document.element/bookinfo/edition[1]"/>
									</fo:block>
								</xsl:if>
								<xsl:if test="not($document.element/bookinfo/releaseinfo[1])">
									<fo:block space-before="5px" text-align="left" color="black" font-size="18pt" margin-left="0in">
										<xsl:text>Release </xsl:text>
										<xsl:value-of select="$document.element/bookinfo/edition[1]"/>
									</fo:block>
								</xsl:if>
								<!--<xsl:variable name="now" select="date:date-time()"/>-->
								<fo:block space-before="10px" text-align="left" color="black" font-size="10pt" margin-left="0in">
								<!--	<xsl:value-of select="November"/>
									<xsl:text>  </xsl:text>-->
									<xsl:text>November 2012</xsl:text>
								</fo:block>
								<fo:block space-before="35px" text-align="left" color="black" font-size="9pt" margin-left="0in">
									<xsl:text>PROPRIETARY &amp; CONFIDENTIAL </xsl:text>
								</fo:block>
							</fo:block>
							<!-- END: TITLEPAGE_CHANGES-->
						</fo:flow>
					</fo:page-sequence>
					<xsl:apply-templates select="$document.element"/>
				</xsl:otherwise>
			</xsl:choose>
		</fo:root>
	</xsl:template>
	<!-- To add Dingbats-->
	<xsl:template match="symbol[@role = 'dingfont']">
		<fo:inline font-family="ZapfDingbats">
			<xsl:call-template name="inline.charseq"/>
		</fo:inline>
	</xsl:template>
	<!-- Add background color to the entry in a table, add eo blue for mainheading(role='mhead'), gray for regular row inside the table(role='rhead'), lighter gray for the subrows in the table (role='shead')-->
	<xsl:template match="entry|entrytbl" name="entry">
		<xsl:param name="col" select="1"/>
		<xsl:param name="spans"/>
		<xsl:variable name="row" select="parent::row"/>
		<xsl:variable name="group" select="$row/parent::*[1]"/>
		<xsl:variable name="frame" select="ancestor::tgroup/parent::*/@frame"/>
		<xsl:variable name="empty.cell" select="count(node()) = 0"/>
		<xsl:variable name="named.colnum">
			<xsl:call-template name="entry.colnum"/>
		</xsl:variable>
		<xsl:variable name="entry.colnum">
			<xsl:choose>
				<xsl:when test="$named.colnum &gt; 0">
					<xsl:value-of select="$named.colnum"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$col"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="entry.colspan">
			<xsl:choose>
				<xsl:when test="@spanname or @namest">
					<xsl:call-template name="calculate.colspan"/>
				</xsl:when>
				<xsl:otherwise>1</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="following.spans">
			<xsl:call-template name="calculate.following.spans">
				<xsl:with-param name="colspan" select="$entry.colspan"/>
				<xsl:with-param name="spans" select="$spans"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="rowsep">
			<xsl:choose>
				<!-- If this is the last row, rowsep never applies. -->
				<xsl:when test="not(ancestor-or-self::row[1]/following-sibling::row
                          or ancestor-or-self::thead/following-sibling::tbody
                          or ancestor-or-self::tbody/preceding-sibling::tfoot)">
					<xsl:value-of select="0"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="inherited.table.attribute">
						<xsl:with-param name="entry" select="."/>
						<xsl:with-param name="colnum" select="$entry.colnum"/>
						<xsl:with-param name="attribute" select="'rowsep'"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!--
  <xsl:message><xsl:value-of select="."/>: <xsl:value-of select="$rowsep"/></xsl:message>
-->
		<xsl:variable name="colsep">
			<xsl:choose>
				<!-- If this is the last column, colsep never applies. -->
				<xsl:when test="$following.spans = ''">0</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="inherited.table.attribute">
						<xsl:with-param name="entry" select="."/>
						<xsl:with-param name="colnum" select="$entry.colnum"/>
						<xsl:with-param name="attribute" select="'colsep'"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="valign">
			<xsl:call-template name="inherited.table.attribute">
				<xsl:with-param name="entry" select="."/>
				<xsl:with-param name="colnum" select="$entry.colnum"/>
				<xsl:with-param name="attribute" select="'valign'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="align">
			<xsl:call-template name="inherited.table.attribute">
				<xsl:with-param name="entry" select="."/>
				<xsl:with-param name="colnum" select="$entry.colnum"/>
				<xsl:with-param name="attribute" select="'align'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="char">
			<xsl:call-template name="inherited.table.attribute">
				<xsl:with-param name="entry" select="."/>
				<xsl:with-param name="colnum" select="$entry.colnum"/>
				<xsl:with-param name="attribute" select="'char'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="charoff">
			<xsl:call-template name="inherited.table.attribute">
				<xsl:with-param name="entry" select="."/>
				<xsl:with-param name="colnum" select="$entry.colnum"/>
				<xsl:with-param name="attribute" select="'charoff'"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$spans != '' and not(starts-with($spans,'0:'))">
				<xsl:call-template name="entry">
					<xsl:with-param name="col" select="$col+1"/>
					<xsl:with-param name="spans" select="substring-after($spans,':')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$entry.colnum &gt; $col">
				<xsl:call-template name="empty.table.cell">
					<xsl:with-param name="colnum" select="$col"/>
				</xsl:call-template>
				<xsl:call-template name="entry">
					<xsl:with-param name="col" select="$col+1"/>
					<xsl:with-param name="spans" select="substring-after($spans,':')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="cell.content">
					<fo:block>
						<xsl:call-template name="table.cell.block.properties"/>
						<!-- are we missing any indexterms? -->
						<xsl:if test="not(preceding-sibling::entry)
                        and not(parent::row/preceding-sibling::row)">
							<!-- this is the first entry of the first row -->
							<xsl:if test="ancestor::thead or
                          (ancestor::tbody
                           and not(ancestor::tbody/preceding-sibling::thead
                                   or ancestor::tbody/preceding-sibling::tbody))">
								<!-- of the thead or the first tbody -->
								<xsl:apply-templates select="ancestor::tgroup/preceding-sibling::indexterm"/>
							</xsl:if>
						</xsl:if>
						<!--
          <xsl:text>(</xsl:text>
          <xsl:value-of select="$rowsep"/>
          <xsl:text>,</xsl:text>
          <xsl:value-of select="$colsep"/>
          <xsl:text>)</xsl:text>
          -->
						<xsl:choose>
							<xsl:when test="$empty.cell">
								<xsl:text>&#160;</xsl:text>
							</xsl:when>
							<xsl:when test="self::entrytbl">
								<xsl:variable name="prop-columns" select=".//colspec[contains(@colwidth, '*')]"/>
								<fo:table xsl:use-attribute-sets="table.table.properties">
									<xsl:if test="count($prop-columns) != 0">
										<xsl:attribute name="table-layout">fixed</xsl:attribute>
									</xsl:if>
									<xsl:call-template name="tgroup"/>
								</fo:table>
							</xsl:when>
							<xsl:otherwise>
								<xsl:apply-templates/>
							</xsl:otherwise>
						</xsl:choose>
					</fo:block>
				</xsl:variable>
				<xsl:variable name="cell-orientation">
					<xsl:call-template name="dbfo-attribute">
						<xsl:with-param name="pis" select="ancestor-or-self::entry/processing-instruction('dbfo')"/>
						<xsl:with-param name="attribute" select="'orientation'"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="row-orientation">
					<xsl:call-template name="dbfo-attribute">
						<xsl:with-param name="pis" select="ancestor-or-self::row/processing-instruction('dbfo')"/>
						<xsl:with-param name="attribute" select="'orientation'"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="cell-width">
					<xsl:call-template name="dbfo-attribute">
						<xsl:with-param name="pis" select="ancestor-or-self::entry/processing-instruction('dbfo')"/>
						<xsl:with-param name="attribute" select="'rotated-width'"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="row-width">
					<xsl:call-template name="dbfo-attribute">
						<xsl:with-param name="pis" select="ancestor-or-self::row/processing-instruction('dbfo')"/>
						<xsl:with-param name="attribute" select="'rotated-width'"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="orientation">
					<xsl:choose>
						<xsl:when test="$cell-orientation != ''">
							<xsl:value-of select="$cell-orientation"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$row-orientation"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:variable name="rotated-width">
					<xsl:choose>
						<xsl:when test="$cell-width != ''">
							<xsl:value-of select="$cell-width"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$row-width"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:variable name="bgcolor">
					<xsl:call-template name="dbfo-attribute">
						<xsl:with-param name="pis" select="ancestor-or-self::entry/processing-instruction('dbfo')"/>
						<xsl:with-param name="attribute" select="'bgcolor'"/>
					</xsl:call-template>
				</xsl:variable>
				<fo:table-cell xsl:use-attribute-sets="table.cell.padding">
					<xsl:call-template name="table.cell.properties"/>
					<xsl:if test="$xep.extensions != 0">
						<!-- Suggested by RenderX to workaround a bug in their implementation -->
						<!--          <xsl:attribute name="keep-together.within-column">always</xsl:attribute> -->
					</xsl:if>
					<xsl:if test="$bgcolor != ''">
						<xsl:attribute name="background-color"><xsl:value-of select="$bgcolor"/></xsl:attribute>
					</xsl:if>
					<xsl:if test="@role='mhead'">
						<xsl:attribute name="background-color"><xsl:value-of select="'#003399'"/></xsl:attribute>
					</xsl:if>
					<xsl:if test="@role='rhead'">
						<xsl:attribute name="background-color"><xsl:value-of select="'#999999'"/></xsl:attribute>
					</xsl:if>
					<xsl:if test="@role='shead'">
						<xsl:attribute name="background-color"><xsl:value-of select="'#e6e6e6'"/></xsl:attribute>
					</xsl:if>
					<xsl:if test="@class='EvenRowRange'">
					<!-- BEGIN: # 41147 (Defect 8196) STRATA RELEASE 4.1.1-->
					<!-- Modified by: DSS, Date Modified 07/23/2007 -->
					<!--	<xsl:attribute name="background-color"><xsl:value-of select="'#99ccff'"/></xsl:attribute> -->
						<xsl:attribute name="background-color"><xsl:value-of select="'#ffffcc'"/></xsl:attribute>
					<!-- END: # 41147 (Defect 8196) -->
					</xsl:if>
					<xsl:if test="@class='OddRowRange'">
					<!-- BEGIN: # 41147 (Defect 8196) STRATA RELEASE 4.1.1-->
					<!-- Modified by: DSS, Date Modified 07/23/2007 -->
					<!--	<xsl:attribute name="background-color"><xsl:value-of select="'#3366ff'"/></xsl:attribute> -->
						<xsl:attribute name="background-color"><xsl:value-of select="'#ccccff'"/></xsl:attribute>
					<!-- END: # 41147 (Defect 8196) -->
					</xsl:if>
					<xsl:if test="@class='EvenColRange'">
					<!-- BEGIN: # 41147 (Defect 8196) STRATA RELEASE 4.1.1-->
					<!-- Modified by: DSS, Date Modified 07/23/2007 -->
					<!--	<xsl:attribute name="background-color"><xsl:value-of select="'#99ccff'"/></xsl:attribute> -->
						<xsl:attribute name="background-color"><xsl:value-of select="'#ffffcc'"/></xsl:attribute>
					<!-- END: # 41147 (Defect 8196) -->
					</xsl:if>
					<xsl:if test="@class='OddColRange'">
					<!-- BEGIN: # 41147 (Defect 8196) STRATA RELEASE 4.1.1-->
					<!-- Modified by: DSS, Date Modified 07/23/2007 -->
					<!--	<xsl:attribute name="background-color"><xsl:value-of select="'#0000ff'"/></xsl:attribute> -->
						<xsl:attribute name="background-color"><xsl:value-of select="'#ccccff'"/></xsl:attribute>
					<!-- END: # 41147 (Defect 8196) -->
					</xsl:if>
					<xsl:if test="@class='EvenResRange'">
					<!-- BEGIN: # 41147 (Defect 8196) STRATA RELEASE 4.1.1-->
					<!-- Modified by: DSS, Date Modified 07/23/2007 -->
					<!--	<xsl:attribute name="color"><xsl:value-of select="'red'"/></xsl:attribute> -->
						<xsl:attribute name="background-color"><xsl:value-of select="'#ffffcc'"/></xsl:attribute>
					<!-- END: # 41147 (Defect 8196) -->
					</xsl:if>
					<!-- BEGIN: # 41147 (Defect 8196) STRATA RELEASE 4.1.1-->
					<!-- Modified by: DSS, Date Modified 07/23/2007 -->
					<xsl:if test="@class='OddResRange'">
						<xsl:attribute name="background-color"><xsl:value-of select="'#ccccff'"/></xsl:attribute>
					</xsl:if>
					<!-- END: # 41147 (Defect 8196) -->
					<xsl:call-template name="anchor"/>
					<xsl:if test="$rowsep &gt; 0">
						<xsl:call-template name="border">
							<xsl:with-param name="side" select="'bottom'"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="$colsep &gt; 0 and $col &lt; ancestor::tgroup/@cols">
						<xsl:call-template name="border">
							<xsl:with-param name="side" select="'right'"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="@morerows">
						<xsl:attribute name="number-rows-spanned"><xsl:value-of select="@morerows+1"/></xsl:attribute>
					</xsl:if>
					<xsl:if test="$entry.colspan &gt; 1">
						<xsl:attribute name="number-columns-spanned"><xsl:value-of select="$entry.colspan"/></xsl:attribute>
					</xsl:if>
					<xsl:if test="$valign != ''">
						<xsl:attribute name="display-align"><xsl:choose><xsl:when test="$valign='top'">before</xsl:when><xsl:when test="$valign='middle'">center</xsl:when><xsl:when test="$valign='bottom'">after</xsl:when><xsl:otherwise><xsl:message><xsl:text>Unexpected valign value: </xsl:text><xsl:value-of select="$valign"/><xsl:text>, center used.</xsl:text></xsl:message><xsl:text>center</xsl:text></xsl:otherwise></xsl:choose></xsl:attribute>
					</xsl:if>
					<xsl:if test="$align != ''">
						<xsl:attribute name="text-align"><xsl:value-of select="$align"/></xsl:attribute>
					</xsl:if>
					<xsl:if test="$char != ''">
						<xsl:attribute name="text-align"><xsl:value-of select="$char"/></xsl:attribute>
					</xsl:if>
					<!--
        <xsl:if test="@charoff">
          <xsl:attribute name="charoff">
            <xsl:value-of select="@charoff"/>
          </xsl:attribute>
        </xsl:if>
-->
					<xsl:choose>
						<xsl:when test="$xep.extensions != 0 and $orientation != ''">
							<fo:block-container reference-orientation="{$orientation}">
								<xsl:if test="$rotated-width != ''">
									<xsl:attribute name="width"><xsl:value-of select="$rotated-width"/></xsl:attribute>
								</xsl:if>
								<xsl:copy-of select="$cell.content"/>
							</fo:block-container>
						</xsl:when>
						<xsl:otherwise>
							<xsl:copy-of select="$cell.content"/>
						</xsl:otherwise>
					</xsl:choose>
				</fo:table-cell>
				<xsl:choose>
					<xsl:when test="following-sibling::entry|following-sibling::entrytbl">
						<xsl:apply-templates select="(following-sibling::entry
                                       |following-sibling::entrytbl)[1]">
							<xsl:with-param name="col" select="$col+$entry.colspan"/>
							<xsl:with-param name="spans" select="$following.spans"/>
						</xsl:apply-templates>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="finaltd">
							<xsl:with-param name="spans" select="$following.spans"/>
							<xsl:with-param name="col" select="$col+$entry.colspan"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--============================================-->
	<xsl:template match="*[@role='notintoc']" mode="toc" priority="2"/>
	<xsl:template match="para[@role='nodisplay']">
	</xsl:template>
	<!--============================================-->
	<!-- Legal Notice Title Customization-->
	<xsl:template match="legalnotice" mode="titlepage.mode">
		<xsl:variable name="id">
			<xsl:call-template name="object.id"/>
		</xsl:variable>
		<fo:block id="{$id}">
			<xsl:if test="title">
				<!-- FIXME: add param for using default title? -->
				<xsl:call-template name="formal.legalnotice.heading"/>
			</xsl:if>
			<xsl:apply-templates mode="titlepage.mode"/>
		</fo:block>
	</xsl:template>
	<xsl:template name="formal.legalnotice.heading">
		<xsl:param name="object" select="."/>
		<xsl:param name="placement" select="'before'"/>
		<fo:block xsl:use-attribute-sets="formal.legaltitle.properties">
			<xsl:choose>
				<xsl:when test="$placement = 'before'">
					<xsl:attribute name="keep-with-next.within-column">always</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="keep-with-previous.within-column">always</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:apply-templates select="$object" mode="object.title.markup">
				<xsl:with-param name="allow-anchors" select="1"/>
			</xsl:apply-templates>
		</fo:block>
	</xsl:template>
	<!-- Setting properties for Legal Notice title -->
	<xsl:attribute-set name="formal.legaltitle.properties" use-attribute-sets="normal.para.spacing">
		<xsl:attribute name="font-family"><xsl:value-of select="'Verdana'"/></xsl:attribute>
		<xsl:attribute name="font-size"><xsl:value-of select="'14pt'"/></xsl:attribute>
		<xsl:attribute name="color"><xsl:value-of select="'#25297c'"/></xsl:attribute>
		<xsl:attribute name="font-weight"><xsl:value-of select="'bold'"/></xsl:attribute>
	</xsl:attribute-set>
	<!--============================================-->
	<!-- To remove start-indent =0 property value error-->
<!-- #10831 FOP 95 upgrade - Modified by/Date: Saroja, 02/27/09 BEGIN -->
	<!-- <xsl:template match="thead">
		<xsl:variable name="tgroup" select="parent::*"/>
		<fo:table-header start-indent="0pt">
			<xsl:apply-templates select="row[1]">
				<xsl:with-param name="spans">
					<xsl:call-template name="blank.spans">
						<xsl:with-param name="cols" select="../@cols"/>
					</xsl:call-template>
				</xsl:with-param>
			</xsl:apply-templates>
		</fo:table-header>
	</xsl:template> -->
	<!-- To remove start-indent =0 property value error-->
	<!-- <xsl:template match="tbody">
		<xsl:variable name="tgroup" select="parent::*"/>
		<fo:table-body start-indent="0pt">
			<xsl:apply-templates select="row[1]">
				<xsl:with-param name="spans">
					<xsl:call-template name="blank.spans">
						<xsl:with-param name="cols" select="../@cols"/>
					</xsl:call-template>
				</xsl:with-param>
			</xsl:apply-templates>
		</fo:table-body>
	</xsl:template> -->
<!-- #10831 FOP 95 upgrade - Modified by/Date: Saroja, 02/27/09 END -->
	<xsl:template match="strike">
		<fo:inline text-decoration="line-through">
			<xsl:apply-templates select="*|text()"/>
		</fo:inline>
	</xsl:template>
	<xsl:template match="br">
		<fo:block> </fo:block>
	</xsl:template>
	<xsl:template match="span">
	<fo:inline color="#288328">
		<xsl:apply-templates/>
	</fo:inline>
	</xsl:template>
<!-- #10831 FOP 95 upgrade - Modified by/Date: Saroja, 02/27/09 BEGIN -->
	<xsl:template match="set|book|part|reference|preface|chapter|appendix|article
                     |glossary|bibliography|index|setindex
                     |refentry
                     |sect1|sect2|sect3|sect4|sect5|section"
              mode="fop.outline">
  <xsl:variable name="id">
    <xsl:call-template name="object.id"/>
  </xsl:variable>
  <xsl:variable name="bookmark-label">
    <xsl:apply-templates select="." mode="object.title.markup"/>
  </xsl:variable>

  <!-- Put the root element bookmark at the same level as its children -->
  <!-- If the object is a set or book, generate a bookmark for the toc -->

  <xsl:choose>
    <xsl:when test="parent::*">
      <fox:outline internal-destination="{$id}">
        <fox:label>
          <xsl:value-of select="normalize-space(translate($bookmark-label, $a-dia, $a-asc))"/>
        </fox:label>
        <!--<xsl:apply-templates select="*" mode="fop.outline"/>-->
      </fox:outline>
    </xsl:when>
    <xsl:otherwise>
      <fox:outline internal-destination="{$id}">
        <fox:label>
          <xsl:value-of select="normalize-space(translate($bookmark-label, $a-dia, $a-asc))"/>
        </fox:label>
      </fox:outline>

      <xsl:variable name="toc.params">
        <xsl:call-template name="find.path.params">
          <xsl:with-param name="table" select="normalize-space($generate.toc)"/>
        </xsl:call-template>
      </xsl:variable>

      <xsl:if test="contains($toc.params, 'toc')
                    and (book|part|reference|preface|chapter|appendix|article
                         |glossary|bibliography|index|setindex
                         |refentry
                         |sect1|sect2|sect3|sect4|sect5|section)">
        <fox:outline internal-destination="toc...{$id}">
          <fox:label>
            <xsl:call-template name="gentext">
              <xsl:with-param name="key" select="'TableofContents'"/>
            </xsl:call-template>
          </fox:label>
        </fox:outline>
      </xsl:if>
   <!--   <xsl:apply-templates select="*" mode="fop.outline"/>-->
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>
<!-- #10831 FOP 95 upgrade - Modified by/Date: Saroja, 02/27/09 END -->
<!--	<xsl:template name="section.content">
  <xsl:call-template name="section.titlepage"/>
  <xsl:variable name="toc.params">
    <xsl:call-template name="find.path.params">
      <xsl:with-param name="table" select="normalize-space($generate.toc)"/>
    </xsl:call-template>
  </xsl:variable>

  <xsl:if test="contains($toc.params, 'toc')
                and (count(ancestor::section)+1) &lt;= $generate.section.toc.level">
    <xsl:call-template name="section.toc">
      <xsl:with-param name="toc.title.p" select="contains($toc.params, 'title')"/>
    </xsl:call-template>
   <xsl:call-template name="section.toc.separator"/>
  </xsl:if>
  <xsl:variable name="master-reference">
    <xsl:call-template name="select.pagemaster"/>
  </xsl:variable>
<fo:page-sequence master-reference="$master-reference">
	<fo:flow flow-name="xsl-region-body">
		<xsl:apply-templates/>
	</fo:flow>
</fo:page-sequence>
</xsl:template>-->
	<!--<xsl:template match="table">
<fo:page-sequence master-reference="content">
    <fo:flow flow-name="xsl-region-body">
  <xsl:choose>
    <xsl:when test="tgroup|mediaobject|graphic">
      <xsl:call-template name="calsTable"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates select="." mode="htmlTable"/>
    </xsl:otherwise>
  </xsl:choose>
</fo:flow>
</fo:page-sequence>
</xsl:template>-->
</xsl:stylesheet>
