/*
 * Decompiled with CFR 0.152.
 */
package com.stattmann.swing.util;

import com.stattmann.swing.FunkySwing;
import com.sun.java.swing.plaf.motif.MotifLookAndFeel;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UIHelper {
    static final Log log = LogFactory.getLog((Class)(class$com$stattmann$swing$util$UIHelper == null ? (class$com$stattmann$swing$util$UIHelper = UIHelper.class$("com.stattmann.swing.util.UIHelper")) : class$com$stattmann$swing$util$UIHelper));
    static /* synthetic */ Class class$com$stattmann$swing$util$UIHelper;

    public static void setLookAndFeel(LookAndFeel plaf) {
        try {
            log.info((Object)("Look and feel set to " + plaf));
            UIManager.setLookAndFeel(plaf);
        }
        catch (Exception e) {
            log.error((Object)"Error setting custom look and feel: ", (Throwable)e);
            try {
                UIManager.setLookAndFeel(new MotifLookAndFeel());
            }
            catch (Exception e2) {
                log.error((Object)"Error setting Motif look and feel: ", (Throwable)e2);
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e3) {
                    log.error((Object)"Error setting system look and feel: ", (Throwable)e3);
                }
            }
        }
    }

    public static void updateLookAndFeel() {
        try {
            SwingUtilities.updateComponentTreeUI(FunkySwing.getInstance().getRootFrame().getContentPane());
            SwingUtilities.updateComponentTreeUI(FunkySwing.getInstance().getRootFrame());
            SwingUtilities.updateComponentTreeUI(FunkySwing.getInstance().getPopup());
            SwingUtilities.updateComponentTreeUI(FunkySwing.getInstance().getDialog1());
            SwingUtilities.updateComponentTreeUI(FunkySwing.getInstance().getDialog2());
        }
        catch (Exception ex) {
            log.error((Object)"Failed updating L&F: ", (Throwable)ex);
        }
    }

    public static LookAndFeel getSystemPlaf() {
        LookAndFeel systemPlaf = null;
        try {
            Class<?> plafClass = Class.forName(UIManager.getSystemLookAndFeelClassName(), true, Thread.currentThread().getContextClassLoader());
            systemPlaf = (LookAndFeel)plafClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"cannot load SystemLookAndFeelClass", (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)"cannot load SystemLookAndFeelClass", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"cannot load SystemLookAndFeelClass", (Throwable)e);
        }
        return systemPlaf;
    }

    public static void openFrame(final Frame frame) {
        boolean trypatch = false;
        if (trypatch) {
            final Dimension dimension = frame.getSize();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    frame.setSize(dimension);
                }
            });
            frame.setSize(dimension);
        }
        if (frame.getState() == 1) {
            frame.setState(0);
        }
        frame.setVisible(true);
        frame.requestFocus();
        UIHelper.bringWindowsToFront();
    }

    public static void bringWindowsToFront() {
        Frame rootFrame = JOptionPane.getRootFrame();
        Window[] windows = rootFrame.getOwnedWindows();
        for (int i = 0; i < windows.length; ++i) {
            windows[i].toFront();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

