/*
 * Decompiled with CFR 0.152.
 */
package com.stattmann.swing;

import com.stattmann.swing.DebugOutput;
import com.stattmann.swing.command.CommandAction;
import com.stattmann.swing.command.DummyCommand;
import com.stattmann.swing.command.PlafCommand;
import com.stattmann.swing.command.PopupWeightCommandH;
import com.stattmann.swing.command.PopupWeightCommandL;
import com.stattmann.swing.listener.DialogMouseListener;
import com.stattmann.swing.listener.MenuItemListener;
import com.stattmann.swing.listener.PopUpMouseListener;
import com.stattmann.swing.manager.CommandManagerImpl;
import com.stattmann.swing.util.TestLookAndFeel;
import com.stattmann.swing.util.UIHelper;
import com.sun.java.swing.plaf.motif.MotifLookAndFeel;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FunkySwing {
    private static FunkySwing ourInstance = new FunkySwing();
    private JFrame rootFrame;
    private JPopupMenu popup;
    private JDialog dialog1;
    private JDialog dialog2;
    public static boolean repositionDialogs;
    protected static DebugOutput debugOutput;
    static final Log log;
    static /* synthetic */ Class class$com$stattmann$swing$FunkySwing;

    public static FunkySwing getInstance() {
        return ourInstance;
    }

    public static void main(String[] args) {
        FunkySwing FunkySwing2 = FunkySwing.getInstance();
        FunkySwing2.main();
    }

    void main() {
        this.initialize();
        this.configure();
        this.start();
    }

    private void initialize() {
    }

    private void configure() {
    }

    public void start() {
        ImageIcon icon = FunkySwing.createImageIcon("images/middle.gif");
        this.rootFrame = new JFrame("FunkySwing");
        this.rootFrame.setDefaultCloseOperation(3);
        this.rootFrame.setName("com.stattmann.swing.FunkySwing");
        this.rootFrame.setSize(800, 400);
        this.rootFrame.setJMenuBar(this.createMenuBar());
        JComponent mainWindow = this.createContentPane();
        this.rootFrame.setContentPane(mainWindow);
        UIHelper.openFrame(this.rootFrame);
    }

    public JMenuBar createMenuBar() {
        JMenuBar menubar = new JMenuBar();
        menubar.setName("The Menubar");
        JMenu plafmenu = FunkySwing.createPlafMenu();
        JMenu helpmenu = FunkySwing.createTestMenu();
        JMenu helpmenu2 = FunkySwing.createTestMenu();
        JButton flush = new JButton("flush");
        flush.setAction(new AbstractAction("FLUSH"){

            public void actionPerformed(ActionEvent e) {
                debugOutput.flush();
            }
        });
        menubar.add(plafmenu);
        menubar.add(helpmenu);
        menubar.add(helpmenu2);
        menubar.add(flush);
        return menubar;
    }

    public JToolBar createToolBar() {
        JToolBar toolbar = new JToolBar("The Toolbar");
        DummyCommand dummy = new DummyCommand();
        CommandAction dummyCommandAction = dummy.getCommandAction();
        JButton button = new JButton("testbutton");
        button.setAction(dummyCommandAction);
        toolbar.add(button);
        JMenu text1 = new JMenu("decorated Dialog");
        text1.setName("decorated Dialog");
        this.dialog1 = FunkySwing.createDialog(this.rootFrame, false, false);
        DialogMouseListener.addDialogTo(text1, this.dialog1);
        toolbar.add(text1);
        JMenu text2 = new JMenu("UNdecorated Dialog");
        text2.setName("UNdecorated Dialog");
        this.dialog2 = FunkySwing.createDialog(this.rootFrame, false, true);
        DialogMouseListener.addDialogTo(text2, this.dialog2);
        toolbar.add(text2);
        return toolbar;
    }

    public JComponent createContentPane() {
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setOpaque(true);
        this.popup = FunkySwing.createPopup();
        PopUpMouseListener.addContextMenuTo(debugOutput.getViewport().getView(), this.popup);
        contentPane.add((Component)this.createToolBar(), "North");
        contentPane.add((Component)debugOutput, "Center");
        return contentPane;
    }

    public static JDialog createDialog(Frame frame, boolean modal, boolean undecorated) {
        Color red = new Color(255, 0, 0);
        final JDialog dialog = new JDialog(frame, "aJDialog", modal);
        JPanel contentPane = new JPanel(new BorderLayout());
        dialog.setContentPane(contentPane);
        dialog.setSize(200, 100);
        dialog.setUndecorated(undecorated);
        dialog.setBackground(red);
        dialog.getContentPane().setForeground(red);
        dialog.getRootPane().setWindowDecorationStyle(7);
        JTextField textfield = new JTextField("something on the dialog");
        textfield.setBackground(red);
        dialog.getContentPane().add((Component)textfield, "North");
        JButton okButton = new JButton("OK Button");
        okButton.setBackground(red);
        okButton.setAction(new AbstractAction("OK!"){

            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        });
        dialog.getContentPane().add((Component)okButton, "Center");
        return dialog;
    }

    public static JPopupMenu createPopup() {
        JPopupMenu popupMenu = new JPopupMenu("aPopUp");
        PopupWeightCommandL changeWeightL = new PopupWeightCommandL(popupMenu);
        PopupWeightCommandH changeWeightH = new PopupWeightCommandH(popupMenu);
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem lightweight = new JRadioButtonMenuItem("LightWeight popups");
        lightweight.setSelected(popupMenu.isLightWeightPopupEnabled());
        JRadioButtonMenuItem heavyweight = new JRadioButtonMenuItem("HeavyWeight popups");
        heavyweight.setSelected(!popupMenu.isLightWeightPopupEnabled());
        group.add(lightweight);
        group.add(heavyweight);
        lightweight.setAction(changeWeightL.getCommandAction());
        heavyweight.setAction(changeWeightH.getCommandAction());
        popupMenu.add(lightweight);
        popupMenu.add(heavyweight);
        return popupMenu;
    }

    public static JMenu createPlafMenu() {
        JMenu plafmenu = new JMenu("Look & Feel");
        DummyCommand dummy = new DummyCommand(){

            public void execute(AWTEvent e, Component c) {
                repositionDialogs = !repositionDialogs;
                log.info((Object)("reposition: " + repositionDialogs));
            }
        };
        ((DummyCommand)dummy).setName("reposition-dialogs");
        JCheckBoxMenuItem helpentry2 = new JCheckBoxMenuItem("try to reposition dialogs");
        helpentry2.setSelected(repositionDialogs);
        log.info((Object)("reposition: " + repositionDialogs));
        log.info((Object)("name: " + dummy.getName()));
        CommandManagerImpl.getInstance().registerCommand(dummy);
        MenuItemListener.createCommandListenerAdapter(helpentry2, dummy.getName());
        plafmenu.add(helpentry2);
        plafmenu.addSeparator();
        ButtonGroup group = new ButtonGroup();
        LookAndFeel systemPlaf = UIHelper.getSystemPlaf();
        if (systemPlaf != null) {
            PlafCommand defaultPlafCommand = new PlafCommand(systemPlaf);
            JRadioButtonMenuItem defaultPlaf = new JRadioButtonMenuItem("default-plaf");
            defaultPlaf.setSelected(true);
            defaultPlaf.setMnemonic(68);
            defaultPlaf.setAction(defaultPlafCommand.getCommandAction());
            group.add(defaultPlaf);
            plafmenu.add(defaultPlaf);
        }
        PlafCommand motifPlafCommand = new PlafCommand(new MotifLookAndFeel());
        JRadioButtonMenuItem motifPlaf = new JRadioButtonMenuItem("motif-plaf");
        group.add(motifPlaf);
        motifPlaf.setAction(motifPlafCommand.getCommandAction());
        plafmenu.add(motifPlaf);
        PlafCommand testPlafCommand = new PlafCommand((LookAndFeel)((Object)new TestLookAndFeel()));
        JRadioButtonMenuItem testPlaf = new JRadioButtonMenuItem("test-plaf");
        testPlaf.setAction(testPlafCommand.getCommandAction());
        group.add(testPlaf);
        plafmenu.add(testPlaf);
        return plafmenu;
    }

    public static JMenu createTestMenu() {
        JMenu menu = new JMenu("testMenu");
        DummyCommand dummy = new DummyCommand();
        CommandAction dummyCommandAction = dummy.getCommandAction();
        JMenuItem popupMenuItem = new JMenuItem("A popup menu item");
        popupMenuItem.setAction(dummyCommandAction);
        menu.add(popupMenuItem);
        JMenuItem popupMenuItem2 = new JMenuItem("Another popup menu item");
        popupMenuItem2.setAction(dummyCommandAction);
        menu.add(popupMenuItem2);
        return menu;
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = (class$com$stattmann$swing$FunkySwing == null ? (class$com$stattmann$swing$FunkySwing = FunkySwing.class$("com.stattmann.swing.FunkySwing")) : class$com$stattmann$swing$FunkySwing).getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    public static void open(final Frame frame) {
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UIHelper.openFrame(frame);
                }
            });
        } else {
            UIHelper.openFrame(frame);
        }
    }

    public JFrame getRootFrame() {
        return this.rootFrame;
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }

    public JDialog getDialog1() {
        return this.dialog1;
    }

    public JDialog getDialog2() {
        return this.dialog2;
    }

    public static void debug(AWTEvent e) {
        debugOutput.print(e);
    }

    public static void debug(String s) {
        debugOutput.print(s);
    }

    public static Log getLog() {
        return log;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        debugOutput = new DebugOutput(5, 30);
        log = LogFactory.getLog((Class)(class$com$stattmann$swing$FunkySwing == null ? (class$com$stattmann$swing$FunkySwing = FunkySwing.class$("com.stattmann.swing.FunkySwing")) : class$com$stattmann$swing$FunkySwing));
    }
}

