with Gtk.Enums; use Gtk.Enums;
with Gtkada.Handlers; use Gtkada.Handlers;
with Callbacks_Pixtest; use Callbacks_Pixtest;
with Dialog1_Pkg.Callbacks; use Dialog1_Pkg.Callbacks;

package body Dialog1_Pkg is

procedure Gtk_New (Dialog1 : out Dialog1_Access) is
begin
   Dialog1 := new Dialog1_Record;
   Dialog1_Pkg.Initialize (Dialog1);
end Gtk_New;

procedure Initialize (Dialog1 : access Dialog1_Record'Class) is
   pragma Suppress (All_Checks);
begin
   Gtk.Dialog.Initialize (Dialog1);
   Set_Title (Dialog1, "pixtest");
   Set_Position (Dialog1, Win_Pos_None);
   Dialog_Callback.Connect
     (Dialog1, "close",
      Dialog_Callback.To_Marshaller (On_Dialog1_Close'Access), False);

   Gtk_New_From_Stock (Dialog1.Closebutton1, "gtk-close");
   Grab_Focus (Dialog1.Closebutton1);
   Button_Callback.Connect
     (Dialog1.Closebutton1, "clicked",
      Button_Callback.To_Marshaller (On_Closebutton1_Clicked'Access), False);
   Pack_Start (Get_Action_Area (Dialog1), Dialog1.Closebutton1);
   Dialog1_Pkg.Dialog := Dialog1_Access(Dialog1);

   Gtk_New (Dialog1.Drawingarea1);
   Set_Size_Request(Dialog1.Drawingarea1, 100, 100);
   Pack_Start
     (Get_Vbox (Dialog1),
      Dialog1.Drawingarea1,
      Expand  => True,
      Fill    => True,
      Padding => 0);
   Show_All(Dialog1);
   Gdkw := Get_Window(Dialog1.Drawingarea1);
   Gdk_New(Gc, Gdkw);
   Return_Callback.Connect
     (Dialog1.Drawingarea1, "expose_event", On_Drawingarea1_Expose_Event'Access, False);

end Initialize;

end Dialog1_Pkg;
