/* Example from:
http://mail.gnome.org/archives/gtkmm-list/2009-July/msg00127.html

*/

#include <gtkmm.h>

bool slot_timeout( int timer_number ) {
    return true;
}

int main( int argc, char **argv ) {
    // if comment below, no cpu loads
    if( !Glib::thread_supported() ) Glib::thread_init();

    sigc::slot< bool > timeout = sigc::bind( sigc::ptr_fun(&slot_timeout ), 0 );
    // CPU useage becomes about 15% (Athlon2500)
    Glib::signal_timeout().connect( timeout, 33 );
    // if your pc is powerful , uncomment below
//    Glib::signal_timeout().connect( timeout, 25 );

    Gtk::Main m( &argc, &argv );
    Gtk::Window* obj = new Gtk::Window();
    m.run(*obj);

    return 0;
}