/**
	Implements a number of utility functions for rooms including exits
	guardians, exit messages, listen (but not add_sound...) and smell
	(but not add_smell) (see Items for add_sound and add_smell among
	other similar functions.
*/
#include <daemons.h>
#include <hooks.h>


inherit "/obj/messaging/grammar/display.c";
inherit "/std/object/hooks";


/**
	public access to validate exit "
*/
int query_valid_exit_path(string path)
{
	return validate_exit(path);
}

/** 
Register a new exit to the room object. Adds the exit to our exit_hash map with some safety checks for whether we've been passed an array of exits or just one.

New practice; there's now an exit hash map ([direction:hash])
and we add exits into our hash map as they're created. This is how guards
are now identified: they're assigned the hashes they guard as IDs.

@usage{
add_exit("next_room.c", "north", 0);
add_exit("next_room2.c", "south", 0);
add_exit("next_room3.c", "east", 0);
add_exit("next_room4.c", "west", 0);
}

@par Usage:
@code
add_exit("next_room.c", "north", 0);
@endcode

*/
varargs int add_exit(mixed destination, string direction, int unobvious)
{
	if(!pointerp(destination) && direction)
	{
		if(validate_exit(destination))
		{
			exit_hash += ([direction:md5(direction+time())]);
			exits += ([direction:destination;unobvious]);
			return 1;
		}
		return 0;
	}
	if(pointerp(destination)){destination = flatten_array(destination);}
	int dest_size = sizeof(destination);
	/// if they're a fucktard and gave us an array for an exit we'll flatten and re-call ourselves.
	if(pointerp(destination) && dest_size >= 2 && !direction)
	{
		/// let's fucking make sure it's at least one pair, then
		if(!(dest_size % 2))
		{
			int successes;
			foreach(int pair : dest_size/2)
			{
				int thing1 = pair * 2;
				int thing2 = thing1 + 1;
				/// flatten the pair and re call
				successes += add_exit(destination[thing1], destination[thing2]);
			}
			return successes;
		}
		return 0;
	}
}

/**
	Given a direction, remove that exit.
*/
int remove_exit(string direction)
{
	if(direction)
	{
		int pre_size = sizeof(exits);
		exits -= ([direction]);
		if(pre_size > sizeof(exits))
		{
			return 1;
		}
		return 0;
	}
}