-- MySQL dump 10.13  Distrib 5.5.15, for Win32 (x86)
--
-- Host: localhost    Database: gnucashtest
-- ------------------------------------------------------
-- Server version	5.5.17

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `gnucashtest`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `gnucashtest` /*!40100 DEFAULT CHARACTER SET utf8 */;

USE `gnucashtest`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounts` (
  `guid` varchar(32) NOT NULL,
  `name` varchar(2048) NOT NULL,
  `account_type` varchar(2048) NOT NULL,
  `commodity_guid` varchar(32) DEFAULT NULL,
  `commodity_scu` int(11) NOT NULL,
  `non_std_scu` int(11) NOT NULL,
  `parent_guid` varchar(32) DEFAULT NULL,
  `code` varchar(2048) DEFAULT NULL,
  `description` varchar(2048) DEFAULT NULL,
  `hidden` int(11) DEFAULT NULL,
  `placeholder` int(11) DEFAULT NULL,
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` (`guid`, `name`, `account_type`, `commodity_guid`, `commodity_scu`, `non_std_scu`, `parent_guid`, `code`, `description`, `hidden`, `placeholder`) VALUES ('028ee5a7e913d922bc51047137eda82d','Comestibles','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'538dd132106b1fa8ab0e6b07bb6ba900','','Comestibles',0,0),('0386556dd6a8c6de15d0f344174ccf32','Servicios','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'538dd132106b1fa8ab0e6b07bb6ba900','','Servicios',0,0),('06c893017e8e0f384901162617bc2330','Teléfono','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'538dd132106b1fa8ab0e6b07bb6ba900','','Teléfono',0,0),('090121eec3532ef0fa6df40dbe011c16','Balances de apertura','EQUITY','e225033e40c0175343d198edc209bf8b',100,0,'80e25d35a37c444e1cc7d05ca04c18ab','','Balances de apertura',0,0),('11610b53ba57ab8a8b44fc8c632ba467','Seguros','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'538dd132106b1fa8ab0e6b07bb6ba900','','Seguros',0,0),('12ccc5bf661f18bdcf81d59cdd51fee6','Seguro sanitario','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'11610b53ba57ab8a8b44fc8c632ba467','','Seguro sanitario',0,0),('166c980f5ebeccbcd1998283fce8b2f1','Servicios Internet','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'538dd132106b1fa8ab0e6b07bb6ba900','','Servicios Internet',0,0),('17b6bc0da7aead4357520dc210967b58','Casa','ASSET','e225033e40c0175343d198edc209bf8b',100,0,'4a4aaa1f23c7c46d2f9f2a8227242e3d','','Casa',0,0),('1cddd477b69be841b816627cc4a9ffb0','Activo circulante','ASSET','e225033e40c0175343d198edc209bf8b',100,0,'431fa1aed77d4b6637884ed8e50730c8','','Activo circulante',0,0),('1e2c5b00ba7743d4ab73ac634592d546','Suscripciones','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'538dd132106b1fa8ab0e6b07bb6ba900','','Suscripciones',0,0),('1ed12bc6f1d47e2160777de038d769c3','Ropa','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'538dd132106b1fa8ab0e6b07bb6ba900','','Ropa',0,0),('2679e9be1dec90ce8ebe01e23120311a','Retenciones','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'555c138c1c9cbc8d9185f8c70c46beca','','Retenciones',0,0),('288d18f78e6e9bf3e01727dbc915e382','Seguro de vida','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'11610b53ba57ab8a8b44fc8c632ba467','','Seguro de vida',0,0),('2be9a5600f5c6f7db9407bbe27518f7a','Intereses','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'538dd132106b1fa8ab0e6b07bb6ba900','','Intereses',0,0),('2c9f62223c4fee77567b0b9831f62dab','Informática','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'538dd132106b1fa8ab0e6b07bb6ba900','','Informática',0,0),('3a9bf6e5a25526142bd984b9bffc150f','Pagas extra','INCOME','e225033e40c0175343d198edc209bf8b',100,0,'9c939bc93e2393d7d371ef06a69696ca','','Pagas extra',0,0),('3c0106b00f0227980cc8f743720a1127','Sueldo','INCOME','e225033e40c0175343d198edc209bf8b',100,0,'9c939bc93e2393d7d371ef06a69696ca','','Sueldo',0,0),('3dcbeb0a491150890e94486812658c87','Otros intereses','INCOME','e225033e40c0175343d198edc209bf8b',100,0,'a107253ce8590ae73346677eb98f1516','','Otros intereses',0,0),('431fa1aed77d4b6637884ed8e50730c8','Activo','ASSET','e225033e40c0175343d198edc209bf8b',100,0,'4cca82808a5958d2e3c2e958cc5f38ef','','Activo',0,0),('45d4e2363f33d5b095ac89d9017c52ff','Ajustes','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'538dd132106b1fa8ab0e6b07bb6ba900','','Ajustes',0,0),('4a4aaa1f23c7c46d2f9f2a8227242e3d','Activo fijo','ASSET','e225033e40c0175343d198edc209bf8b',100,0,'431fa1aed77d4b6637884ed8e50730c8','','Activo fijo',0,0),('4b79781879e5607b4d8b8c208132835f','Pasivo','LIABILITY','e225033e40c0175343d198edc209bf8b',100,0,'4cca82808a5958d2e3c2e958cc5f38ef','','Pasivo',0,0),('4cca82808a5958d2e3c2e958cc5f38ef','Root Account','ROOT',NULL,0,0,NULL,'','',0,0),('4fdfad7162508e7b4c1e7850807c47f2','Material de oficina','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'538dd132106b1fa8ab0e6b07bb6ba900','','Material de oficina',0,0),('50ce48623f367211dc16504d91ca6291','Libros','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'538dd132106b1fa8ab0e6b07bb6ba900','','Libros',0,0),('538dd132106b1fa8ab0e6b07bb6ba900','Gastos','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'4cca82808a5958d2e3c2e958cc5f38ef','','Gastos',0,0),('542759c1e5ba7e4c6b009cf376b8e8d8','Gas','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'e5a91af4af59a4786c603151ae00b7cf','','Gas',0,0),('555c138c1c9cbc8d9185f8c70c46beca','Impuestos','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'538dd132106b1fa8ab0e6b07bb6ba900','','Impuestos',0,0),('5cd8be2e98e5aa4e48e07a21eba5bd72','Reparación y mantenimiento','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'e5a91af4af59a4786c603151ae00b7cf','','Reparación y mantenimiento',0,0),('65aab4fef77df07ccddbeb33bac52ed1','IRPF','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'555c138c1c9cbc8d9185f8c70c46beca','','IRPF',0,0),('65e0dcc996ae4c9fb661a1eb2c0f9a12','Recogida de basura','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'0386556dd6a8c6de15d0f344174ccf32','','Recogida de basura',0,0),('665dfa0f3cd63d5991cdd9c8260e72d0','Música/Películas','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'a00e4e1abb5a68be4fb34b7840557eaa','','Música/Películas',0,0),('6816e5fac761ef80cb79c856cb39b4a0','Obras benéficas','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'538dd132106b1fa8ab0e6b07bb6ba900','','Obras benéficas',0,0),('68877a149a27f1d661d7fab3f340ef53','Cuentas por pagar','LIABILITY','e225033e40c0175343d198edc209bf8b',100,0,'4b79781879e5607b4d8b8c208132835f','','Cuentas por pagar',0,0),('6966142106c3c448f4448e3e8e616886','Recreación','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'a00e4e1abb5a68be4fb34b7840557eaa','','Recreación',0,0),('6bf1e7f2231cf63de66a6671c0e81e9d','Municipales','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'555c138c1c9cbc8d9185f8c70c46beca','','Municipales',0,0),('6c5136161ecfce244fd54c2492b95003','Template Root','ROOT',NULL,0,0,NULL,'','',0,0),('7712389e5ae441ee95db9fbb1e299f53','Gas','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'0386556dd6a8c6de15d0f344174ccf32','','Gas',0,0),('7caab5ee6674b0347c3a2b948d9e75b5','Otros ingresos','INCOME','e225033e40c0175343d198edc209bf8b',100,0,'9c939bc93e2393d7d371ef06a69696ca','','Otros ingresos',0,0),('80e25d35a37c444e1cc7d05ca04c18ab','Resultado','EQUITY','e225033e40c0175343d198edc209bf8b',100,0,'4cca82808a5958d2e3c2e958cc5f38ef','','Resultado',0,0),('8534b89811d0bf18872569db9c281688','Lavandería','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'538dd132106b1fa8ab0e6b07bb6ba900','','Lavandería',0,0),('8537aebb8f575e1d04af7fb347cdf653','TV Cable','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'538dd132106b1fa8ab0e6b07bb6ba900','','TV Cable',0,0),('855ac871ba1552233e26ab0f1bb6c47d','Cargo de servicio bancario','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'538dd132106b1fa8ab0e6b07bb6ba900','','Cargo de servicio bancario',0,0),('87a4aac22d84d694685fef596e5b5e2b','Restaurantes','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'538dd132106b1fa8ab0e6b07bb6ba900','','Restaurantes',0,0),('899c1d2091803689b587e73b13dd13ff','Transporte público','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'538dd132106b1fa8ab0e6b07bb6ba900','','Transporte público',0,0),('8c968aa09677b768a3e0f3f4cb61cf73','Intereses cuenta de ahorros','INCOME','e225033e40c0175343d198edc209bf8b',100,0,'a107253ce8590ae73346677eb98f1516','','Intereses cuenta de ahorros',0,0),('9c939bc93e2393d7d371ef06a69696ca','Ingresos','INCOME','e225033e40c0175343d198edc209bf8b',100,0,'4cca82808a5958d2e3c2e958cc5f38ef','','Ingresos',0,0),('a00e4e1abb5a68be4fb34b7840557eaa','Ocio','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'538dd132106b1fa8ab0e6b07bb6ba900','','Ocio',0,0),('a107253ce8590ae73346677eb98f1516','Ingresos por intereses','INCOME','e225033e40c0175343d198edc209bf8b',100,0,'9c939bc93e2393d7d371ef06a69696ca','','Ingresos por intereses',0,0),('a339d771d007c337ef954f98d0ab2831','Tarjeta de crédito','CREDIT','e225033e40c0175343d198edc209bf8b',100,0,'68877a149a27f1d661d7fab3f340ef53','','Tarjeta de crédito',0,0),('a42223761432667f972c138a803ee41c','Electricidad','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'0386556dd6a8c6de15d0f344174ccf32','','Electricidad',0,0),('a645942529e7f4ed72cbc29ca789820d','Préstamo hipotecario','LIABILITY','e225033e40c0175343d198edc209bf8b',100,0,'e0e53aed312be37ecdd7268e4affeb84','','Préstamo hipotecario',0,0),('a69d014926d9de7601e79932d6b0ffca','Viajes','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'a00e4e1abb5a68be4fb34b7840557eaa','','Viajes',0,0),('a991cc863487ca39d4ce1c9967e92776','Aparcamiento','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'e5a91af4af59a4786c603151ae00b7cf','','Aparcamiento',0,0),('ac235dffa4f8aad77cdbb7e343c288ff','Cuotas','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'e5a91af4af59a4786c603151ae00b7cf','','Cuotas',0,0),('ae7bf7443c1019f40d785d057f7849e7','Seguridad Social','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'555c138c1c9cbc8d9185f8c70c46beca','','Seguridad Social',0,0),('ae9cc28f7a439f8beec85825a3e77803','Cuenta corriente','BANK','e225033e40c0175343d198edc209bf8b',100,0,'1cddd477b69be841b816627cc4a9ffb0','','Cuenta corriente',0,0),('aee1724fd077e1a09e90bc3c6041dd02','Otros impuestos','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'555c138c1c9cbc8d9185f8c70c46beca','','Otros impuestos',0,0),('b0c3b79d4e6cdf8d4e1adf192ab368ee','Vehículo','ASSET','e225033e40c0175343d198edc209bf8b',100,0,'4a4aaa1f23c7c46d2f9f2a8227242e3d','','Vehículo',0,0),('b1b741b10b93e98cfba7c82b2b3e0d65','Educación','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'538dd132106b1fa8ab0e6b07bb6ba900','','Educación',0,0),('b27d604ba3d1b8e7314a0f7cd480eb8b','Interés de hipoteca','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'2be9a5600f5c6f7db9407bbe27518f7a','','Interés de hipoteca',0,0),('b7b24f0bcae446223f4acf871d32e172','Agua','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'0386556dd6a8c6de15d0f344174ccf32','','Agua',0,0),('b95d2fd2a8bde2d22d260565a4c6ffe4','Otros activos','ASSET','e225033e40c0175343d198edc209bf8b',100,0,'4a4aaa1f23c7c46d2f9f2a8227242e3d','','Otros activos',0,0),('c03e1225c369541945c6f9b554f22df2','Otros gastos','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'538dd132106b1fa8ab0e6b07bb6ba900','','Otros gastos',0,0),('c90c9cba7a136973040c3b2084a7ba4e','Metálico','CASH','e225033e40c0175343d198edc209bf8b',100,0,'1cddd477b69be841b816627cc4a9ffb0','','Metálico',0,0),('cc3c58071cb2db08812f01707df2468e','Hobbies','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'538dd132106b1fa8ab0e6b07bb6ba900','','Hobbies',0,0),('cf727148ed9cb317b24e94330ea9be09','Seguro de automóvil','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'11610b53ba57ab8a8b44fc8c632ba467','','Seguro de automóvil',0,0),('d5b2b6de243a999ced4df91dc4587aef','Intereses de cuenta corriente','INCOME','e225033e40c0175343d198edc209bf8b',100,0,'a107253ce8590ae73346677eb98f1516','','Intereses de cuenta corriente',0,0),('d87b095ae355466915c10cb9cabfe215','Gastos médicos','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'538dd132106b1fa8ab0e6b07bb6ba900','','Gastos médicos',0,0),('dd2ad88637987659b6131b23ac1ff75f','Saldos de apertura','EQUITY','e225033e40c0175343d198edc209bf8b',100,0,'4cca82808a5958d2e3c2e958cc5f38ef','','',0,0),('e0e53aed312be37ecdd7268e4affeb84','Préstamos','LIABILITY','e225033e40c0175343d198edc209bf8b',100,0,'4b79781879e5607b4d8b8c208132835f','','Préstamos',0,0),('e5a91af4af59a4786c603151ae00b7cf','Automóvil','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'538dd132106b1fa8ab0e6b07bb6ba900','','Automóvil',0,0),('f0dab69b00e4fd86062b1ffc91cc5116','Cuenta de ahorros','BANK','e225033e40c0175343d198edc209bf8b',100,0,'1cddd477b69be841b816627cc4a9ffb0','','Cuenta de ahorros',0,0),('f2c3a95cb4ebd562e3c71ba6a6f4f342','Regalos recibidos','INCOME','e225033e40c0175343d198edc209bf8b',100,0,'9c939bc93e2393d7d371ef06a69696ca','','Regalos recibidos',0,0),('f8ced789db11fbe1babfc88495103814','503b80a279f11ddcf69e80137d2bfbf0','BANK','2e8aa9e087b141b0c55b66c651626e75',1,0,'6c5136161ecfce244fd54c2492b95003','','',0,0),('f9ae10e6f2b915b66761dbe70f3cbb67','Regalos','EXPENSE','e225033e40c0175343d198edc209bf8b',100,0,'538dd132106b1fa8ab0e6b07bb6ba900','','Regalos',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `billterms`
--

DROP TABLE IF EXISTS `billterms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `billterms` (
  `guid` varchar(32) NOT NULL,
  `name` varchar(2048) NOT NULL,
  `description` varchar(2048) NOT NULL,
  `refcount` int(11) NOT NULL,
  `invisible` int(11) NOT NULL,
  `parent` varchar(32) DEFAULT NULL,
  `type` varchar(2048) NOT NULL,
  `duedays` int(11) DEFAULT NULL,
  `discountdays` int(11) DEFAULT NULL,
  `discount_num` bigint(20) DEFAULT NULL,
  `discount_denom` bigint(20) DEFAULT NULL,
  `cutoff` int(11) DEFAULT NULL,
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `billterms`
--

LOCK TABLES `billterms` WRITE;
/*!40000 ALTER TABLE `billterms` DISABLE KEYS */;
/*!40000 ALTER TABLE `billterms` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `books`
--

DROP TABLE IF EXISTS `books`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `books` (
  `guid` varchar(32) NOT NULL,
  `root_account_guid` varchar(32) NOT NULL,
  `root_template_guid` varchar(32) NOT NULL,
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `books`
--

LOCK TABLES `books` WRITE;
/*!40000 ALTER TABLE `books` DISABLE KEYS */;
INSERT INTO `books` (`guid`, `root_account_guid`, `root_template_guid`) VALUES ('a33dd1728d1f3047e7600f6cbab43ab0','4cca82808a5958d2e3c2e958cc5f38ef','6c5136161ecfce244fd54c2492b95003');
/*!40000 ALTER TABLE `books` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `budget_amounts`
--

DROP TABLE IF EXISTS `budget_amounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `budget_amounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_guid` varchar(32) NOT NULL,
  `account_guid` varchar(32) NOT NULL,
  `period_num` int(11) NOT NULL,
  `amount_num` bigint(20) NOT NULL,
  `amount_denom` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `budget_amounts`
--

LOCK TABLES `budget_amounts` WRITE;
/*!40000 ALTER TABLE `budget_amounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `budget_amounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `budgets`
--

DROP TABLE IF EXISTS `budgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `budgets` (
  `guid` varchar(32) NOT NULL,
  `name` varchar(2048) NOT NULL,
  `description` varchar(2048) DEFAULT NULL,
  `num_periods` int(11) NOT NULL,
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `budgets`
--

LOCK TABLES `budgets` WRITE;
/*!40000 ALTER TABLE `budgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `budgets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `commodities`
--

DROP TABLE IF EXISTS `commodities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `commodities` (
  `guid` varchar(32) NOT NULL,
  `namespace` varchar(2048) NOT NULL,
  `mnemonic` varchar(2048) NOT NULL,
  `fullname` varchar(2048) DEFAULT NULL,
  `cusip` varchar(2048) DEFAULT NULL,
  `fraction` int(11) NOT NULL,
  `quote_flag` int(11) NOT NULL,
  `quote_source` varchar(2048) DEFAULT NULL,
  `quote_tz` varchar(2048) DEFAULT NULL,
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `commodities`
--

LOCK TABLES `commodities` WRITE;
/*!40000 ALTER TABLE `commodities` DISABLE KEYS */;
INSERT INTO `commodities` (`guid`, `namespace`, `mnemonic`, `fullname`, `cusip`, `fraction`, `quote_flag`, `quote_source`, `quote_tz`) VALUES ('2e8aa9e087b141b0c55b66c651626e75','template','template','template','template',1,0,NULL,''),('e225033e40c0175343d198edc209bf8b','CURRENCY','EUR','Euro','978',100,1,'currency','');
/*!40000 ALTER TABLE `commodities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customers` (
  `guid` varchar(32) NOT NULL,
  `name` varchar(2048) NOT NULL,
  `id` varchar(2048) NOT NULL,
  `notes` varchar(2048) NOT NULL,
  `active` int(11) NOT NULL,
  `discount_num` bigint(20) NOT NULL,
  `discount_denom` bigint(20) NOT NULL,
  `credit_num` bigint(20) NOT NULL,
  `credit_denom` bigint(20) NOT NULL,
  `currency` varchar(32) NOT NULL,
  `tax_override` int(11) NOT NULL,
  `addr_name` varchar(1024) DEFAULT NULL,
  `addr_addr1` varchar(1024) DEFAULT NULL,
  `addr_addr2` varchar(1024) DEFAULT NULL,
  `addr_addr3` varchar(1024) DEFAULT NULL,
  `addr_addr4` varchar(1024) DEFAULT NULL,
  `addr_phone` varchar(128) DEFAULT NULL,
  `addr_fax` varchar(128) DEFAULT NULL,
  `addr_email` varchar(256) DEFAULT NULL,
  `shipaddr_name` varchar(1024) DEFAULT NULL,
  `shipaddr_addr1` varchar(1024) DEFAULT NULL,
  `shipaddr_addr2` varchar(1024) DEFAULT NULL,
  `shipaddr_addr3` varchar(1024) DEFAULT NULL,
  `shipaddr_addr4` varchar(1024) DEFAULT NULL,
  `shipaddr_phone` varchar(128) DEFAULT NULL,
  `shipaddr_fax` varchar(128) DEFAULT NULL,
  `shipaddr_email` varchar(256) DEFAULT NULL,
  `terms` varchar(32) DEFAULT NULL,
  `tax_included` int(11) DEFAULT NULL,
  `taxtable` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `employees`
--

DROP TABLE IF EXISTS `employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `employees` (
  `guid` varchar(32) NOT NULL,
  `username` varchar(2048) NOT NULL,
  `id` varchar(2048) NOT NULL,
  `language` varchar(2048) NOT NULL,
  `acl` varchar(2048) NOT NULL,
  `active` int(11) NOT NULL,
  `currency` varchar(32) NOT NULL,
  `ccard_guid` varchar(32) DEFAULT NULL,
  `workday_num` bigint(20) NOT NULL,
  `workday_denom` bigint(20) NOT NULL,
  `rate_num` bigint(20) NOT NULL,
  `rate_denom` bigint(20) NOT NULL,
  `addr_name` varchar(1024) DEFAULT NULL,
  `addr_addr1` varchar(1024) DEFAULT NULL,
  `addr_addr2` varchar(1024) DEFAULT NULL,
  `addr_addr3` varchar(1024) DEFAULT NULL,
  `addr_addr4` varchar(1024) DEFAULT NULL,
  `addr_phone` varchar(128) DEFAULT NULL,
  `addr_fax` varchar(128) DEFAULT NULL,
  `addr_email` varchar(256) DEFAULT NULL,
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `employees`
--

LOCK TABLES `employees` WRITE;
/*!40000 ALTER TABLE `employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `entries`
--

DROP TABLE IF EXISTS `entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `entries` (
  `guid` varchar(32) NOT NULL,
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_entered` timestamp NULL DEFAULT '0000-00-00 00:00:00',
  `description` varchar(2048) DEFAULT NULL,
  `action` varchar(2048) DEFAULT NULL,
  `notes` varchar(2048) DEFAULT NULL,
  `quantity_num` bigint(20) DEFAULT NULL,
  `quantity_denom` bigint(20) DEFAULT NULL,
  `i_acct` varchar(32) DEFAULT NULL,
  `i_price_num` bigint(20) DEFAULT NULL,
  `i_price_denom` bigint(20) DEFAULT NULL,
  `i_discount_num` bigint(20) DEFAULT NULL,
  `i_discount_denom` bigint(20) DEFAULT NULL,
  `invoice` varchar(32) DEFAULT NULL,
  `i_disc_type` varchar(2048) DEFAULT NULL,
  `i_disc_how` varchar(2048) DEFAULT NULL,
  `i_taxable` int(11) DEFAULT NULL,
  `i_taxincluded` int(11) DEFAULT NULL,
  `i_taxtable` varchar(32) DEFAULT NULL,
  `b_acct` varchar(32) DEFAULT NULL,
  `b_price_num` bigint(20) DEFAULT NULL,
  `b_price_denom` bigint(20) DEFAULT NULL,
  `bill` varchar(32) DEFAULT NULL,
  `b_taxable` int(11) DEFAULT NULL,
  `b_taxincluded` int(11) DEFAULT NULL,
  `b_taxtable` varchar(32) DEFAULT NULL,
  `b_paytype` int(11) DEFAULT NULL,
  `billable` int(11) DEFAULT NULL,
  `billto_type` int(11) DEFAULT NULL,
  `billto_guid` varchar(32) DEFAULT NULL,
  `order_guid` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `entries`
--

LOCK TABLES `entries` WRITE;
/*!40000 ALTER TABLE `entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gnclock`
--

DROP TABLE IF EXISTS `gnclock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gnclock` (
  `Hostname` varchar(255) DEFAULT NULL,
  `PID` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gnclock`
--

LOCK TABLES `gnclock` WRITE;
/*!40000 ALTER TABLE `gnclock` DISABLE KEYS */;
INSERT INTO `gnclock` (`Hostname`, `PID`) VALUES ('SE_ES_BCN_LP008',1300);
/*!40000 ALTER TABLE `gnclock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoices` (
  `guid` varchar(32) NOT NULL,
  `id` varchar(2048) NOT NULL,
  `date_opened` timestamp NULL DEFAULT '0000-00-00 00:00:00',
  `date_posted` timestamp NULL DEFAULT '0000-00-00 00:00:00',
  `notes` varchar(2048) NOT NULL,
  `active` int(11) NOT NULL,
  `currency` varchar(32) NOT NULL,
  `owner_type` int(11) DEFAULT NULL,
  `owner_guid` varchar(32) DEFAULT NULL,
  `terms` varchar(32) DEFAULT NULL,
  `billing_id` varchar(2048) DEFAULT NULL,
  `post_txn` varchar(32) DEFAULT NULL,
  `post_lot` varchar(32) DEFAULT NULL,
  `post_acc` varchar(32) DEFAULT NULL,
  `billto_type` int(11) DEFAULT NULL,
  `billto_guid` varchar(32) DEFAULT NULL,
  `charge_amt_num` bigint(20) DEFAULT NULL,
  `charge_amt_denom` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices`
--

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `jobs` (
  `guid` varchar(32) NOT NULL,
  `id` varchar(2048) NOT NULL,
  `name` varchar(2048) NOT NULL,
  `reference` varchar(2048) NOT NULL,
  `active` int(11) NOT NULL,
  `owner_type` int(11) DEFAULT NULL,
  `owner_guid` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `lots`
--

DROP TABLE IF EXISTS `lots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `lots` (
  `guid` varchar(32) NOT NULL,
  `account_guid` varchar(32) DEFAULT NULL,
  `is_closed` int(11) NOT NULL,
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `lots`
--

LOCK TABLES `lots` WRITE;
/*!40000 ALTER TABLE `lots` DISABLE KEYS */;
/*!40000 ALTER TABLE `lots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orders` (
  `guid` varchar(32) NOT NULL,
  `id` varchar(2048) NOT NULL,
  `notes` varchar(2048) NOT NULL,
  `reference` varchar(2048) NOT NULL,
  `active` int(11) NOT NULL,
  `date_opened` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_closed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner_type` int(11) NOT NULL,
  `owner_guid` varchar(32) NOT NULL,
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `prices`
--

DROP TABLE IF EXISTS `prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `prices` (
  `guid` varchar(32) NOT NULL,
  `commodity_guid` varchar(32) NOT NULL,
  `currency_guid` varchar(32) NOT NULL,
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `source` varchar(2048) DEFAULT NULL,
  `type` varchar(2048) DEFAULT NULL,
  `value_num` bigint(20) NOT NULL,
  `value_denom` bigint(20) NOT NULL,
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `prices`
--

LOCK TABLES `prices` WRITE;
/*!40000 ALTER TABLE `prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `recurrences`
--

DROP TABLE IF EXISTS `recurrences`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `recurrences` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `obj_guid` varchar(32) NOT NULL,
  `recurrence_mult` int(11) NOT NULL,
  `recurrence_period_type` varchar(2048) NOT NULL,
  `recurrence_period_start` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `recurrences`
--

LOCK TABLES `recurrences` WRITE;
/*!40000 ALTER TABLE `recurrences` DISABLE KEYS */;
INSERT INTO `recurrences` (`id`, `obj_guid`, `recurrence_mult`, `recurrence_period_type`, `recurrence_period_start`) VALUES (4,'503b80a279f11ddcf69e80137d2bfbf0',1,'month','2012-05-01');
/*!40000 ALTER TABLE `recurrences` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `schedxactions`
--

DROP TABLE IF EXISTS `schedxactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `schedxactions` (
  `guid` varchar(32) NOT NULL,
  `name` varchar(2048) DEFAULT NULL,
  `enabled` int(11) NOT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `last_occur` date DEFAULT NULL,
  `num_occur` int(11) NOT NULL,
  `rem_occur` int(11) NOT NULL,
  `auto_create` int(11) NOT NULL,
  `auto_notify` int(11) NOT NULL,
  `adv_creation` int(11) NOT NULL,
  `adv_notify` int(11) NOT NULL,
  `instance_count` int(11) NOT NULL,
  `template_act_guid` varchar(32) NOT NULL,
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `schedxactions`
--

LOCK TABLES `schedxactions` WRITE;
/*!40000 ALTER TABLE `schedxactions` DISABLE KEYS */;
INSERT INTO `schedxactions` (`guid`, `name`, `enabled`, `start_date`, `end_date`, `last_occur`, `num_occur`, `rem_occur`, `auto_create`, `auto_notify`, `adv_creation`, `adv_notify`, `instance_count`, `template_act_guid`) VALUES ('503b80a279f11ddcf69e80137d2bfbf0','Préstamo',1,'2012-05-01','2052-04-01','2012-04-01',0,0,0,0,0,0,0,'f8ced789db11fbe1babfc88495103814');
/*!40000 ALTER TABLE `schedxactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slots`
--

DROP TABLE IF EXISTS `slots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `slots` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `obj_guid` varchar(32) NOT NULL,
  `name` varchar(4096) NOT NULL,
  `slot_type` int(11) NOT NULL,
  `int64_val` bigint(20) DEFAULT NULL,
  `string_val` varchar(4096) DEFAULT NULL,
  `double_val` double DEFAULT NULL,
  `timespec_val` timestamp NULL DEFAULT '0000-00-00 00:00:00',
  `guid_val` varchar(32) DEFAULT NULL,
  `numeric_val_num` bigint(20) DEFAULT NULL,
  `numeric_val_denom` bigint(20) DEFAULT NULL,
  `gdate_val` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `slots_guid_index` (`obj_guid`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slots`
--

LOCK TABLES `slots` WRITE;
/*!40000 ALTER TABLE `slots` DISABLE KEYS */;
INSERT INTO `slots` (`id`, `obj_guid`, `name`, `slot_type`, `int64_val`, `string_val`, `double_val`, `timespec_val`, `guid_val`, `numeric_val_num`, `numeric_val_denom`, `gdate_val`) VALUES (1,'ec531984721324be29d9d42020632916','sched-xaction',9,0,NULL,0,NULL,'88b210f22a7126da529796207dbe1c0b',0,1,NULL),(2,'88b210f22a7126da529796207dbe1c0b','sched-xaction/account',5,0,NULL,0,NULL,'f0dab69b00e4fd86062b1ffc91cc5116',0,1,NULL),(3,'88b210f22a7126da529796207dbe1c0b','sched-xaction/credit-formula',4,0,'pmt( 0,02487 / 12,00 : 480,00 : 200000,00 : 0 : 0 )',0,NULL,NULL,0,1,NULL),(4,'e27b66e8df9e793c04629c62d2d075fe','sched-xaction',9,0,NULL,0,NULL,'481ad2874b9d6858f9bf12b707a4034c',0,1,NULL),(5,'481ad2874b9d6858f9bf12b707a4034c','sched-xaction/debit-formula',4,0,'ppmt( 0,02487 / 12,00 : i : 480,00 : 200000,00 : 0 : 0 )',0,NULL,NULL,0,1,NULL),(6,'481ad2874b9d6858f9bf12b707a4034c','sched-xaction/account',5,0,NULL,0,NULL,'a645942529e7f4ed72cbc29ca789820d',0,1,NULL),(7,'ceee6726c52b98049d9e9138f6064687','sched-xaction',9,0,NULL,0,NULL,'d39c951e6d5e7c31377a4622cbc21d61',0,1,NULL),(8,'d39c951e6d5e7c31377a4622cbc21d61','sched-xaction/debit-formula',4,0,'ipmt( 0,02487 / 12,00 : i : 480,00 : 200000,00 : 0 : 0 )',0,NULL,NULL,0,1,NULL),(9,'d39c951e6d5e7c31377a4622cbc21d61','sched-xaction/account',5,0,NULL,0,NULL,'b27d604ba3d1b8e7314a0f7cd480eb8b',0,1,NULL);
/*!40000 ALTER TABLE `slots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `splits`
--

DROP TABLE IF EXISTS `splits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `splits` (
  `guid` varchar(32) NOT NULL,
  `tx_guid` varchar(32) NOT NULL,
  `account_guid` varchar(32) NOT NULL,
  `memo` varchar(2048) NOT NULL,
  `action` varchar(2048) NOT NULL,
  `reconcile_state` varchar(1) NOT NULL,
  `reconcile_date` timestamp NULL DEFAULT '0000-00-00 00:00:00',
  `value_num` bigint(20) NOT NULL,
  `value_denom` bigint(20) NOT NULL,
  `quantity_num` bigint(20) NOT NULL,
  `quantity_denom` bigint(20) NOT NULL,
  `lot_guid` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`guid`),
  KEY `splits_tx_guid_index` (`tx_guid`),
  KEY `splits_account_guid_index` (`account_guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `splits`
--

LOCK TABLES `splits` WRITE;
/*!40000 ALTER TABLE `splits` DISABLE KEYS */;
INSERT INTO `splits` (`guid`, `tx_guid`, `account_guid`, `memo`, `action`, `reconcile_state`, `reconcile_date`, `value_num`, `value_denom`, `quantity_num`, `quantity_denom`, `lot_guid`) VALUES ('061a1a6449844a8413eeb46ecd4750ed','53ce2a4d2dd83daa2fa126ab3528ad96','a645942529e7f4ed72cbc29ca789820d','','','n',NULL,-20000000,100,-20000000,100,NULL),('33334a3c73e4fd97012a23088413d158','430c277474db3f75db594840c68efaa5','17b6bc0da7aead4357520dc210967b58','','','n',NULL,20000000,100,20000000,100,NULL),('cc5cdbcb447233bd357b63dfaaf9270a','53ce2a4d2dd83daa2fa126ab3528ad96','dd2ad88637987659b6131b23ac1ff75f','','','n',NULL,20000000,100,20000000,100,NULL),('ceee6726c52b98049d9e9138f6064687','77099c50979cdee0ee34a3c917ac8321','f8ced789db11fbe1babfc88495103814','Préstamo - Interés','','n',NULL,0,100,0,1,NULL),('e27b66e8df9e793c04629c62d2d075fe','77099c50979cdee0ee34a3c917ac8321','f8ced789db11fbe1babfc88495103814','Préstamo - Principal','','n',NULL,0,100,0,1,NULL),('ec531984721324be29d9d42020632916','77099c50979cdee0ee34a3c917ac8321','f8ced789db11fbe1babfc88495103814','Préstamo - Reintegro','','n',NULL,0,100,0,1,NULL),('ef36baeefb1944cbf6feb680578e840b','430c277474db3f75db594840c68efaa5','dd2ad88637987659b6131b23ac1ff75f','','','n',NULL,-20000000,100,-20000000,100,NULL);
/*!40000 ALTER TABLE `splits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `taxtable_entries`
--

DROP TABLE IF EXISTS `taxtable_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `taxtable_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `taxtable` varchar(32) NOT NULL,
  `account` varchar(32) NOT NULL,
  `amount_num` bigint(20) NOT NULL,
  `amount_denom` bigint(20) NOT NULL,
  `type` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `taxtable_entries`
--

LOCK TABLES `taxtable_entries` WRITE;
/*!40000 ALTER TABLE `taxtable_entries` DISABLE KEYS */;
/*!40000 ALTER TABLE `taxtable_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `taxtables`
--

DROP TABLE IF EXISTS `taxtables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `taxtables` (
  `guid` varchar(32) NOT NULL,
  `name` varchar(50) NOT NULL,
  `refcount` bigint(20) NOT NULL,
  `invisible` int(11) NOT NULL,
  `parent` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `taxtables`
--

LOCK TABLES `taxtables` WRITE;
/*!40000 ALTER TABLE `taxtables` DISABLE KEYS */;
/*!40000 ALTER TABLE `taxtables` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transactions`
--

DROP TABLE IF EXISTS `transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transactions` (
  `guid` varchar(32) NOT NULL,
  `currency_guid` varchar(32) NOT NULL,
  `num` varchar(2048) NOT NULL,
  `post_date` timestamp NULL DEFAULT '0000-00-00 00:00:00',
  `enter_date` timestamp NULL DEFAULT '0000-00-00 00:00:00',
  `description` varchar(2048) DEFAULT NULL,
  PRIMARY KEY (`guid`),
  KEY `tx_post_date_index` (`post_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transactions`
--

LOCK TABLES `transactions` WRITE;
/*!40000 ALTER TABLE `transactions` DISABLE KEYS */;
INSERT INTO `transactions` (`guid`, `currency_guid`, `num`, `post_date`, `enter_date`, `description`) VALUES ('430c277474db3f75db594840c68efaa5','e225033e40c0175343d198edc209bf8b','','2012-04-26 08:21:04','2012-04-26 08:21:04','Saldo de apertura'),('53ce2a4d2dd83daa2fa126ab3528ad96','e225033e40c0175343d198edc209bf8b','','2012-04-26 08:21:04','2012-04-26 08:21:04','Saldo de apertura'),('77099c50979cdee0ee34a3c917ac8321','e225033e40c0175343d198edc209bf8b','','2012-04-26 08:23:47','2012-04-26 08:23:47','Préstamo - Reintegro');
/*!40000 ALTER TABLE `transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `vendors`
--

DROP TABLE IF EXISTS `vendors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `vendors` (
  `guid` varchar(32) NOT NULL,
  `name` varchar(2048) NOT NULL,
  `id` varchar(2048) NOT NULL,
  `notes` varchar(2048) NOT NULL,
  `currency` varchar(32) NOT NULL,
  `active` int(11) NOT NULL,
  `tax_override` int(11) NOT NULL,
  `addr_name` varchar(1024) DEFAULT NULL,
  `addr_addr1` varchar(1024) DEFAULT NULL,
  `addr_addr2` varchar(1024) DEFAULT NULL,
  `addr_addr3` varchar(1024) DEFAULT NULL,
  `addr_addr4` varchar(1024) DEFAULT NULL,
  `addr_phone` varchar(128) DEFAULT NULL,
  `addr_fax` varchar(128) DEFAULT NULL,
  `addr_email` varchar(256) DEFAULT NULL,
  `terms` varchar(32) DEFAULT NULL,
  `tax_inc` varchar(2048) DEFAULT NULL,
  `tax_table` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `vendors`
--

LOCK TABLES `vendors` WRITE;
/*!40000 ALTER TABLE `vendors` DISABLE KEYS */;
/*!40000 ALTER TABLE `vendors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `versions`
--

DROP TABLE IF EXISTS `versions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `versions` (
  `table_name` varchar(50) NOT NULL,
  `table_version` int(11) NOT NULL,
  PRIMARY KEY (`table_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `versions`
--

LOCK TABLES `versions` WRITE;
/*!40000 ALTER TABLE `versions` DISABLE KEYS */;
INSERT INTO `versions` (`table_name`, `table_version`) VALUES ('accounts',1),('billterms',2),('books',1),('budgets',1),('budget_amounts',1),('commodities',1),('customers',2),('employees',2),('entries',3),('Gnucash',2041000),('Gnucash-Resave',19920),('invoices',3),('jobs',1),('lots',2),('orders',1),('prices',2),('recurrences',1),('schedxactions',1),('slots',3),('splits',4),('taxtables',2),('taxtable_entries',3),('transactions',3),('vendors',1);
/*!40000 ALTER TABLE `versions` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2012-04-26 12:29:42
