--------------------------------------------------------------------------------
-- design_utilities_pkg_body.vhdl
--------------------------------------------------------------------------------
--! \file design_utilities_pkg_body.vhdl
--! \brief Implementation of the design_utilities_pkg package.
--!
--! \class _design_utilities_pkg
--! \brief Package defining some useful functions for use
--! when implementing modules for synthesis.
--! \ingroup my_design_lib
--!
--------------------------------------------------------------------------------
-- $Revision: 23$
--------------------------------------------------------------------------------

library ieee;
use     ieee.std_logic_1164.all;
use     ieee.numeric_std.all;

package body design_utilities_pkg is


    ----------------------------------------------------------------------------
    --! \brief Function to AND all bits in a std_logic_vector signal or variable.
    --! \param [in] S - std_logic_vector signal or variable.
    --! \result Logical AND of all bits in S.
    ----------------------------------------------------------------------------
    function COMBINE_AND (S : std_logic_vector) return std_logic is
        variable RESULT : std_logic;
    begin
        RESULT := '1';
        for k in S'low to S'high loop
            RESULT := RESULT and S (k);
        end loop;
        return RESULT;
    end;


end design_utilities_pkg;


--------------------------------------------------------------------------------
-- End of file design_utilities_pkg_body.vhdl
--------------------------------------------------------------------------------
