#include "event_propagation.h"


EventPropagation::EventPropagation()
{
  add(m_container);
  set_title("Event Propagation");
  set_border_width(10);


  m_label.set_label("A label");

  m_canPropagate.set_label("Can Propagate");
  m_canPropagate.set_active(true);


    // Main Container

  m_container.set_orientation(Gtk::ORIENTATION_VERTICAL);

  m_container.add(m_label);
  m_container.add(m_entry);
  m_container.add(m_canPropagate);


    // Events

  add_events(Gdk::KEY_RELEASE_MASK);


  m_entry.signal_key_release_event().connect(sigc::mem_fun(*this,
                                         &EventPropagation::entryKeyRelease));

  m_container.signal_key_release_event().connect(sigc::mem_fun(*this,
                                         &EventPropagation::gridKeyRelease));


    // is called before the default signal handler (what we're overriding in this example)
  signal_key_release_event().connect(sigc::mem_fun(*this,
                                         &EventPropagation::windowBefore), false);

    // is called after
  signal_key_release_event().connect(sigc::mem_fun(*this,
                                         &EventPropagation::windowKeyRelease));

  show_all_children();
}




/*
    By changing the return value, we allow or not the event to propagate to other elements
 */

bool EventPropagation::entryKeyRelease(GdkEventKey* /* event */ )
{
  std::cout << "Entry" << std::endl;

  if (m_canPropagate.get_active() == true)
  {
    return false;
  }

  return true;
}




bool EventPropagation::gridKeyRelease(GdkEventKey* /* event */ )
{
  std::cout << "Grid" << std::endl;

    //let it propagate
  return false;
}



bool EventPropagation::on_key_release_event(GdkEventKey *event)
{
  std::cout << "Window overridden" << std::endl;

    // call base class function (to get the normal behaviour)
  return Gtk::Window::on_key_release_event(event);
}



/*
    This will set the entry's text in the label, everytime a key is pressed
 */

bool EventPropagation::windowKeyRelease(GdkEventKey* /* event */ )
{
  std::cout << "Window" << std::endl;

      //checking if the entry is on focus, otherwise the label would get changed by pressing keys
      //on the window (when the entry is not on focus), even if canPropagate wasn't active
  if (m_entry.has_focus() == true)
  {
    m_label.set_text(m_entry.get_text());
  }


  return true;
}



bool EventPropagation::windowBefore(GdkEventKey* /* event */)
{
  std::cout << "Window before" << std::endl;

  return false;
}




EventPropagation::~EventPropagation()
{
}

