/*
 * Copyright (C) 2008 Ole Andr Vadla Ravns <ole.andre.ravnas@tandberg.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GST_TEST_CLOCK_H__
#define __GST_TEST_CLOCK_H__

#include <gst/gst.h>

#define GST_TYPE_TEST_CLOCK (gst_test_clock_get_type ())
#define GST_TEST_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
    GST_TYPE_TEST_CLOCK, GstTestClock))
#define GST_TEST_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
    GST_TYPE_TEST_CLOCK, GstTestClockClass))
#define GST_IS_TEST_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
    GST_TYPE_TEST_CLOCK))
#define GST_IS_TEST_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE (\
    (klass), GST_TYPE_TEST_CLOCK))
#define GST_TEST_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS (\
    (obj), GST_TYPE_TEST_CLOCK, GstTestClockClass))

typedef struct _GstTestClock GstTestClock;
typedef struct _GstTestClockClass GstTestClockClass;

typedef struct _GstTestClockPrivate GstTestClockPrivate;

typedef struct _GstTestClockPendingID GstTestClockPendingID;

struct _GstTestClock
{
  GstClock parent;

  GstTestClockPrivate * priv;
};

struct _GstTestClockClass
{
  GstClockClass parent_class;
};

struct _GstTestClockPendingID
{
  GstClockID clock_id;
  GstClockEntryType type;
  GstClockTime time;
};

G_BEGIN_DECLS

GType gst_test_clock_get_type (void) G_GNUC_CONST;

GstClock * gst_test_clock_new (void);
GstClock * gst_test_clock_new_with_start_time (GstClockTime start_time);

void gst_test_clock_set_time (GstTestClock * self, GstClockTime new_time);
void gst_test_clock_advance_time (GstTestClock * self, GstClockTimeDiff delta);

guint gst_test_clock_peek_id_count (GstTestClock * self);
gboolean gst_test_clock_has_id (GstTestClock * self, GstClockID id);
gboolean gst_test_clock_peek_next_pending_id (GstTestClock * self,
    GstTestClockPendingID * pending_id);
gboolean gst_test_clock_wait_for_next_pending_id (GstTestClock * self,
    GstTestClockPendingID * pending_id);

GstClockID gst_test_clock_process_next_clock_id (GstTestClock * self);
GstClockTime gst_test_clock_get_next_entry_time (GstTestClock * self);

G_END_DECLS

#endif
