/*
 * TWAIN Plug-in
 * Copyright (C) 1999 Craig Setera
 * Craig Setera <setera@home.com>
 * 03/31/1999
 *
 * Updated for Mac OS X support
 * Brion Vibber <brion@pobox.com>
 * 07/22/2004
 *
 * Added for Win x64 support, changed data source selection.
 * Jens M. Plonka <jens.plonka@gmx.de>
 * 11/25/2011
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * Based on (at least) the following plug-ins:
 * Screenshot
 * GIF
 * Randomize
 *
 * Any suggestions, bug-reports or patches are welcome.
 *
 * This plug-in interfaces to the TWAIN support library in order
 * to capture images from TWAIN devices directly into GIMP images.
 * The plug-in is capable of acquiring the following type of
 * images:
 * - B/W (1 bit images translated to grayscale B/W)
 * - Grayscale up to 16 bits per pixel
 * - RGB up to 16 bits per sample (24, 30, 36, etc.)
 * - Paletted images (both Gray and RGB)
 *
 * Prerequisites:
 * Should compile and run on both Win32 and Mac OS X 10.3 (possibly
 * also on 10.2).
 *
 * Known problems:
 * - Multiple image transfers will hang the plug-in.  The current
 *   configuration compiles with a maximum of single image transfers.
 * - On Mac OS X, canceling doesn't always close things out fully.
 * - Epson TWAIN driver on Mac OS X crashes the plugin when scanning.
 */

/*
 * Revision history
 *  (02/07/99)  v0.1   First working version (internal)
 *  (02/09/99)  v0.2   First release to anyone other than myself
 *  (02/15/99)  v0.3   Added image dump and read support for debugging
 *  (03/31/99)  v0.5   Added support for multi-byte samples and paletted
 *                     images.
 *  (07/23/04)  v0.6   Added Mac OS X support.
 *  (11/25/11)  v0.7   Added Win x64 support, changed data source selection.
 */

#include "config.h"

#include <glib.h>   /* Needed when compiling with gcc */

#include <glib/gstdio.h>

#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "tw_platform.h"
#include "tw_util.h"

char *fileName = NULL;
FILE *logFile = NULL;

/*
 * log_message
 */
void
log_message (char *format, ...)
{
  va_list args;
  time_t time_of_day;
  char *ctime_string;

  /* Check if user want's to have a log file. */
  if (getenv(GIMP_LOG_TWAIN) == NULL)
  {
    va_start (args, format);
    g_message (format, args);
    va_end (args);
    return;
  }

  if (fileName == NULL)
  {
    fileName = g_new (char, 255);
    strcpy (fileName, getenv (TEMP));
    strcat (fileName, SEP_CHAR);
    strcat (fileName, LOG_FILE);
  }

  /* Open the log file if necessary */
  logFile = g_fopen(fileName, (logFile == NULL) ? "w" : "a");

  time_of_day = time (NULL);
  ctime_string = ctime (&time_of_day);
  ctime_string[19] = '\0';

  fprintf(logFile, "[%s] ", (ctime_string + 11));

  va_start (args, format);
  vfprintf (logFile, format, args);
  va_end (args);

  fflush (logFile);
  fclose (logFile);
}
