#include "eventPropagation.h"
#include <iostream>


EventPropagation::EventPropagation()
{
  label.set_label( "A label" );

  canPropagate.set_label( "Can Propagate" );

  canPropagate.set_active( true );


      // :: Main Container :: //

  container.set_orientation( Gtk::ORIENTATION_VERTICAL );

  container.add( label );
  container.add( entry );
  container.add( canPropagate );


      // :: Window :: //

  this->add( container );

  this->set_title( "Event Propagation" );

  this->set_border_width( 10 );

  this->show_all_children();


      // :: Events :: //

  this->add_events( Gdk::KEY_RELEASE_MASK );


  entry.signal_key_release_event().connect( sigc::mem_fun( *this, &EventPropagation::entryKeyPress ) );

  container.signal_key_release_event().connect( sigc::mem_fun( *this, &EventPropagation::gridKeyPress ) );

  this->signal_key_release_event().connect( sigc::mem_fun( *this, &EventPropagation::windowKeyPress ) );
}




/*
    By changing the return value, we allow or not the event to propagate to other elements
 */

bool EventPropagation::entryKeyPress( GdkEventKey *event )
{
  std::cout << "Entry" << std::endl;

  if ( canPropagate.get_active() == true )
  {
    return false;
  }

  return true;
}




bool EventPropagation::gridKeyPress( GdkEventKey *event )
{
  std::cout << "Grid" << std::endl;

    //let it propagate
  return false;
}




/*
    This will set the entry's text in the label, everytime a key is pressed
 */

bool EventPropagation::windowKeyPress( GdkEventKey *event )
{
  std::cout << "Window" << std::endl;

      //checking if the entry is on focus, otherwise the label would get changed by pressing keys
      //on the window (when the entry is not on focus), even if canPropagate wasn't active
  if ( entry.has_focus() == true )
  {
    label.set_text( entry.get_text() );
  }


  return true;
}


