package com.facilita.fc.web;

import com.facilita.exception.BadValueException;
/** 
 * Protocol that are defined
 *
 *
 */

public enum Protocol {
	
	HTTP(80),/**< HTTP Protocol */
	HTTPS(443),/**< HTTPS Protocol */	
	FILE(-1) /**< File Protocol */
	;

	Protocol(int port)
	{
		this._port = port;
	}
	/**
	 * get the standard IP port used by this Protocol
	 * @return
	 */
	public int port()
	{
		return _port;
	}
	/**
	 * find a Protocol
	 * @param aName the name of the Protocol tobe found
	 * @return a Protocol object
	 * @exception throws BadValueException if no Protocol found with name aName.
	 */
	public static Protocol find(String aName) throws BadValueException
	{
		if (aName == HTTP.name())
		{
			return HTTP;
		}
		else if (aName == HTTPS.name())
		{
			return HTTPS;
		}
		else if (aName == FILE.name())
		{
			return FILE;
		}
		throw new BadValueException("Http Protocol " + aName + " not known");
	}

	private int _port;
}
