#ifndef SAMPLEHEADERFILE1_MULTIGROUPS_C_H_
#define SAMPLEHEADERFILE1_MULTIGROUPS_C_H_

/**
@file SampleHeaderFile1_multigroups_C.h
 
First sample header file with Doxygen markup examples.

This file includes sample code needed to generate a sample PDF
document developed with standard C files, which include multiple
groups. This file is also used for training and provides the
examples shown in the QCT Doxygen Markup Standards (80-VP989-1).
*/
/*-------------------------------------------------------------------------------
     Copyright (c) 2010 QUALCOMM Incorporated.
	 All rights reserved.
	 Qualcomm Confidential and Proprietary
-----------------------------------------------------------------------------*/
/*=============================================================================
                             Edit History
$Header: //depot/Living_Documents/Training/Current_Doxygen_Standards/
           DoxygenMarkupStandards/SampleHeaderFile1_multigroups_C.h $

when       who     what, where, why
--------   ---     ------------------------------------------------------------
09/22/10   LB     Updated to reflect Rev C standards.
06/07/10   LB     Corrected param name in CreateInstance and FancyInterfere
                  functions from 'IEnv' to 'pEnvironment'. Added \n following
                  'SUCCESS' return for CreateInstance and removed hyphens
                  for each return.
05/26/10   LB     Updated from LD CCB review to create final for Rev B.
05/18/10   LB     Updated to include Module grouping samples and other 
                  advanced Doxygen markup examples for the Rev B Doxygen
                  Markup Standards
01/14/10   LB     Fixed the corrupted file and regenerated PDF.
01/13/10   LB     Initial revision for Rev A Doxygen Markup Standards.
===============================================================================*/

#include <stdio.h>
#include <cstdio>

#pragma diag_suppress 494

#pragma message( "FancyMessage (" #_FANCY_DATA_PROFILE_VERSION \
                 "): Depends_on_target" )

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  BEGIN EXAMPLE: #ifdef macros used for conditional cases
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

/** @addtogroup fancy_device_common_data
@{ */
/** @name
@{ */
#if defined(FANCY_DATA_TARGET1)
#define  FANCY_DATA_PROFILE_VERSION   7  
    /**< Profile version for Fancy Data Target 1. 
    The value of the Fancy Device target's profile version depends on the following 
    conditional settings:
    - If FANCY_DATA_TARGET1 is TRUE, FANCY_DATA_PROFILE_VERSION = 7.
    - If FANCY_DATA_TARGET2 is TRUE, FANCY_DATA_PROFILE_VERSION = 9.
    - If FANCY_DATA_TARGET3 is TRUE, FANCY_DATA_PROFILE_VERSION = 12.
    - If none of the above conditions are TRUE, FANCY_DEFAULT_DATA_PROFILE_VERSION = 3.*/
#elif defined(FANCY_DATA_TARGET2)
#define  FANCY_DATA_PROFILE_VERSION   9
    /**< Profile version for Fancy Data Target 2. 
    The value of the Fancy Device target's profile version depends on the following 
    conditional settings:
    - If FANCY_DATA_TARGET1 is TRUE, FANCY_DATA_PROFILE_VERSION = 7.
    - If FANCY_DATA_TARGET2 is TRUE, FANCY_DATA_PROFILE_VERSION = 9.
    - If FANCY_DATA_TARGET3 is TRUE, FANCY_DATA_PROFILE_VERSION = 12.
    - If none of the above conditions are TRUE, FANCY_DEFAULT_DATA_PROFILE_VERSION = 3.*/
#elif defined(FANCY_DATA_TARGET3)
#define  FANCY_DATA_PROFILE_VERSION  12
    /**< Profile version for Fancy Data Target 3. 
    The value of the Fancy Device target's profile version depends on the following 
    conditional settings:
    - If FANCY_DATA_TARGET1 is TRUE, FANCY_DATA_PROFILE_VERSION = 7.
    - If FANCY_DATA_TARGET2 is TRUE, FANCY_DATA_PROFILE_VERSION = 9.
    - If FANCY_DATA_TARGET3 is TRUE, FANCY_DATA_PROFILE_VERSION = 12.
    - If none of the above conditions are TRUE, FANCY_DEFAULT_DATA_PROFILE_VERSION = 3.*/
#else
#define  FANCY_DEFAULT_DATA_PROFILE_VERSION   3 
    /**< Default profile version. 
    The value of the Fancy Device target's profile version depends on the following 
    conditional settings:
    - If FANCY_DATA_TARGET1 is TRUE, FANCY_DATA_PROFILE_VERSION = 7.
    - If FANCY_DATA_TARGET2 is TRUE, FANCY_DATA_PROFILE_VERSION = 9.
    - If FANCY_DATA_TARGET3 is TRUE, FANCY_DATA_PROFILE_VERSION = 12.
    - If none of the above conditions are TRUE, FANCY_DEFAULT_DATA_PROFILE_VERSION = 3.*/
#endif

typedef struct fancy_handle  fancy_handle;
typedef fancy_handle         *fancy_handle_t;

/** @} */ /* end_name */
/** @} */ /* end_addtogroup fancy_device_common_data */

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  END EXAMPLE: #ifdef macros used for conditional cases
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  START fancy_device_apis group level 1
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

/** @addtogroup first_fancy_device_api
@{ */

/* ========================BEGIN SAMPLE DATA STRUCTURES=============================*/

/**
  Sample 1 simple struct with two members. If the brief description requires 
  more than one sentence, it must follow the first sentence with no carriage return. If 
  there is more information provided (more than one paragraph) for this struct, Doxygen 
  will include with the struct's brief description, the word "more..." as a link to the 
  additional information in the paragraph for the struct. This is an example of how to
  use a superscripted asterisk<sup>*</sup> in Doxygen markup.

  The detailed description of the struct will be included as a lead-in paragraph to the
  struct's Data Fields unnumbered heading. This detailed description must be separated 
  from the brief description for Doxygen to place this paragraph with the struct in the 
  body of the document as shown in this example.

  If a second paragraph for the detailed description is required, it must be separated
  from the first paragraph with a carriage return as shown here.
*/
struct sample1_simple_struct_s {

    uint8                        length;
      /**< Sample 1 simple struct member 1. */

    uint8                        ccp[SS_MAX_LEN];
      /**< Sample 1 simple struct member 2. */
};

/**  
  Sample 2 struct (parent struct) with a struct member (child struct).

  The brief description (in the first paragraph) and the detailed description of the struct 
  will be included as a lead-in paragraph to the struct's Data Fields unnumbered heading. 
  This detailed description must be separated from the brief description for Doxygen to place 
  this paragraph with the struct in the body of the document as shown in this example.

  @note Notice that the placement of the comment for the child struct must be inside the
  parent struct's closing brace to properly appear in the PDF (Need to add this change to
  the Rev D list). Also note that the child_struct_member info is not included in the PDF 
  under the parent struct info, but appears later in the PDF on page 22. Dimitri is fixing 
  this as part of SOW task 2a.
*/
struct sample2_parent_struct_with_members_child_struct_as_member
{
  int x;  /**< Integer x in parent struct. */
  int y;  /**< Integer y in parent struct. */
  struct child_struct_member
  {
    int x1;  /**< Integer x1 in child struct. */
    int y1;  /**< Integer y1 in child struct. */
  } /** Sample 2 child struct member. */ s;   
};

/**  
  Sample 3 struct with a different construction, which includes a struct 
  member with two members. In this example, the second usage of the struct name denotes
  that a variable of the same name will be created.
*/
struct sample3_struct_with_two_members_and_declared_as_variable
{
/**  Sample 3 struct with two struct members and struct declared as variable. 
*/
  struct StructChildMember StructChildMember;
  SResult (* FCN_0) ( uint32 leb_idx, SDeviceHandle *h, uint32 u1 ); /**< Sample 3 struct member 1. */
  SResult (* FCN_1) ( uint32 leb_idx, SDeviceHandle *h, uint32 u1, uint32 u2 ); /**< Sample 3 struct member 2. */
};

/**  Sample 4 struct with a typedef struct member.
*/
struct sample4_struct_with_typedef_struct_member
{
  typedef struct sample4_typedef_member_type sample4_typedef_member; /**< Sample 4 struct member 1. */
  int a; /**< Sample 4 struct member 2. */
  int b; /**< Sample 4 struct member 3. */
};

/**  
  Sample 5 struct with a define member. Note that in order to include the
  information for the define member, one must use the @relates command as shown below. 
  Also note that Doxygen will list the @relate items first under separate section entitled
  "Friends And Related Function Documentation". A [related] tag is also placed next to
  its title.
*/
struct sample5_struct_with_define_member
{
  int a; /**< Sample 5 struct member 1. */
  int b; /**< Sample 5 struct member 2. */
  #define SAMPLE_DEFINE_INSIDE_A_STRUCT 0xFF /**< Sample 5 struct member 3. 
                                             @relates sample5_struct_with_define_member*/
  uint8_t number; /**< Sample 5 struct member 4. */
};

/**  
  Sample 6 struct. Interface descriptor structure. 
*/
typedef struct {
    if_control_msg_fn control_msg; /**< Sample 6 struct member 1. */

    alt_interface_desc_t *alt_ifs; /**< Sample 6 struct member 2. */
    juint8_t     alt_if_num;       /**< Sample 6 struct member 3. */
    juint8_t     alt_if_curr;      /**< Sample 6 struct member 4. */

    juint8_t     *extra_descriptor;
         /**< Sample 6 struct member 5. */

    juint32_t    extra_descriptor_size;
         /**< Sample 6 struct member 6. */

    #define UWD_UNDEFINED_INTERFACE 0xFF /**< Sample 6 struct member 7 with value 
                                          (0xFF). @relates sample6_interface_desc_t */
    juint8_t     number;       /**< Sample 6 struct member 8. */

    juint8_t     if_class;     /**< Sample 6 struct member 9. */           
    juint8_t     if_subclass;  /**< Sample 6 struct member 10. */
    juint8_t     if_protocol;  /**< Sample 6 struct member 11. */

    juint8_t     if_string;    /**< Sample 6 struct member 12. */
} sample6_interface_desc_t;

/**
 Sample 7 struct with verbatim comment block.
*/
struct sample7_struct_with_verbatim_comment_t
{
  uint32_t* buffer;  
  /**< Sample 7 struct member 1.
  @keep{14}
  @verbatim
  <----- 32 bits ----->
   -------------------
  | vsc vs handle 1   |   
   -------------------
  | vsc vs handle 2   |   
   -------------------    
   -------------------
  | vsc vs handle 3   |   
   -------------------
   -------------------
  | vsc vs handle 4   |   
   -------------------
  | .                 .
    .                 . 
  @endverbatim
  */
  uint32_t buffer_size;
    /**< Sample 7 struct member 2. */
  const uint8_t* pbuf;
    /**< Sample 7 struct member 3. */
  uint32_t* ret_total_size;
    /**< Sample 7 struct member 4. */
};

/**
  Sample 8 struct with a union member that has members. Note that the
  comment for the union does not show up in PDF. Dimitri fixing as part of SOW task.
  Also note that when a data structure (struct, typedef, union, class) are used as
  members, do not include the brief command in their comment - need to add this
  change to the Rev D list.
*/
struct sample8_struct_with_union_member_t
{
  uint32_t  open_id;
    /**< Sample 8 struct member 1:\n
         - #SWU_VS_OPENID 
         - #SWU_VS_CLOSEID   */
  char* Data;          /**< Sample 8 struct member 2. */
    
  union {
    swu_vs_open_full_control_t    full_control;    
      /**< Sample 8 struct union member 1. This allows data to be  
           exchanged across SWU controls. */
    swu_vs_open_passive_control_t passive_control;
      /**< Sample 8 struct union member 2. This allows data to be 
           exchanged to manage SWU passive controls. */
  } /** Sample8 union with members inside a struct.  */ u;
};

/**
 Sample 9 struct with a union member that has a struct member.
*/
struct sample9_struct_sus_ad_pp_eq 
{
    uint32_t param_id;    /**< Sample 9 struct member 1. */

	union 
	{  
      struct sus_aud_pp_eq_enable enable;	/**< Sample 9 struct union member 1. */
	}/** Sample 9 struct member 2. */u;
};

/** 
 
  Sample 10 typedef struct with member with a bulleted list in comment. In this example,
  the uProfilingLevel name is inside a LaTeX label command to create a hyperlink. Note that
  in this type of comment, a backslash n should be used prior to the bulleted list.
*/
typedef struct
{
    uint32_t              one_level;  
      /**< First level: @latexonly \label{uProfilingLevel} @endlatexonly \n   
           - 0 -- Comment for first item in bulleted list. 
           - 1 -- Comment for second item in bulleted list.
           - 2 -- Comment for third item in bulleted list. */    
} sample10_typedef_struct_with_member_with_bulleted_list;

/** 
  Sample 11 typedef struct with a struct member that has an enum and a union member. 
  Note that the comment for struct member 3 (enum) and struct member 4 (union) do not
  show up in PDF under this typedef struct as it should. In fact, they don't show up
  anywhere in the PDF. Dimitri fixing as part of SOW task 2f.
*/
  typedef struct _sample11_struct_sample_gtx_t
  {
    void *main_gtx;            /**< Sample 11 typedef struct member 1. */
    gtx_appgtx_t app_gtx;      /**< Sample 11 typedef struct member 2. */
    
    struct
    {
      enum
      {
        GTX_READY=0,
        GTX_RESP_SENDING,
        GTX_RESP_SENT
      } /** Sample 11 typedef struct member 3 with enum. */ state;
        
        lbool_t not_pending;
        lbool_t sending_zldp;
        
        void *buffer;
        lbint32_t size;
        lbint32_t bytes_sent;
    } sample11_typedefstruct_encap_response;

    union
    {
      gtx_calling_t basic;
      led_calling_t acm;
      leb_calling_t ecm;
      gex_calling_t obex;
    }  /** Sample 11 typedef struct union member 4. */ sample11_union_gtx;
    
} sample11_typedefstruct_sample_gtx_t;

/**  
  Sample 12 typedef struct with a function. Note that the comment for the struct 
  member does not show up in PDF under this typedef struct as it should. Instead, it
  shows up under the Variable Documentation section in the PDF on page 23. Dimitri 
  fixing as part of SOW task 2a.
*/
typedef struct
{
    /** Sample 12 function in a typedef struct.
	@param[in]     _pif            Pointer to the library object.
    @param[in,out] info_ptr        Initialization information.
     
    @return
    Indication of success or failure.

    @dependencies
    The gex_getsize_f() and gex_init_f() functions must have been executed, and 
    memory must have been allocated.

    @comments
    Sample comment 1. \n
    Sample comment 2. \n
    Sample comment 3. This sample comment is intended to be very long so that it
                      wrap the second sentence all the way to the next line.

    @errors
    Sample error 1. \n
    Sample error 2. \n
    Sample error 3. This sample error is intended to be very long so that it
                    wrap the second sentence all the way to the next line.

    @description
    Sample description that is very very long so that it will wrap onto the next
    line.

    @important \n
    Sample important statement 1. \n
    Sample important statement 2. This statement is very long so that it will wrap 
                                  onto the next line. \n
    Sample important statement 3. This statement includes a bulleted list:
                                  - List item 1. \n
                                  - List item 2. \n
                                  - List item 3 which includes another list:
                                    -# Sublist item 1. \n
                                    -# Sublist item 2.  
  */
   sample12_GEXResult (*reinit)(gex_t* _pif,
     const gex_format_t* in_format_ptr,
           gex_format_t* out_format_ptr,
           gex_buf_t* info_ptr);
} sample12_typedefstruct;

/** 
  Sample 13 typedef packed struct with members and struct members. This is an example of 
  a typedef packed struct with three members and two child struct members. 
*/
typedef PACKED struct PACKED_POST
{
  boolean   valid_flg;            /**< Sample 13 typedef struct member 1. */
  uint32    precedence;           /**< Sample 13 typedef struct member 2. */
  uint32    mean;                 /**< Sample 1e typedef struct member 3. */

  struct {
    lb_arcid_T            arcid;
      /**< Sample 13 typedef struct member 4. */

  } sample13_typedefstruct_arc_reestab_reestab_params; 

  struct {
    lb_nonarc_id_T         lb_nonarc_id;
      /**< Sample 13 typedef struct member 5. */

  } sample13_struct_typedefstruct_nonarc_reestab_params; 

} sample13_typedef_packed_struct_type;

/**  Sample 14 simple union for a C function. 
*/
union sample14_simple_union_msg_type 
{
  uint32 dummy;            /**< Sample 14 union member. */
};

/** 
  Sample 15 typedef union with two members. 

  This is the detailed description for this typedef union. 
*/
typedef union sample15_typedef_union_u 
{
  sample15_union_member1_params_s_type           lb_cs_end;
  /**< Sample 15 union member 1. */
  sample15_union_member2_params_s_type           lb_ps_end;
  /**< Sample 15 union member 2. */
};

/**  Sample 16 union with two struct members. 
*/
union sample16_union_with_struct_members_u {
  struct 
  {
    sample16_timer_id_T         lb_timer_id;
      /**< Sample 16 struct member 1. */
  }sample16_struct_member1;

  struct 
  {
    sample16_utimer_id_T         lb_utimer_id;
      /**< Sample 16 struct member 2. */
  }sample16_struct_member2;
};

/**
  This a very complex sample typedef struct, which includes one enum type
  parameter, two union members and one struct member. Each union member includes 
  two levels of nested struct members.
*/
typedef struct
{
  sample17_enum_type_param  np_vsn; /**< Sample 17 enum type parameter. */

  /** Sample 17 union member 1 of typedef struct. */
  union
  {
    /** This comment doesn't show up unless I put it at the end. */
    struct
    {
      npfltr_np4_hdr_field_mask_type      field_mask;  /**< In mask. */
      npfltr_np4_hdr_field_mask_type      err_mask;    /**< Out mask. */

      struct
      {
        struct ps_in_addr  addr;        /**< Sample 17 subnested struct member 1 of
                                             struct member 1 of union member 1. */
        struct ps_in_addr  subnet_mask; /**< Sample 17 subnested struct member 2 of
                                             struct member 2 of union member 1. */
      } nested_struct_member1_of_struct1_of_union_member1 /**Comment for nested struct 1 shows up, but adds
                                                          an odd character 17@ in the heading. */;

      struct
      {
        struct ps_in_addr  addr;        /**< Sample 17 subnested struct member 1 of
                                             struct member 2 of union member 1. */
        struct ps_in_addr  subnet_mask; /**< Sample 17 subnested struct member 2 of
                                             struct member 2 of union member 1. */
      } nested_struct_member2_of_struct1_of_union_member1;
      
      struct
      {
        uint8 val;  /**< A value. */
        uint8 mask; /**< A mask. */
      } nested_struct_member3_of_struct1_of_union_member1;      
      
    } sample17_struct_member1_of_union_member1 /** Comment shows up if I put it here. */; 

    struct
    {
      npfltr_np6_hdr_field_mask_type      field_mask;  /**< In mask. */
      npfltr_np6_hdr_field_mask_type      err_mask;    /**< Out mask. */

      struct
      {
        struct ps_in6_addr  addr;       
        uint8               prefix_len; /**< Length of the prefix. */
      } sample17_nested_struct_member1_of_struct2_of_union_member1;
      
      struct
      {
        struct ps_in6_addr addr;       
        uint8              prefix_len; /**< Length of the prefix. */
      } sample17_nested_struct_member2_of_struct2_of_union_member1;
      
      struct
      {
        uint8   val;  /**< Traffic class value. */
        uint8   mask; /**< Traffic class mask. */
      } sample17_nested_struct_member3_of_struct2_of_union_member1;
      
      uint32   flow_label;     /**< Flow label. */
      uint8    next_hdr_prot;  /**< Transport-level protocol header. */
    } sample17_struct_member2_of_union_member1; 
  } sample17_union_member1 ; /* end sample 17 union member 1 of typedef struct. */

  /** Sample 17 union member 2 of typedef struct. */
  union
  {
    struct
    {
      npfltr_tcp_hdr_field_mask_type      field_mask;  /**< In mask.   */
      npfltr_tcp_hdr_field_mask_type      err_mask;    /**< Out mask.  */

      struct
      {
        uint16    port;  /**< NP2 source port. */
        uint16    range; /**< Range of the NP2 source port. */
      } sample17_nested_struct_member1_of_struct1_of_union_member2;
    
      struct
      {
        uint16    port;  /**< NP3 destination port. */
        uint16    range; /**< Range of the NP3 destination port. */
      } sample17_nested_struct_member2_of_struct1_of_union_member2;    
    } sample17_struct_member1_of_union_member2;
    
    struct
    {
      npfltr_udp_hdr_field_mask_type      field_mask;  /**< In mask. */
      npfltr_udp_hdr_field_mask_type      err_mask;    /**< Out mask. */

      struct
      {
        uint16    port;  /**< NP4 source port. */
        uint16	  range; /**< Range of the NP4 source port. */
      } sample17_nested_struct_member1_of_struct_member2_of_union_member2;
      
      struct
      {
        uint16    port;  /**< NP4 destination port. */
        uint16    range; /**< Range of the UDP destination port. */
      } sample17_nested_struct_member2_of_struct_member2_of_union_member2;
    } sample17_struct_member2_of_union_member2;
    
    struct
    {    
      npfltr_icmp_hdr_field_mask_type     field_mask; /**< In mask. */
      npfltr_icmp_hdr_field_mask_type     err_mask;   /**< Out mask. */

      uint8   type; /**< NP5 type. */
      uint8   code; /**< NP5 code. */
    } sample17_struct_member3_of_union_member2;
  
    struct
    {
      npfltr_esp_hdr_field_mask_type     field_mask; /**< In mask. */
      npfltr_esp_hdr_field_mask_type     err_mask;   /**< Out mask. */

      uint32  spi; /**< Secure index. */
    } sample17_struct_member4_of_union_member2;

    struct
    {
      npfltr_tcp_udp_hdr_field_mask_type      field_mask;  /**< In mask. */
      npfltr_tcp_udp_hdr_field_mask_type      err_mask;    /**< Out mask. */
  
      struct
      {
        uint16    port;  /**< Source port. */
        uint16    range; /**< Range of the source port. */
      } sample17_nested_struct_member1_of_struct_member5_of_union_member2;
  
      struct
      {
        uint16    port;  /**< Destination port. */
        uint16    range; /**< Range of the destination port. */
      } sample17_nested_struct_member2_of_struct_member5_of_union_member2; 

    } sample17_struct_member5_of_union_member2;
  } sample17_union_member2; /* end sample 17 union member 2 of typedef struct. */

  /** Sample 17 struct member 1 of typedef struct. */
  struct
  { 
    uint16 fi_id;          /**< Filter ID. */
    uint16 fi_precedence;  /**< Filter precedence. */
  } sample17_struct_member1_of_typedef_struct_type;

} sample17_typedef_struct_type; /* end sample17_typedef_struct_type */

/* ==========================END SAMPLE DATA STRUCTURES=============================*/

/** 
 Keeps track of out-of-bounds block area information and the size of each block.
*/
struct oob_area_info
{
  uint8 block_count;         /**< Number of blocks in the out-of-bounds area.*/
  uint8 block_size_in_bytes; /**< Size of each block in the out-of-bounds area. */
};

/** @} */ /* end_first_fancy_device_api */
/** @addtogroup first_fancy_device_api
@{ */

/*
 Keeps track of local area block information. 

This is an optional detailed description. This structure is used to keep track of the 
number and size of blocks in the local area.
*/
struct local_area
{
  uint32 area_count;         /**< Total number of blocks in the local area. */
  uint32 area_size_in_bytes; /**< Size of each block in the local area. */
};

/** @} */ /* end_addtogroup_first_fancy_device_api */

/** @addtogroup second_fancy_device_api
@{ */

/** 
 @brief Access rights namespace.

 Detailed description for the AR namespace.
*/
namespace AR {

   const ::FANCYID FANCYID_IRightsChange = 0x1074feb; /**< Changes the access 
                                                      rights. */

   enum RightsChangeReason
   {
      RightsChangeReason_Added,
      RightsChangeReason_Deleted,
      RightsChangeReason_Modified,
      RightsChangeReason_Unknown,
      _AR_PLACEHOLDER_RightsChangeReason = 0x7fffffff
   };
}; /* end_AR_namespace */

  
/*=============================================================================
  Class: CRectangle
=============================================================================*/
/**
 Takes the height and length of a rectangle and returns the area value.

This class (CRectangle) contains four members: two input parameter members of type 
integer (x, y, where x=height and y=length) and two member functions (set_values, area) 
with public access. 

This class calls the set_values member function to set the input values (x, y) 
to integers. This function is void, which indicates that is does not return a result; it 
just holds the results temporarily. It then calls the area member function, which takes 
the values in the set_values member function (x, y), multiplies them (x*y), and returns
the result (area of the rectangle).

@param[in] x  Data member x of type integer with private access. This member is private 
              by default. This sentence was added to test out the single-spacing issue for
			  long descriptions inside a parameter table.
@param[in] y  Data member y of type integer with private access. This member is private 
              by default.

@return 
Area of the rectangle as an integer value.

@dependencies
None.

*/
class CRectangle {
  public:
    int x, y;
  public:
    void set_values (int,int);
    int area () {return (x*y);}
}; /* end_class */

void CRectangle::set_values (int a, int b) {
  x = a;
  y = b;
};

/** @} */ /* end_addtogroup second_fancy_device_api */

/** @addtogroup third_fancy_device_api
@{ */

/*===========================================================================
  FUNCTION : fancy_report_event
===========================================================================*/
/**
  Event-driven drivers call this function to report asynchronous events to
  the Fancy Device.

  @param[in] data    Event-related data.

  @return
  FANCY_SUCCESS -- Requested operation was successful.\n
  FANCY_FAILURE -- Requested operation was not successful.\n
  FANCY_LOCKED  -- Operation failed because device was locked.

  @dependencies
  None.
  
*/
fancy_return_type fancy_report_event
(
  const fancy_event_data_type * data
);

/**
 Holds the new and previous cold boot block numbers. 

This is an optional detailed description. This structure is used in Fancy 
Device tools during software initialization.
*/
struct fancy_cold_boot_block
{
  int cold_boot_new_block;              /**< New cold boot block number. */
  int cold_boot_old_block;              /**< Old cold boot block number. */
};

/** @} */ /* end_addtogroup third_fancy_device_api */

/** @addtogroup first_fancy_device_api
@{ */
/** @name WFD Cold Boot Values
@{ */
#define FANCY_COLD_BOOT_START_BLOCK_VALUE        0
  /**< Initial value for the start block. */

#define FANCY_MAX_COLD_BOOT_END_BLOCK_VALUE      1
  /**< Maximum value for the end block. */

#define FANCY_COLD_BOOT_BLOCK_VALUE_INVALID      ((cold_blk_invalid_type) 0xFF)
  /**< Value for the cold boot block is invalid. */

#define FANCY_COLD_BOOT_BLOCK_VALUE_UNASSIGNED   ((cold_blk_unassigned_type) 0xFE)
  /**< Value for the cold boot block is unassigned. */
/** @} */ /* end_name WFD Cold Boot Values */
/** @} */ /* end_addtogroup first_fancy_device_api */

/** @addtogroup second_fancy_device_api
@{ */
/**
 Holds the new and previous warm boot block numbers. 

This is an optional detailed description. This structure is used in Fancy 
Device tools during software download.
*/
struct fancy_warm_boot_block
{
  int warm_boot_new_block;              /**< New warm boot block number. */
  int warm_boot_old_block;              /**< Old warm boot block number. */
};

/** @} */ /* end_addtogroup second_fancy_device_api */
/** @addtogroup second_fancy_device_api
@{ */

#define FANCY_WARM_BOOT_START_BLOCK_VALUE        0
  /**< Initial value for the start block. */

#define FANCY_MAX_WARM_BOOT_END_BLOCK_VALUE      1
  /**< Maximum value for the end block. */

#define FANCY_WARM_BOOT_BLOCK_VALUE_INVALID      ((warm_blk_invalid_type) 0xFF)
  /**< Warm boot block value is invalid. */

#define FANCY_WARM_BOOT_BLOCK_VALUE_UNASSIGNED_WITHAVERYLONGLONGDEFINENAMEWITHNOUNDERSCORES ((warm_blk_unassigned_type) 0xFE)
  /**< Warm boot block value is unassigned. */

/** @} */ /* end_addtogroup second_fancy_device_api */
/** @addtogroup second_fancy_device_api
@{ */

/** Identifies the device types for downloading software to one or more devices. */
typedef enum download_type
{
  download_OOB,      /**< Out-Of-Bounds device. */
  download_NOOB,     /**< More than one Not-Out-Of-Bounds device.\n
					      @note1 This is an example of a note for an enum
						  member (note1 command). This can also be used
						  in param descriptions. */
  download_ONENOOB,  /**< OneNOOB device. */
  download_MULTI     /**< Multiple devices. */
};

/** Identifies the bits per cell for the device. */
typedef enum download_tech
{
  download_SLC,        /**< Single-Level Cell device. */
  download_MLC,        /**< Multi-Level Cell device. */
};

/** Identifies the download ID. */
typedef enum download_ID
{
  download_x8  = 8,    /**< 8-bit interface download ID. */
  download_x16 = 16    /**< 16-bit interface download ID. */
};

/* Identifies the type of data to be read with the Fancy Read API. */
typedef enum
{
  FANCY_READ_MAIN = 0,   /* Read main data only. main_data is not NULL. */
  FANCY_READ_SPARE,      /* Read spare data only. spare_data is not NULL and
                            spare_size_bytes is set. */ 
  FANCY_READ_MAIN_SPARE, /* Read both main and spare data. main_data and
                            spare_data are not NULL, and spare_size_bytes is set. */ 
  FANCY_READ_RAW,        /* Read all RAW bytes in the page. main_data is not 
                            NULL and main_size_bytes includes main+spare space. */ 
  FANCY_READ_BYTES       /* Read the specified number of bytes within the page. 
                            main_data is not NULL, main_size_bytes is less than
                            or equal to the page size bytes. */
};

/** @} */ /* end_addtogroup second_fancy_device_api */

/** @addtogroup third_fancy_device_api
@{ */

/*=============================================================================
  Function: CreateInstance
=============================================================================*/
/**
Provides a public entry point for the module. A new instance of FancyInterfere is 
created for FancyModule, and the default interface is returned.

@msg
The following table is an example of a table which was created using the
Word-to-LaTeX tool with minor manual formatting adjustments:

@inputtable{Sample_Manual_LaTeX_Table.tex}

@note Test note 1.
@note Test note 2.
@note Test note 3.

@param[in] clsid         Class ID of the module.
@param[in] pEnvironment  Interface to the Fancy Services environment.
@param[out] pPrivSet      Privilege set of the caller.
@param[in,out] ppNewObj     Set to the interface pointer of the new instance.

@return 
SUCCESS -- Instance was created successfully. \n
ENOMEMORY -- Indicates a memory allocation failure.

@dependencies
None.

@sideeffects 
An invalid class ID may produce erroneous results.

@sa
NDQueryInterface

*/
static int CreateInstance(FANCYCLID clsid,
                             IEnv *pEnvironment,
                             IPrivSet *pPrivSet,
                             void **ppNewObj
                            );

/** @} */ /* end_addtogroup third_fancy_device_api */
/** @addtogroup third_fancy_device_api
@{ */

#define FANCY_DEVICE_DONE                 0  /**< Operation passed. */
#define FANCY_DEVICE_FAIL               (-1) /**< Operation failed. */
#define FANCY_DEVICE_NOT_SUPPORTED      (-2) /**< Device is not supported. */
#define FANCY_DEVICE_CP_READ_FAIL       (-3) /**< Copy page read failure. */

/** @} */ /* end_addtogroup third_fancy_device_api */
/** @addtogroup third_fancy_device_api
@{ */

/* Defines the interface version.
The interface version can be 0 (the default) to indicate that this is the first 
instance, or it can be 1 to indicate that this is the latest version.

//@mscfile mscgen_callflows/msc_callflow_sample.txt
//
//@latexonly
//  \begin{figure}[H]
//  \centering
//  \renewcommand{\thefigure}{\thechapter-\arabic{figure}}
//  \caption{Sample Call Flow}
//  \label{fig:Sample Call Flow}
//\end{figure}
//@endlatexonly
*/
#define FANCY_INTERFACE_VERSION DALINTERFACE_VERSION(1,0) 

/** @} */ /* end_addtogroup third_fancy_device_api */
/** @addtogroup third_fancy_device_api
@{ */
/*=============================================================================
  Function: NDQueryInterface
=============================================================================*/
/**
Handles interface pointers for non-based classes.

This method must be implemented if the FancyInterfere module supports any 
interfaces not handled by its base classes.

@note Test note 1.
@note Test note 2.
@note Test note 3.
@note Test note 4.
@note Test note 5.
@note Test note 6.
@note Test note 7.
@note Test note 8.
@note Test note 9.
@note Test note 10.

@param[in] idReq     Unique ID of the requested interface.
@param[out] ppIface  Interface pointer of the requested interface.

@return
SUCCESS -- Interface is returned successfully.\n
ECLASSNOTSUPPORT -- Interface is not supported.
*/
virtual int NDQueryInterface(FANCYID idReq,
                                    IQI **ppIface
                                    );

/*=============================================================================
  Function: NameThread
=============================================================================*/
/**
Handles thread name intialization.

The deriving class can override this method to provide a descriptive name for the 
optional output thread. This helps distinguish it in debugging applications.
The default implementation provides a generic name.

@note1hang 
This is an example of a single hanging indent note (note1hang command). It is primarily 
intended for use in fancy tools during software download. 

@return
SUCCESS -- Initialization was successful.\n
FAILURE -- Initialization failed.
*/
FancyResult NameThread() {
      return DoNameThread("FancyInterfere");
   };

/*=============================================================================
  Function: FancyInterfere
=============================================================================*/
/**
Provides a class constructor.

This is the component constructor, meant to be called by the class factory 
of the component.

@param[in] clsid         Class ID of the module.
@param[in] pEnvironment  Interface to the Fancy Services environment.
@param[out] result       Result of the function.

@return 
The following results may be returned:
- Valid class object
- Invalid class object
*/
FancyInterfere(FANCYCLSID clsid, pEnv
					  *pEnvironment,
					  int &result
                     );

/** @} */ /* end_addtogroup third_fancy_device_api */
/** @addtogroup third_fancy_device_api
@{ */

/** Standard print function.
The extern keyword is used to inform the compiler about variables declared outside 
of the current file. Variables described by extern statements do not have any 
space allocated for them because they have been previously defined elsewhere.
*/
extern "C" int printf( const char *fmt, ... );

/** @} */ /* end_addtogroup third_fancy_device_api */
/** @addtogroup third_fancy_device_api
@{ */

/** 
 Accesses the header values. This union includes two data structures. 
*/
union _AfancyAudioEvent {
   struct AfancyAudioAnyEvent any;
   struct AfancyAudioAnyEvent header; 
      /* For convenience to access header values. */
   };

/** @} */ /* end_addtogroup third_fancy_device_api */

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  BEGIN EXAMPLE: PACKED STRUCT AND PACKED ENUM EXAMPLES. Code using Pack  
                 macros (such as PACKED and PACKED_POST) must be defined in the 
				 Doxy_Config.ldd under PREDEFINED and EXPAND AS DEFINED, so that 
				 Doxygen can see the code comments for parsing.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

/** @addtogroup third_fancy_device_api
@{ */

/** 
 Stores Fancy Quality of Service parameters.

This is an optional detailed description. This structure includes three members.
*/
typedef PACKED struct PACKED_POST
{
  boolean   valid_flg;            /**< Indicates whether the parameters are set 
                                       and valid. This is a test detailed sentence. */
  uint32    precedence;           /**< Precedence class. This is a test detailed 
                                       sentence. */
  uint32    mean;                 /**< Mean throughput class. */
} fancy_qos_params_type;

/** @} */ /* end_addtogroup third_fancy_device_api */
/** @addtogroup third_fancy_device_api
@{ */

/** Fancy header compression types.
*/
typedef PACKED enum PACKED_POST
{
  FANCY_HEADER_COMP_OFF =    0,   /**< Compression is off (default). */
  FANCY_HEADER_COMP_ON  =    1,   /**< Compression is on when selected. */
  FANCY_HEADER_COMP_MAX = 0xFF    /**< Forces the maximum compression to 0xff
                                       so the enumeration is defined as a byte. */
} fancy_header_comp_e_type;

/** @} */ /* end_addtogroup third_fancy_device_api */

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  END EXAMPLE: PACKED STRUCT AND PACKED ENUM EXAMPLES.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  BEGIN EXAMPLE: ANONYMOUS ENUM EXAMPLE. An anonymous enum is an enum with no 
                 name following the enum keyword. In the Doxy_Config.ldd file, 
				 set MACRO_EXPANSION = YES to force Doxygen to parse these and 
				 place them into the output documentation.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

/** @addtogroup third_fancy_device_api
@{ */
/** Fancy device validation modes.
*/
typedef enum
{
  FANCY_DEVICE_VAL_OFF =    0,   /**< Device validation mode is off (default). */
  FANCY_DEVICE_VAL_ON  =    1,   /**< Device validation mode is on when selected. */

}fancy_dev_val_e_type;

/** @} */ /* end_addtogroup third_fancy_device_api */

/** @addtogroup third_fancy_device_api
@{ */

/* System time types are required. */
typedef enum
{
   IAO_SYSTIME_UMTS  = 0x00,      /* UMTS system time. */
   IAO_SYSTIME_GSM   = 0x01,      /**< GSM system time. */
   IAO_SYSTIME_TOT                /**< Total number of system time types. */
}FancySysTimeType1;

/** @} */ /* end_addtogroup third_fancy_device_api */

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  END EXAMPLE: ANONYMOUS ENUM EXAMPLE. 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  BEGIN EXAMPLE: #ifndef macro (DOXYGEN_SHOULD_SKIP_THIS). When this macro is 
    placed in the Doxy Config file after PREDEFINED, the code between this
    macro should be skipped by Doxygen and not included in the PDF.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

/** @addtogroup third_fancy_device_api
@{ */

#ifndef DOXYGEN_SHOULD_SKIP_THIS

/** 
 Fancy input and output device handles.

These handles allow the device to be configured for opening, closing, and synchronizing. 
*/
typedef struct 
{
   FancyDevice FancyDevice; /** Main fancy device. */
   FancyResult (*FancyOpen)(FancyDeviceHandle * _h, uint32 fancyFifoNum); /** Open fancy device. */
   FancyResult (*FancyClose)(FancyDeviceHandle  * _h, uint32 fancyFifoNum); /** Close fancy device. */
   FancyResult (*FancyAsyncRead)(FancyDeviceHandle * _h, uint32 fancyFifoNum, FANCYSYSMemHandle hXferBufMem,uint32 fancyLen, FANCYSYSEventHandle hEvent); /** Asynchronous read of fancy device. */
   FancyResult (*FancyAsyncWrite)(FancyDeviceHandle *  _h, uint32 fancyFifoNum, FANCYSYSMemHandle hXferBufMem, uint32 fancyLen, FANCYSYSEventHandle hEvent); /** Asynchronous write of fancy device. */
}FancyIAO;

#endif #ifndef DOXYGEN_SHOULD_SKIP_THIS

/** @} */ /* end_addtogroup third_fancy_device_api */
/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  END EXAMPLE: #ifndef macro (DOXYGEN_SHOULD_SKIP_THIS). When this macro is 
    placed in the Doxy Config file after PREDEFINED, the code between this
    macro should be skipped by Doxygen and not included in the PDF.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

/** @addtogroup third_fancy_device_api
@{ */ 

/** Supported WFD warm start events. */
typedef enum
{
  WFD_WS_EVENT_TOT        /**< Total number of warm start events */
}WfdWSEvtType;

/** @} */ /* end_addtogroup third_fancy_device_api */

#endif /* SAMPLEHEADERFILE1_MULTIGROUPS_C_H_ */
