/**
\file
\ingroup geom
    Class for B-Spline surface entities

\author
    J. P. Abelanet - 10/05/96
*/



// library includes
#include <geom/BSpline.h>
#include <geom/Entity.h>
#include <geom/Geometry.h>
#include <geom/Surface.h>
#include <geom/Transform.h>
#include <vmath/Base.h>
#include <vmath/Error.h>
#include <vmath/hash.h>
#include <vmath/interval.h>
#include <vmath/vector.h>

// non-automatic library includes
#include <geom/BSplineInterval.h>


namespace GE {

// forward declarations
class BSplineCurve;
class Curve;
template <class T>
class EntityList;
class NativeFileReader;
class NativeFileWriter;


/**
    This is the class for B-Spline surfaces.  It has class identifier
    ENT_class_bspline_surface.

\author
    J. P. Abelanet - 05/06/04
*/
class BSplineSurface: public Surface {

public:
  Boolean Change_Rational (const Boolean RationalNew);

public:
  static void DoNothing1 ();
  static void DoNothing2 ();
  static void DoNothing3 ();
  static void DoNothing4 ();
  
private:
  BSpline	BSpline_;
};

/**
    This routine gets the nested B-Spline from a B-Spline surface.


\return
	nested B-Spline
  
\author
    J. P. Abelanet - 05/06/04
*/
inline Boolean BSplineSurface::Change_Rational (const Boolean RationalNew) 	{ return TRUE; }

/**
    This routine does nothing to nobody.


\author
    J. P. Abelanet - 10/31/05
*/
inline void BSplineSurface::DoNothing1 () 	{ }

/**
    This routine does nothing to nobody.


\author
    J. P. Abelanet - 10/31/05
*/
inline void BSplineSurface::DoNothing2 () 	{ }

/**
    This routine does nothing to nobody.


\author
    J. P. Abelanet - 10/31/05
*/
inline void BSplineSurface::DoNothing3 () 	{ }

/**
    This routine does nothing to nobody.


\author
    J. P. Abelanet - 10/31/05
*/
inline void BSplineSurface::DoNothing4 () 	{ }



}


