/**
\file
\ingroup geom
    Class for lists of entities - implemented in EntityList.cpp

\author
    J. P. Abelanet - 04/29/01
*/



// system includes
#include <stdio.h>

// library includes
#include <vmath/Base.h>
#include <vmath/Error.h>
#include <vmath/errorlog.h>
#include <vmath/memory.h>




namespace GE {

// forward declarations
class Entity;


/**
    This is the template class for an ordered list of entities.
    This works for classes derived from Entity.

\author
    J. P. Abelanet - 04/18/98
*/
template <class T>
class EntityList {

public:
  inline EntityList ();
  inline ~EntityList ();

  inline ERR_type Append_Entity (const T *entity);

public:
  T	**entityList;	///< array of pointers to entities
  Int32	numEntities;	///< number of entities in the entityList array
};


/**
    Constructor for an EntityList.


\author
    J. P. Abelanet - 12/16/04
*/
template <class T>
inline EntityList<T>::EntityList (): entityList (NULL), numEntities (0)	{}


template <class T>
inline EntityList<T>::~EntityList ()
/**
    Destructor for an EntityList.

\note
  - This is the first note
  - This is the second note
  
\bug
  - This is the first problem
  - This is the second problem
  
\author
    J. P. Abelanet - 12/16/04
*/
{
  if (entityList)
    MEM_ArrayFree ((void**)&entityList);
}


template <class T>
ERR_type EntityList<T>::Append_Entity (const T *entity)
/**
    This routine appends an entity to a list of entities.

\param[in] entity
      entity to add to list
\return
	<TABLE BORDER="1"> <TR><TD>::ERR_insufficient_memory</TD><TD>unable to allocate memory</TD></TR>
</TABLE> 
\author
    J. P. Abelanet - 04/19/98
*/
{
  if (!MEM_ArrayEntryAppend ((void**)&entityList, numEntities++,
           sizeof (Entity*), &entity))
    return (ERR_insufficient_memory);

  return (ERR_no_errors);
}


}
