#include <iostream>
#include <glibmm.h>
#include <giomm.h>

static void on_signal(const Glib::ustring& sender_name,
  const Glib::ustring& signal_name, const Glib::VariantBase& varParameters)
{
  Glib::ustring parameters = varParameters.print(true);
  std::cout << " *** Received Signal: " << signal_name << ": "
      << parameters << std::endl;
}

static void on_name_owner_notify(const Glib::RefPtr<Gio::DBus::Proxy>& refProxy)
{
  Glib::ustring owner = refProxy->get_name_owner();
  if (owner == "")
  {
    owner = "(no owner)";
  }
  std::cout << " *** Name owner changed: " << owner << std::endl;
}

// The signal g-properties-changed is not yet wrap in the sources of the git repository
/*
static void on_properties_changed(const Glib::VariantBase& changed_properties,
  const std::vector<Glib::ustring>& invalidated_properties)
{
  std::cout << "debug: on_properties_changed" << std::endl;

  Glib::Variant< std::map< Glib::ustring, Glib::VariantBase > >&
    var_changed_properties = (Glib::Variant< std::map< Glib::ustring, Glib::VariantBase > >&)changed_properties;

//  std::map< Glib::ustring, Glib::VariantBase > map = var_changed_properties.get();
//  std::map< Glib::ustring, Glib::VariantBase >::iterator it;
//  for (it = map.begin(); it != map.end(); it++)
//  {
//    std::pair< Glib::ustring, Glib::VariantBase > p = *it;
//    std::cout << " *** Properties Changed:" << std::endl;
//    std::cout << "      " << p.first
//        << " -> "
//        << p.second.print(true)
//        << std::endl;
//  }

//  if (g_variant_n_children(changed_properties) > 0)
//  {
//    GVariantIter *iter;
//    const gchar *key;
//    GVariant *value;
//
//    g_print(" *** Properties Changed:\n");
//    g_variant_get(changed_properties, "a{sv}", &iter);
//    while (g_variant_iter_loop(iter, "{&sv}", &key, &value))
//    {
//      gchar *value_str;
//      value_str = g_variant_print(value, TRUE);
//      g_print("      %s -> %s\n", key, value_str);
//      g_free(value_str);
//    }
//    g_variant_iter_free(iter);
//  }
//

  if(invalidated_properties.size() > 0)
  {
    std::cout << " *** Properties Invalidated:" << std::endl;
    for (unsigned int n = 0; n < invalidated_properties.size(); n++)
    {
      std::cout << "      " << invalidated_properties[n] << std::endl;
    }
  }
}
*/

static void hello_world_result(Glib::RefPtr<Gio::AsyncResult>& refResult,
  const Glib::RefPtr<Gio::DBus::Proxy>& proxy) {
  Glib::VariantContainerBase var;

  proxy->call_finish(var, refResult);

  Glib::Variant<Glib::ustring> varResponse;
  var.get(varResponse, 0);
  std::cout << " *** Response: " << varResponse.get() << std::endl;
}

static void hello_world_result_with_expected_error(Glib::RefPtr<Gio::AsyncResult>& refResult,
  const Glib::RefPtr<Gio::DBus::Proxy>& proxy) {
  Glib::VariantContainerBase var;

  try
  {
  proxy->call_finish(var, refResult);
    std::cout << "Method call error: expected exception" << std::endl;
    exit(EXIT_FAILURE);
  } catch (const Glib::Error& e)
  {
    std::cout << " *** Method call expected error: " << e.what() << std::endl;
  }
}

static void set_property(const Glib::RefPtr<Gio::DBus::Proxy>& refProxyProperties,
  const Glib::ustring& propertyName, const Glib::ustring& value)
{
  Glib::Variant<Glib::ustring> varInterfaceName =
      Glib::Variant<Glib::ustring>::create("org.gtkmm.GDBus.TestInterface");

  Glib::Variant<Glib::ustring> varPropertyName = Glib::Variant<Glib::ustring>::create(propertyName);

  Glib::Variant<Glib::ustring> varValueString = Glib::Variant<Glib::ustring>::create(value);
  Glib::Variant<Glib::VariantBase> varValue =
      Glib::Variant<Glib::VariantBase>::create(varValueString);

  std::vector<Glib::VariantBase> paramVector;
  paramVector.push_back(varInterfaceName);
  paramVector.push_back(varPropertyName);
  paramVector.push_back(varValue);
  Glib::VariantContainerBase varParameters =
      Glib::VariantContainerBase::create_tuple(paramVector);

  Glib::VariantBase varResultNil = Glib::VariantBase();
  refProxyProperties->call_sync(varResultNil, "Set", varParameters);
}

static void get_property(const Glib::RefPtr<Gio::DBus::Proxy>& refProxyProperties,
  const Glib::ustring& propertyName) {
  Glib::Variant<Glib::ustring> varInterfaceName =
      Glib::Variant<Glib::ustring>::create("org.gtkmm.GDBus.TestInterface");

  Glib::Variant<Glib::ustring> varPropertyName = Glib::Variant<Glib::ustring>::create(propertyName);

  std::vector<Glib::VariantBase> paramVector;
  paramVector.push_back(varInterfaceName);
  paramVector.push_back(varPropertyName);
  Glib::VariantContainerBase varParameters =
      Glib::VariantContainerBase::create_tuple(paramVector);

  Glib::VariantContainerBase varResult;
  refProxyProperties->call_sync(varResult, "Get", varParameters);

  //std::cout << " *** Get: " << varResult.get_type_string() << std::endl;

  Glib::Variant<Glib::VariantBase> varBase;
  varResult.get(varBase);

  Glib::Variant<Glib::ustring> varString;
  varBase.get(varString);
  Glib::ustring value;
  value = varString.get();
  std::cout << " *** Get: " << propertyName << ": " << value << std::endl;
}

static void call_hello_world_method(const Glib::RefPtr<Gio::DBus::Proxy>& refProxyTestInterface)
{
  Glib::VariantContainerBase varParameters;

  varParameters = Glib::VariantContainerBase(g_variant_new("(s)", "hello"), true);
  refProxyTestInterface->call("HelloWorld",
    sigc::bind<const Glib::RefPtr<Gio::DBus::Proxy>& >(
        sigc::ptr_fun(hello_world_result), refProxyTestInterface), varParameters);

  varParameters = Glib::VariantContainerBase(g_variant_new("(s)", "Return Unregistered"), true);
  refProxyTestInterface->call("HelloWorld",
    sigc::bind<const Glib::RefPtr<Gio::DBus::Proxy>& >(
        sigc::ptr_fun(hello_world_result_with_expected_error), refProxyTestInterface), varParameters);

  varParameters = Glib::VariantContainerBase(g_variant_new("(s)", "Return Registered"), true);
  refProxyTestInterface->call("HelloWorld",
    sigc::bind<const Glib::RefPtr<Gio::DBus::Proxy>& >(
        sigc::ptr_fun(hello_world_result_with_expected_error), refProxyTestInterface), varParameters);

  varParameters = Glib::VariantContainerBase(g_variant_new("(s)", "Return Raw"), true);
  refProxyTestInterface->call("HelloWorld",
    sigc::bind<const Glib::RefPtr<Gio::DBus::Proxy>& >(
        sigc::ptr_fun(hello_world_result_with_expected_error), refProxyTestInterface), varParameters);
}

static void call_emit_signal_method(const Glib::RefPtr<Gio::DBus::Proxy>& refProxyTestInterface)
{
  Glib::VariantContainerBase varParameters =
      Glib::VariantContainerBase(g_variant_new("(d)", 100.0), true);
  Glib::VariantContainerBase varResult;
  try
  {
    refProxyTestInterface->call_sync(varResult, "EmitSignal", varParameters);
  } catch (const Glib::Error& e)
  {
    std::cerr << "Method call error: " << e.what() << std::endl;
    exit(EXIT_FAILURE);
  }
}

static void on_timeout_call(const Glib::RefPtr<Gio::DBus::Proxy>& refProxyTestInterface,
  const Glib::RefPtr<Gio::DBus::Proxy>& refProxyProperties)
{
  call_hello_world_method(refProxyTestInterface);

  call_emit_signal_method(refProxyTestInterface);

  set_property(refProxyProperties, "Title", "Test");
  try
  {
    set_property(refProxyProperties, "WritingAlwaysThrowsError", "Test");
  }
  catch (const Glib::Error& e)
  {
    std::cerr << " *** Set expected error: " << e.what() << std::endl;
  }

  get_property(refProxyProperties, "WritingAlwaysThrowsError");
  try
  {
    get_property(refProxyProperties, "ReadingAlwaysThrowsError");
  }
  catch (const Glib::Error& e)
  {
    std::cerr << " *** Get expected error: " << e.what() << std::endl;
  }
}

int main(int argc, char *argv[])
{
  Gio::init();
  Glib::init();

  Glib::RefPtr<Gio::DBus::Proxy> refProxyTestInterface;
  Glib::RefPtr<Gio::DBus::Proxy> refProxyProperties;
  try
  {
    refProxyTestInterface = Gio::DBus::Proxy::create_for_bus_sync(Gio::DBus::BUS_TYPE_SESSION,
      "org.gtkmm.GDBus.TestServer", "/org/gtkmm/GDBus/TestObject",
      "org.gtkmm.GDBus.TestInterface");
    refProxyProperties = Gio::DBus::Proxy::create_for_bus_sync(Gio::DBus::BUS_TYPE_SESSION,
      "org.gtkmm.GDBus.TestServer", "/org/gtkmm/GDBus/TestObject",
      "org.freedesktop.DBus.Properties");
  } catch (const Glib::Error& e)
  {
    std::cerr << "Error creating proxy: " << e.what() << std::endl;
    exit(EXIT_FAILURE);
  }

  refProxyTestInterface->signal_signal().connect(sigc::ptr_fun(on_signal));
// The signal g-properties-changed is not yet wrap in the sources of the git repository
//  refProxyTestInterface->signal_properties_changed().connect(sigc::ptr_fun(on_properties_changed));
  refProxyTestInterface->connect_property_changed("g-name-owner", sigc::bind<const Glib::RefPtr<
      Gio::DBus::Proxy>& >(sigc::ptr_fun(on_name_owner_notify), refProxyTestInterface));

  Glib::signal_timeout().connect_seconds_once(
    sigc::bind<const Glib::RefPtr<Gio::DBus::Proxy>&, const Glib::RefPtr<Gio::DBus::Proxy>&>(
        sigc::ptr_fun(on_timeout_call), refProxyTestInterface, refProxyProperties), 2);

  Glib::RefPtr<Glib::MainLoop> loop = Glib::MainLoop::create();
  loop->run();

  return EXIT_SUCCESS;
}
