#ifndef SAMPLEHEADERFILE3_MULTIGROUPS_C_H_
#define SAMPLEHEADERFILE3_MULTIGROUPS_C_H_

/**
@file SampleHeaderFile3_multigroups_C.h
@brief  
Third sample header file with Doxygen markup examples.

This file includes sample code needed to generate a sample PDF
document developed with standard C files, which include multiple
groups. This file is also used for training and provides the
examples shown in the QCT Doxygen Markup Standards (80-VP989-1).
*/
/*-------------------------------------------------------------------------------
     Copyright (c) 2010 QUALCOMM Incorporated.
	 All rights reserved.
	 Qualcomm Confidential and Proprietary
-----------------------------------------------------------------------------*/
/*=============================================================================
                             Edit History
$Header: //depot/Living_Documents/Training/Current_Doxygen_Standards/
           DoxygenMarkupStandards/SampleHeaderFile3_multigroups_C $

when       who     what, where, why
--------   ---     ------------------------------------------------------------
09/22/10   LB     Updated to reflect Rev C standards.
05/26/10   LB     Updated from LD CCB review to create final for Rev B.
05/18/10   LB     Updated to include Module grouping samples and 
                  other advanced Doxygen markup examples for the
                  Rev B Doxygen Markup Standards
01/14/10   LB     Fixed the corrupted file and regenerated PDF.
01/13/10   LB     Initial revision for Rev A Doxygen Markup Standards.
===============================================================================*/

#include <queue> 

#include <FancySignalQ.h>

/** @addtogroup third_fancy_device_api
@{ */

/**
@brief Provides ResamplerState and ChannelMode2 enumeration types.

This is the detailed fancy audio namespace. 
*/
namespace fancy_audio_2 {

	/** Sample comment for enum inside a namespace. */ 
	enum SamplerState {
      S_OK,              /**< Resampler state is in OK mode. */
      S_NEED_INPUT_BUF,  /**< Resampler state needs an input buffer. */
      S_NEED_OUTPUT_BUF  /**< Resampler state needs an output buffer. */
   }; 
   /** Another sample comment for enum inside a namespace. */ 
   enum ChannelMode2 {
      MONO =1,           /**< Channel Mode 2 is in mono mode. */
      STEREO =2          /**< Channel Mode 2 is in stereo mode. */
   };

   GenericSamplerLib* m_pResampler; /**< Generic Sampler library object. */
   uint32 m_uiInpBufferSize;        /**< Size of the input buffer delivered to the 
                                         sampler. */
   boolean m_fSampTypeSet;          /**< SamplerType Set flag. */
   
   bool m_Enabled;                  /**< Enables the flag master for FancyInterfere. */
   bool m_EnabledRead;              /**< Enables FancyInterfere on the Read channel. */
   
   ISignalQ*   m_pEventSignalQ;     /**< Signal queue for blocking events. */
   
/** Rx queues for Fancy Device buffers received from the application. */
   std::queue <FancyCommand*> m_fancyRxBufferQueue;

/** Tx queues for Fancy Device buffers received from the application. */
   std::queue <FancyCommand*> m_fancyTxBufferQueue;

/*=============================================================================
  PUBLIC CLASS METHODS
=============================================================================*/
public:
/*=============================================================================
  FancyBase Methods
=============================================================================*/

DECLARE_IQI;   /**< Pulls in IQueryInterface method definitions. */

/**
Provides an interface to support the FancyInterface module.

This method must be implemented if the FancyInterfere module supports 
any interfaces not handled by its base classes.

@param[in] idReq     Unique ID of the requested interface.
@param[out] ppIface  Interface pointer of the requested interface.

@return
SUCCESS -- Interface is returned successfully.\n
ECLASSNOTSUPPORT -- Interface is not supported.
*/
virtual int CDECL NDQueryInterface(FANCYCLSIDRQ idReq,
                                      IQI **ppIface
                                     );

/*=============================================================================
  FancyEnhancedConversion Methods
=============================================================================*/

/**
Overrides a generic name.

The deriving class may override this method to provide a descriptive name for the 
optional output thread to help distinguish it in debugging applications. 
The default implementation provides a generic name.
  
@return
SUCCESS -- Initialization was successful.\n
FAILURE -- Initialization failed.
*/
FancyResult NameThread() {
      return DoNameThread("FancyInterfere");
   }

/**
Provides a class constructor.

This is the component constructor, meant to be called by the class factory of the 
component.

@param[in] clsid         Class ID of the module.
@param[in] pEnvironment  Interface to the component services environment.
@param[out] result       Result of the function.

@return 
New class object.
*/
FancyInterfere(FANCYCLSID clsid,
                      IEnv *pEnvironment,
                      int &result
                      );

}; /* end_class */

}; /* end_namespace fancy_audio_2 */

/** @} */ /* end_addtogroup third_fancy_device_api */

#endif /* SAMPLEHEADERFILE3_MULTIGROUPS_C_H_ */
