#ifndef SAMPLEHEADERFILE2_MULTIGROUPS_C_H_
#define SAMPLEHEADERFILE2_MULTIGROUPS_C_H_

/**
@file SampleHeaderFile2_multigroups_C.h
@brief  
Second sample header file with Doxygen markup examples.

This file includes sample code needed to generate a sample PDF
document developed with standard C files, which include multiple
groups. This file is also used for training and provides the
examples shown in the QCT Doxygen Markup Standards (80-VP989-1).
*/
/*-------------------------------------------------------------------------------
     Copyright (c) 2010 QUALCOMM Incorporated.
	 All rights reserved.
	 Qualcomm Confidential and Proprietary
-----------------------------------------------------------------------------*/
/*=============================================================================
                             Edit History
$Header: //depot/Living_Documents/Training/Current_Doxygen_Standards/
           DoxygenMarkupStandards/SampleHeaderFile2_multigroups_C.h $

when       who     what, where, why
--------   ---     ------------------------------------------------------------
09/22/10   LB     Updated to reflect Rev C standards.
05/26/10   LB     Updated from LD CCB review to create final for Rev B.
05/18/10   LB     Updated to include Module Grouping samples and other 
                  advanced Doxygen markup examples for the Rev B Doxygen
                  Markup Standards.
01/14/10   LB     Fixed the corrupted file and regenerated PDF.
01/13/10   LB     Initial revision for Rev A Doxygen Markup Standards.
===============================================================================*/

#include <queue> 

#include <FancyISignalQ.h>

/** @addtogroup second_fancy_device_api
@{ */

/**
@brief Provides SamplerState and ChannelMode1 enumeration types.

This is the first fancy audio namespace.
*/
namespace fancy_audio_1 {

	enum ResamplerState {
      RS_OK,
      RS_NEED_INPUT_BUF,
      RS_NEED_OUTPUT_BUF
   };

   enum ChannelMode1 {
      MONO =1,
      STEREO =2
   };

   GenericResamplerLib* m_pResampler; /**< Generic Resampler library object. */

   bool m_Enabled; /**< Enables the master flag during FancyPlayback. */

   ICritSect* m_pRxBufferLock; /**< Critical section for the Rx buffer queue. */
   
   /** Rx and Tx queues for Fancy Device buffers received from the application. */
   std::queue <FancyCommand*> m_fancyRxBufferQueue;
   std::queue <FancyCommand*> m_fancyTxBufferQueue;

/*=============================================================================
  PUBLIC CLASS METHODS
=============================================================================*/
public:
/*=============================================================================
  FancyBase Methods
=============================================================================*/

DECLARE_IQI;   /**< Pulls in IQueryInterface method definitions. */

/**
Provides a public entry point for the module.

A new instance of FancyPlayback is created, and the default interface (FancyMediaModule) 
is returned.
   
@param[in] clsid          FANCYCLSID of the module.
@param[in] pEnvironment   Interface to the Fancy Services environment.
@param[out] pPrivSet       Privilege set of the caller.
@param[in,out] ppNewObj      Interface pointer of the new instance.

@return
SUCCESS -- Instance was created successfully.\n
ENOMEMORY -- Memory allocation failure.

@comments
A memory allocation failure requires a reboot.

@errors 
If the new environment value is not an integer, the
compiler generates an error.\n
If the new environment object is called outside the Fancy Services
environment without the pointer, a constraint error occurs.

*/
static int CreateInstance(FANCYCLSID clsid,
                             IEnv *pEnvironment,
                             IPrivSet *pPrivSet,
                             void **ppNewObj
                            );


}; /* end_class */

}; /* end_namespace */

/** @} */ /* end_addtogroup second_fancy_device_api */

#endif /* SAMPLEHEADERFILE2_MULTIGROUPS_C_H_ */
