#
# New File JHarrington - 01/07/2011 Revision A Version 1 for Doxygen 1.7.0
#

from __future__ import division  # necessary to make integer division work
import re                        # regular expressions
import sys
import os
import glob

# 
# This app checks for unmatched comments and alerts the user to line numbers where
# a matching comment might be expected.
# 
# It operates over all .h files in the current directory.  There are no flags.  
# Usage:
# 
#      python commentcheck.py
# 
# The output of this script is stored in a file called ../dox/comment.log.
# 

usage        = "\n\n     Usage:\n\n          python commentcheck.py "
logFile      = []
dirList      = []
opencomment  = 0 
titleborder  = "-------------------------------------------------------------------------\n"

outfile      = "../comment.log"
outmsg       = "Log file " + outfile + " written to directory above working directory."

dirList=glob.glob("*.h")

if len(dirList) < 1:
     print "\n     There are no header files in this directory." + usage
     sys.exit()

for myfile in dirList:

     # See if you can modify the file
     if not os.access(myfile, os.R_OK): 
          print "\n     " + myfile + " is not accessible.  You do not have " + \
                "permission to modify this file."
          continue
     # FILE IN Open and store file in an array (list)
     fin = open(myfile, "r")
     lineList = fin.readlines()
     fin.close()

     for i in range(0,len(lineList)): 

               if re.search("\/\*", lineList[i], re.IGNORECASE):
                    opencomment += 1

               if re.search("\*\/", lineList[i], re.IGNORECASE):
                    opencomment -= 1

               if opencomment >= 2:
                    logFile.insert(0,"ERROR!!:\n" + myfile + " is missing a  closing comment marker (*/)    at " + str(i) +"\n")
                    opencomment = 1

               if opencomment < 0:
                    logFile.insert(0,"ERROR!!:\n" + myfile + " is missing an opening comment marker (/*[*]) at " + str(i) +"\n")
                    opencomment = 0

     logFile.insert(0,titleborder)
     logFile.insert(0,"TESTING " + myfile + " missing comment markers.\n")
     logFile.insert(0,titleborder)

# If batch.log doesn't exist, add it
if not os.path.exists(outfile):
    open(outfile, "a")

# Then, if the logFile has something in it, write it
if len(logFile) > 0:
     fou = open(outfile, "a")
     for i in range(len(logFile)):
          fou.write(logFile[i])
     fou.close
     print outmsg
# Else, tell the user there was nothing
else:
     print errmsg

# Clear out logFile
logFile = []
