:: Updated - 09/22/2010 Rev C, Version 1 for use only with Doxygen 1.7.0 - same as master file
:: Updated - 01/24/2011 Rev C, Version 2 to support new IS format - includes Interface Index chapter

@echo off
::
:: Living Documents batch file
::
:: This batch runs Doxygen on the Doxy_Config.ldd file in the current directory.  
:: Then it goes into the latex directory and customizes the style file. 
:: Finally, python apps in the /dox/scripts directory are run that customize the 
:: output.  At each stage, the batch file makes sure the necessary files/directories 
:: are present. If there is any failure of these tests, one of several error messages 
:: is printed to standard out.
::
:: Commented out lines are for features that have yet to be tested.
::
:: As major updates to this batch file are made, Doxygen/LaTeX users will be 
:: notified to update their templates. If you would like to be automatically 
:: notified when any updates occur, in p4 select User/Edit <yourname> and put 
:: this line in the Reviews text box:
::
::      //depot/Living_Documents/Tools/scripts_misc/run_doxygen_pdf.bat         
::
:: For information about the Living Docs Project, go to:
::
::      http://go.qualcomm.com/livingdocs
::

:: set variables:

     set batchlog=batch.log
     set doxy=Doxy_Config.ldd
     set doxl=doxy.log
     set ladir=latex
     set scrdir=scripts
     set doxsty=doxygen.sty
     set temsty=template_doxygen.sty
     set delstat=delstat.py
     set delind=delind.py
     set interface_index=rename_module_index.py
     set interface_chap=rename_module_chap.py
::   set commentchk=commentcheck.py
::   set braceck=bracecheck.py
::   set doxval=doxval.py
::   set dellink=dellink.py
::   set delpack=delpack.py
     set fixdash=fixdash.py
     set incdir=../../inc
     set pyth=python
     set doxg=doxygen
     set pdf=refman.pdf
     set loca=in the current directory.
     set loc2=in the latex directory.
     set loc3=in the dox directory.
     set loc4=in the scripts directory.
     set warn=WARNING:
     set err=ERROR!:
     set not=NOTE: 
     set rem00=%err% You need %pyth% to run this batch file properly.
     set rem01=%err% You need %doxg% to run this batch file properly.
     set rem02=%err% There is no %doxy% file %loca%
     set rem03=%err% There is no %ladir% directory %loca%  
     set rem04=%err% There is no %doxsty% file %loc2%
     set rem05=%err% There is no %temsty% file %loc2%
     set rem06=%err% There is no %delstat% file %loca%
     set rem07=%err% There is no %delind% file %loca%
::   set rem08=%err% There is no %dellink% file %loca3%
::   set rem09=%err% There is no %delpack% file %loca3%
     set rem10=%err% The inc dir not found (both inc and dox should be parallel).
     set rem11=%err% There is no %braceck% file %loca3%
::   set rem12=%err% There is no %doxval% file %loca3%
     set rem13=%not% Doxygen standard output was written to file doxy.log.
     set rem14=%err% No doxy.log written.
     set rem15=%err% There is no %fixdash% file
     set rem16=%warn% ***************DID YOU CLOSE YOUR refman.pdf?********************
     set rem17=%err% There is no %interface_index% file %loca%
     set rem18=%err% There is no %interface_chap% file %loca%
     set rem19=%err% There is no %commentchk% file %incdir%


:: Zero out the doxygen log, if it exists
     if exist .\%doxl%               (del %doxl%)

:: Zero out the batchlog, if it exists
     if exist .\%batchlog%           (del %batchlog%)             

:: If this exists,                   (do this)                        else (warn user  )
     if exist .\%doxy%               (doxygen %doxy% 1>%doxl%)        else (echo %rem02%
                                                                            GOTO ENDME )
     if exist .\%doxl%               (echo %rem13%)                   else (echo %rem14%)
     if exist .\%ladir%              (cd %ladir%)                     else (echo %rem03%
                                                                            GOTO ENDME )
     if exist .\%doxsty%             (del %doxsty%)                   else (echo %rem04%)
     if exist .\%temsty%             (copy %temsty% %doxsty%)         else (echo %rem05%)
::
:: The 'fixdash.py' script replaces all occurrences of double dashes (--) in the tex file with
:: with an en dash.
     if exist ..\scripts\%fixdash%   (%pyth% ..\scripts\%fixdash% )   else (echo %rem15%)

::
:: The 'delstat.py' script removes the following Doxygen tags from the tex files: [static],
:: [private], [inherited], [read], [write], and [virtual].
     if exist ..\scripts\%delstat%   (%pyth% ..\scripts\%delstat%)    else (echo %rem06%)
::
:: The 'delind.py' script removes the unwanted autogenerated Doxygen index chapters from the
:: refman.tex file, such as File Index and Data Structure Index, and only leaves in the Module 
:: Index chapter. The removal of the File Documentation chapter is handled via the 
:: Doxy_Config.ldd file setting SHOW_FILES=NO.
     if exist ..\scripts\%delind%    (%pyth% ..\scripts\%delind%)     else (echo %rem07%)
::
:: The 'rename_module_index.py' script renames the "Module Index" chapter title to 
:: "Interfaces Index" chapter title and renames "Here is a list of all modules:" to 
:: "Here is a list of all interfaces:"
      if exist ..\scripts\%interface_index%    (%pyth% ..\scripts\%interface_index%)  else (echo %rem17%)
::
:: The 'rename_module_chap.py' script renames the "Module Documentation" chapter title to 
:: "Interfaces" chapter title and renames the "Modules" unnumbered heading to "Interfaces",
     if exist ..\scripts\%interface_chap%    (%pyth% ..\scripts\%interface_chap%)  else (echo %rem18%)
::
:: The 'dellink.py' script removes the autogenerated LaTeX hyperlink commands in the tex files
:: that point to the header files. 
::   if exist ..\scripts\%dellink%   (%pyth% ..\scripts\%dellink%)    else (echo %rem08%)
::
:: The 'delpack.py' script removes unwanted PACK defines from tex files.
::   if exist ..\scripts\%delpack%   (%pyth% ..\scripts\%delpack%)    else (echo %rem09%)
::     if exist %incdir%               (cd %incdir%)                    else (echo %rem10%
::                                                                         GOTO ENDME  )
:: The 'braceck.py' script checks from opening/closing block markers (@{ @}) in the header files to verify
:: that there are matching braces.
::   if exist ..\dox\scripts\%braceck% (%pyth% ..\dox\scripts\%braceck%) else (echo %rem11%)
::                                                                             GOTO ENDME  )
::   if exist %incdir%               (cd %incdir%)                    else (echo %rem10%
                                                                            GOTO ENDME  )
:: The 'commentcheck.py' script checks from opening/closing Doxygen block markers (/** */) in the 
:: header files to verify that there are matching markers.
::    if exist ..\dox\scripts\%commentchk% (%pyth% ..\dox\scripts\%commentchk%) else (echo %rem19%)
::
:: The 'doxval.py' script validates against all header files by checking for various syntax
:: errors in Doxygen commands, mainly to ensure that the latest markup standards are being
:: followed.
::   if exist ..\dox\scripts\%doxval%  (%pyth% ..\dox\scripts\%doxval%)  else (echo %rem12%)
     echo.
     if exist .\%pdf%                (echo %rem16%)                   
     echo.

GOTO ENDME
     :ENDME
PAUSE



