#include <ctype.h>
#include <libxml/HTMLparser.h>
#include <stdio.h>
#include <string.h>

int main(char** argv, int argc) {
    htmlParserCtxtPtr htmlParse;
    htmlSAXHandler* sax;

    sax = (htmlSAXHandler *) xmlMalloc(sizeof(htmlSAXHandler));
    memset(sax, 0, sizeof(htmlSAXHandler));

    FILE* f = fopen("315safe.com.html", "r");
    char buffer[65535];
    size_t r = fread(buffer, 1, 65535, f);
        
    htmlParse = 
        htmlCreatePushParserCtxt(sax, NULL,
                                 buffer, 4, NULL,
                                 XML_CHAR_ENCODING_UTF8);

    htmlCtxtUseOptions(htmlParse,
                       HTML_PARSE_RECOVER | HTML_PARSE_NOBLANKS | 
                       HTML_PARSE_NONET
                       /* | HTML_PARSE_NOERROR | HTML_PARSE_NOWARNING */);

    size_t cur = 4;
    while (cur < r) {
        size_t tor = 8192;
        if (tor > (r-cur))
            tor = r-cur;

        htmlParseChunk(htmlParse,
                       buffer+cur, tor, 0);
        cur += tor;
    }

    htmlParseChunk(htmlParse,
                   NULL, 0, 1);

    htmlFreeParserCtxt(htmlParse);
    xmlFree(sax);
}

