/*-----------------------------------------------------------
 *                   COPYRIGHT (C) 2010.
 *          GN Otometrics. All rights reserved.
 *-----------------------------------------------------------
 *            P R O P R I E T A R Y   R I G H T S
 * This document must not be used, nor copied in any form or
 * handed over to third party, without prior written
 * permission from GN Otometrics.
 *-----------------------------------------------------------
 *
 * This source file is part of the 1081 SPARC T2 project.
 *
 * P4 Info: (P4-filetype must be "ktext" for these to work!)
 * Last edit by: $Author: pohansen $
 * Date:         $DateTime: 2010/04/29 13:56:52 $
 * Filename:     $File: //depot/1081/fw/head/dsp/main/src/appl/globaltypes.c $
 * Revision:     $Revision: #4 $
 *
 * File Info:
 * Original author: MEGHOLM
 * Creation date: 2010-02-15
 *
 * Doxygen Info: *//*!
 * @file
 * @brief   Routines used in relation with the global types defined in the header-file - e.g conversion routines.\n
 *
 * *//*
 *-----------------------------------------------------------*/

#include "cygwin.h"
#include "../system/api/GlobalDefs.h"
#include "defines.h"
#include "globaltypes.h"

#include "transducer.h"


/*! @brief Converts the given socket to the corresponding e_socket_type
 *
 */
e_socket_type convert_phy_soc_2_socket_type(e_phy_soc index)
{
	// Make sure we have a one to between "e_phy_soc" and "e_transducer_calib_save_index", else generate a compile error
	enum {	chk2 = 10 / ((SOCKET_ACLF_L == (e_phy_soc)0) ? 1 : 0),
			chk3 = 10 / ((SOCKET_ACLF_R == (e_phy_soc)1) ? 1 : 0),
			chk4 = 10 / ((SOCKET_ACIN_L == (e_phy_soc)2) ? 1 : 0),
			chk5 = 10 / ((SOCKET_ACIN_R == (e_phy_soc)3) ? 1 : 0),
			chk6 = 10 / ((SOCKET_BONE   == (e_phy_soc)4) ? 1 : 0),
			chk7 = 10 / ((SOCKET_FF_N1  == (e_phy_soc)5) ? 1 : 0),
			chk8 = 10 / ((SOCKET_FF_N2  == (e_phy_soc)6) ? 1 : 0),
			chk9 = 10 / ((SOCKET_FF_N3  == (e_phy_soc)7) ? 1 : 0)
	};

	static const e_socket_type socket_type[] =
	{
		ACLF_TYPE,	// SOCKET_ACLF_L =  0 : Air Conduction Low Frequency Left socket
		ACLF_TYPE,	// SOCKET_ACLF_R =  1 : Air Conduction Low Frequency Right socket
		ACIN_TYPE,	// SOCKET_ACIN_L =  2 : Air Conduction Insert phone Left socket (left stereo and mono)
		ACIN_TYPE,	// SOCKET_ACIN_R =  3 : Air Conduction Insert phone Right socket
		BC_TYPE,	// SOCKET_BONE   =  4 : Bone Conduction Mastoid socket
		FF_TYPE,	// SOCKET_FF_N1  =  5 : Free Field Number 1 (Left)
		FF_TYPE,	// SOCKET_FF_N2  =  6 : Free Field Number 2 (Right)
		FF_TYPE		// SOCKET_FF_N3  =  7 : Free Field Number 3
	};
	if ((index < SOCKET_ACLF_L) || (index > SOCKET_FF_N3))
		return NONE_TYPE;

	return socket_type[index];
}


/*! @brief Converts the given socket to the corresponding enum to be used when looking up calibration data from the EEPROM
 * for the socket in question.
 */
e_transducer_calib_save_index convert_socket_2_calib_enum( e_phy_soc socket )
{
	// Make sure we have a one to between "e_phy_soc" and "e_transducer_calib_save_index", else generate a compile error
	enum {	chk1 = 10 / ((SOCKET_NONE   == (e_phy_soc)SAVE_CAL_NONE)   ? 1 : 0),
			chk2 = 10 / ((SOCKET_ACLF_L == (e_phy_soc)SAVE_CAL_ACLF_L) ? 1 : 0),
			chk3 = 10 / ((SOCKET_ACLF_R == (e_phy_soc)SAVE_CAL_ACLF_R) ? 1 : 0),
			chk4 = 10 / ((SOCKET_ACIN_L == (e_phy_soc)SAVE_CAL_ACIN_L) ? 1 : 0),
			chk5 = 10 / ((SOCKET_ACIN_R == (e_phy_soc)SAVE_CAL_ACIN_R) ? 1 : 0),
			chk6 = 10 / ((SOCKET_BONE   == (e_phy_soc)SAVE_CAL_BONE)   ? 1 : 0),
			chk7 = 10 / ((SOCKET_FF_N1  == (e_phy_soc)SAVE_CAL_FF_N1)  ? 1 : 0),
			chk8 = 10 / ((SOCKET_FF_N2  == (e_phy_soc)SAVE_CAL_FF_N2)  ? 1 : 0),
			chk9 = 10 / ((SOCKET_FF_N3  == (e_phy_soc)SAVE_CAL_FF_N3)  ? 1 : 0)
	};
	if (socket > SOCKET_FF_N3)
		return SAVE_CAL_NONE;

	return (e_transducer_calib_save_index) socket;
} // convert_socket_2_calib_enum


/*! @brief Converts the given socket to the corresponding enum to be used when looking up RETSPL/ML values from the EEPROM.
 *
 * That is, any left/right'ness is mapped out.
 */
e_transducer_ret_calib_save_index convert_socket_2_retspl_calib_enum( e_phy_soc socket )
{
	switch( socket )
	{
	case SOCKET_ACLF_L:
	case SOCKET_ACLF_R:
		return SAVE_RET_ACLF;

	case SOCKET_ACIN_L:
	case SOCKET_ACIN_R:
		return SAVE_RET_ACIN;

	case SOCKET_BONE:
		return SAVE_RET_BONE;

	case SOCKET_FF_N1:
		return SAVE_RET_FF_N1;

	case SOCKET_FF_N2:
		return SAVE_RET_FF_N2;

	case SOCKET_FF_N3:
		return SAVE_RET_FF_N3;

	case SOCKET_NONE:
	default:
		return SAVE_RET_NONE;
	};
} // convert_socket_2_retspl_calib_enum


e_phy_soc convert_e_transducer_ret_calib_save_index_2_e_phy_soc(e_transducer_ret_calib_save_index index)
{
	switch(index)
	{
		case SAVE_RET_ACLF:
			return SOCKET_ACLF_L;
		case SAVE_RET_ACIN:
			return SOCKET_ACIN_L;
		case SAVE_RET_BONE:
			return SOCKET_BONE;
		case SAVE_RET_FF_N1:
			return SOCKET_FF_N1;
		case SAVE_RET_FF_N2:
			return SOCKET_FF_N2;
		case SAVE_RET_FF_N3:
			return SOCKET_FF_N3;

		// 	SAVE_RET_NONE
		// SAVE_RET_MASK_OFFS
		default:
			return SOCKET_NONE;
	}
}


/*! @brief convert from @ref e_ch_transducer to @ref e_phy_soc_id
 *
 */
e_phy_soc map_e_ch_transducer_2_e_phy_soc_id(const enum e_Route route_lr, const e_socket_type socket)
{
	switch(socket)
	{
		case ACLF_TYPE:
					return (route_lr == ROUTE_LEFT) ?  SOCKET_ACLF_L : SOCKET_ACLF_R;
		case ACIN_TYPE:
		    		if (Insert_Mono_Only())
						return SOCKET_ACIN_L;
					else
						return (route_lr == ROUTE_LEFT) ? SOCKET_ACIN_L : SOCKET_ACIN_R;
		case BC_TYPE:
					return SOCKET_BONE;
		case FF_TYPE:
					return (route_lr == ROUTE_LEFT) ? SOCKET_FF_N1 : SOCKET_FF_N2;
		default:
			return SOCKET_NONE;
	}
}

