/**************************************************************************//**
 *	\file	adc_Cfg.h
 *
 *	\brief	This file provides all the configurations provided by ADC module 
 *			of Freescale MPC563 power-pc MCU
 *
 *	\version	1.0A - Initial Draft
 *	\date		25 June 2010
 *
 *	\version	1.1A - Design changed to support run-time CCW addition and 
 *						configuration
 *	\date		16 July 2010
 *****************************************************************************/
#ifndef ADC_CFG_H 
#define ADC_CFG_H 
/******************************************************************************
Include Files
******************************************************************************/

/******************************************************************************
Type defines
******************************************************************************/

/***************************************************************************
************* QADCMCR - Module Configuration Register settings *************
****************************************************************************/
/** \defgroup	QADCMCR_REG_SETTINGS	QADCMCR register settings */ /*@{*/
/**	\brief	This macro defines the value for disabling the ADC stop mode */
#define ADC_DISABLE_STOP_MODE 	0
/**	\brief	This macro defines the value for enabling the ADC stop mode */
#define ADC_ENABLE_STOP_MODE	1

/**	\brief	This macro defines the value for ignoring the freeze commands 
			provided in CCWs */
#define ADC_IGNORE_FREEZE	0
/**	\brief	This macro defines the value for enabling the freeze commands 
			provided in CCWs */
#define ADC_ENABLE_FREEZE	1

/**	\brief	This macro defines the value for locking the ADC mode of operation.
			This prevents accidental change in mode of operation */
#define ADC_MODE_LOCK_ENABLE	0
/**	\brief	This macro defines the value for unlocking the ADC mode of operation.
			This will enable change in mode of operation */
#define ADC_MODE_LOCK_DISABLE	1

/*@}*/

/***************************************************************************
******************** QADCINT - Interrupt Register **************************
****************************************************************************/
/**	\defgroup	QADCINT_REG_SETTINGS	QADCINT register settings */ /*@{*/
/**	\brief	This macro used to develop the QADCINT reg value by grouping all 
			the different field values */
#define ADC_INT_PRIO(Q1Prio,Q2Prio)	((((U16)(Q2Prio)) << 5) | (Q1Prio))
/*@}*/

/***************************************************************************
****************************** QACR1 - Control Reg-1 ***********************
****************************************************************************/
/**	\defgroup	QACR1_REG_SETTINGS	QACR1 register settings */ /*@{*/
/* Queue-1 Completion interrupt enable */
/**	\brief	This macro used to disable completion interrupt for Queue-1 */
#define ADC_Q1_COMP_INT_DISABLE	0
/**	\brief	This macro used to enable completion interrupt for Queue-1 */
#define ADC_Q1_COMP_INT_ENABLE	1

/* Queue-1 Pause interrupt enable */
/**	\brief	This macro used to disable pause interrupt for Queue-1 */
#define ADC_Q1_PAUSE_INT_DISABLE	0
/**	\brief	This macro used to enable pause interrupt for Queue-1 */
#define ADC_Q1_PAUSE_INT_ENABLE		1

/*@}*/
/***************************************************************************
******************************** QACR2 - Control Reg-2 *********************
****************************************************************************/
/**	\defgroup	QACR2_REG_SETTINGS	QACR2 register settings */ /*@{*/
/* Queue-2 Completion interrupt enable */
/**	\brief	This macro used to disable completion interrupt for Queue-2 */
#define ADC_Q2_COMP_INT_DISABLE	0
/**	\brief	This macro used to enable completion interrupt for Queue-2 */
#define ADC_Q2_COMP_INT_ENABLE	1

/* Queue-2 Pause interrupt enable */
/**	\brief	This macro used to disable pause interrupt for Queue-2 */
#define ADC_Q2_PAUSE_INT_DISABLE	0
/**	\brief	This macro used to enable pause interrupt for Queue-2 */
#define ADC_Q2_PAUSE_INT_ENABLE		1

/*@}*/

/**	\brief	This macro defines the total no.of CCWs available in 
			each ADC converter module */
#define ADC_TOT_CCW	64

/**	\brief	This defines the address for the ADC converter module A register 
			group */
#define QADC_MOD_A   (( struct QADC64_tag *) (INTERNAL_MEMORY_BASE + 0x304800))
/**	\brief	This defines the address for the ADC converter module B register 
			group */
#define QADC_MOD_B   (( struct QADC64_tag *) (INTERNAL_MEMORY_BASE + 0x304C00))

#endif