$! BUILD_LIBXML.COM
$!
$! Build the LIBXML library
$!
$! Arguments:
$!
$!  P1 is a comma-seperated list of parameters
$!      DEBUG           enables debugging (implies LIST)
$!      LIST		generates listings
$!      RESET           if you've moved the sources, this clears dangling logical names
$!
$! This procedure creates an object library XML_LIBDIR:LIBXML.OLB directory.  
$! After the library is built, you can link LIBXML routines into
$! your code with the command  
$!
$!	$ LINK your_modules,XML_LIBDIR:LIBXML.OLB/LIBRARY
$! 
$! Change History
$! --------------
$! Command file author : John A Fotheringham (jaf@jafsoft.com)
$! Update history      : 13 October 2003	Craig Berry (craigberry@mac.com)
$!			 more new module additions
$!                     : 25 April 2003		Craig Berry (craigberry@mac.com)
$!			 added xmlreader.c and relaxng.c to source list
$! 		       : 28 September 2002	Craig Berry (craigberry@mac.com)
$!			 updated to work with current sources
$!			 miscellaneous enhancements to build process
$! 		       : 03 August 2005		Stephen Hoffman (hoff-at_sign-hp-dot-com)
$!                       updates for LIBXML2-2.6.20; various modules added.
$!                       added auto-creation of example startup procedure.
$!			 Move the compiler listings into libxml2_lis:; into a listing
$!                       subdirectory.  Add directory /VERSION_LIMIT.
$!                       Tweaked the error- and the list-handling code
$!                       Tweaked procedure API, and documented it.
$! 		       : 20 March 2006		Stephen Hoffman (hoff-at_sign-hp-dot-com)
$!                       updates for LIBXML2-2.6.23; various modules added.
$!                       Incorporate feedback on __CRTL_VER handling.
$!			 Various updates to debugging and diagnostics.
$!                     : 07 June 2006           Stephen Hoffman (hoff-at_sign-hp-dot-com)
$!                       Clean up some of the code here for LIBXML2-2.6.24, including
$!                       older versions of config.h.  Reference the LIBXML2_STARTUP.COM 
$!                       use and r-use within the generated output, if and as applicable.
$!                     : 04 August 2010         Stephen Hoffman (info-at_sign-hoffmanlabs-dot-com)
$!                       Updates for building libxml2 2.7.7 on OpenVMS V8.4.  Add RESET logic
$!                       to clean up detritus from previous builds or directory relocations.
$!                       Add LIBXML2_LOGIN.COM, and tweak generated LIBXML2_STARTUP.COM code.
$!
$!- configuration -------------------------------------------------------------
$!
$!-
$!
$   cc_opts = "/NAMES=(SHORTENED)/FLOAT=IEEE/IEEE_MODE=DENORM_RESULTS /FIRST_INCLUDE=[.VMS]VMS.H"
$   arch_name = f$getsyi("ARCH_NAME")
$   whoami = f$environment("PROCEDURE")
$   procdir = f$parse(whoami,,,"DIRECTORY") - ">[" - "><" - "]<" - "][" - "<" - "[" - ">" - "]"
$   procdir = "[" + procdir + "]"
$   procdev = f$parse(whoami,,,"DEVICE")
$   procdevdir = procdev + procdir
$!
$   if f$locate(",DEBUG,", ",''p1',") .ne. f$length(",''p1',")
$   then
$     debug_flag = "Y"
$     cc_command = "CC''cc_opts'/DEBUG/NOOPTIMIZE"
$   else
$     debug_flag = "N"
$     cc_command = "CC''cc_opts'"
$   endif
$   if f$locate(",LIST,", ",''p1',") .ne. f$length(",''p1',") .or. debug_flag
$   then
$     cc_command = cc_command + "/LIST=libxml2_lis:"
$   endif
$   if f$locate(",FULL,", ",''p1',") .ne. f$length(",''p1',")
$   then
$     cc_command = cc_command + "/SHOW=ALL"
$   endif
$   if f$locate(",RESET,", ",''p1',") .ne. f$length(",''p1',")
$   then
$	! clean up any detritus from previous builds.
$	if f$trnlnm("LIBXML") then deassign LIBXML
$       if f$trnlnm("XML_LIBDIR") then deassign XML_LIBDIR
$       if f$trnlnm("XML_SRCDIR") then deassign XML_SRCDIR
$       if f$search("XML_LIBDIR:LIBXML.OLB") .nes. "" then delete XML_LIBDIR:LIBXML.OLB;*
$       if f$search("[.vms]LIBXML2_STARTUP.COM") .nes. "" then delete [.vms]LIBXML2_STARTUP.COM;*
$       if f$search("[.vms]LIBXML2_LOGIN.COM") .nes. "" then delete [.vms]LIBXML2_LOGIN.COM;*
$       if f$search("[.''arch_name'_obj]*.*") .nes. "" then delete [.'arch_name'_obj]*.*;*
$       if f$search("[.''arch_name'_lis]*.*") .nes. "" then delete [.'arch_name'_lis]*.*;*
$       write sys$output "Reset complete.  Invoke @''whoami'"
$       exit
$   endif
$!
$!- list of sources to be built into the LIBXML library.  Compare this list
$!  to the definition of "libxml2_la_SOURCES" in the file MAKEFILE.IN.
$!  Currently this definition includes the list WITH_TRIO_SOURCES_TRUE
$!  Specifically in 2.6.20, see "@WITH_TRIO_SOURCES_TRUE@libxml2_la_SOURCES =..."
$!
$   sources =           " SAX.c entities.c encoding.c error.c parserInternals.c"
$   sources = sources + " parser.c tree.c hash.c list.c xmlIO.c xmlmemory.c uri.c"
$   sources = sources + " valid.c xlink.c HTMLparser.c HTMLtree.c debugXML.c xpath.c"
$   sources = sources + " xpointer.c xinclude.c nanohttp.c nanoftp.c DOCBparser.c"
$   sources = sources + " catalog.c globals.c threads.c c14n.c xmlstring.c"
$   sources = sources + " xmlregexp.c xmlschemas.c xmlschemastypes.c xmlunicode.c"
$   sources = sources + " xmlreader.c relaxng.c dict.c SAX2.c xmlwriter.c legacy.c"
$   sources = sources + " chvalid.c pattern.c xmlsave.c xmlmodule.c schematron.c"
$   sources = sources + " triostr.c trio.c "
$
$!
$!- list of main modules to compile and link.  Compare this list to the
$!  definition of bin_PROGRAMS in MAKEFILE.IN
$!
$   bin_progs = " xmllint xmlcatalog"
$!
$!- list of test modules to compile and link.  Compare this list to the
$!  definition of noinst_PROGRAMS in MAKEFILE.
$!
$   noinst_PROGRAMS =                   " testSchemas testRelax"
$   noinst_PROGRAMS = noinst_PROGRAMS + " testSAX testHTML testXPath"
$   noinst_PROGRAMS = noinst_PROGRAMS + " testURI testThreads testC14N"
$   noinst_PROGRAMS = noinst_PROGRAMS + " testAutomata testRegexp testReader"
$   noinst_PROGRAMS = noinst_PROGRAMS + " testapi testModule runtest"
$   noinst_PROGRAMS = noinst_PROGRAMS + " runsuite testchar testdict"
$   noinst_PROGRAMS = noinst_PROGRAMS + " runxmlconf testrecurse"
$   noinst_PROGRAMS = noinst_PROGRAMS + " testregexp"

$!
$!- set up build logicals -----------------------------------------------------\
$!
$!
$!- start from where the procedure is in case it's submitted in batch ----------\
$!
$   saved_default = f$environment("default")
$   set default 'procdevdir'
$!
$   if f$trnlnm("XML_LIBDIR") .eqs. ""
$   then
$     if f$search("[-]''arch_name'_lib.dir") .eqs. ""
$     then
$       create/directory/log [-.'arch_name'_lib]
$     endif
$     xml_libdir = f$parse("[-.''arch_name'_lib]",,,"DEVICE") + f$parse("[-.''arch_name'_lib]",,,"DIRECTORY")  - ">[" - "><" - "]<" - "]["
$     define/process/nolog XML_LIBDIR 'xml_libdir'
$     write sys$output "Defining XML_LIBDIR as """ + f$trnlnm("XML_LIBDIR") + """
$     define/process/nolog XML_LIBDIR 'xml_libdir'
$   else
$     xml_libdir = f$trnlnm("XML_LIBDIR")
$     write sys$output " "
$     write sys$output "Using existing XML_LIBDIR: ""''xml_libdir'"" "
$     write sys$output "  If the build should fail, invoke this procedure with RESET and try again."
$     write sys$output "    @''whoami' RESET"
$     write sys$output " "
$   endif
$!
$   if f$trnlnm("XML_SRCDIR") .eqs. ""
$   then
$     globfile = f$search("[-...]globals.c")
$     if globfile .eqs. ""
$     then
$	write sys$output "Can't locate globals.c.  You need to manually define a XML_SRCDIR logical"
$       set default 'saved_default'
$	exit
$     else
$	srcdir = f$parse(globfile,,,"DEVICE") + f$parse(globfile,,,"DIRECTORY") - ">[" - "><" - "]<" - "]["
$	define/process/nolog XML_SRCDIR "''srcdir'"
$       write sys$output "Defining XML_SRCDIR as ""''srcdir'"""
$     endif
$   else
$     srcdir = f$trnlnm("XML_SRCDIR")
$   endif
$!
$   if f$search("xml_srcdir:config.h") .nes. "" then $ delete/nolog xml_srcdir:config.h;*
$   copy/log config.vms xml_srcdir:config.h
$!
$   if f$trnlnm("libxml") .eqs. "" 
$   then 
$     globfile = f$search("[-...]globals.h")
$     if globfile .eqs. ""
$     then
$	write sys$output "Can't locate globals.h.  You need to manually define a LIBXML logical"
$       set default 'saved_default'
$	exit
$     else
$	includedir = f$parse(globfile,,,"DEVICE") + f$parse(globfile,,,"DIRECTORY") - ">[" - "><" - "]<" - "]["
$	define/process/nolog libxml "''includedir'"
$       write sys$output "Defining libxml as ""''includedir'"""
$     endif
$   else
$     includedir = f$trnlnm("libxml")
$   endif
$
$   write sys$output " "
$   if f$search("''procdir'LIBXML2_STARTUP.COM") .eqs. ""
$   then
$     close/nolog x
$     open/write x 'procdir'LIBXML2_STARTUP.COM 
$     write x "$! Example LIBXML2 startup procedure."
$     write x "$! Can be called from SYSTARTUP_VMS.COM."
$     write x "$! Automatically created by BUILD_LIBXML.COM"
$     write x "$ Define/System/Executive XML_LIBDIR ''xml_libdir'"
$     write x "$ Define/System/Executive XML_SRCDIR ''srcdir'"
$     write x "$ Define/System/Executive LIBXML     ''includedir'"
$     write x "$ exit"
$     close/nolog x
$     write sys$output "Example ''procdir'LIBXML2_STARTUP.COM created."
$   else
$     write sys$output "Using existing ''procdir'LIBXML2_STARTUP.COM startup procedure."
$   endif
$   write sys$output "Modify and add this procedure to SYSTARTUP_VMS.COM, as required."
$   write sys$output " "
$   write sys$output " "
$   if f$search("''procdir'LIBXML2_LOGIN.COM") .eqs. ""
$   then
$     close/nolog x
$     open/write x 'procdir'LIBXML2_LOGIN.COM 
$     write x "$! Example LIBXML2 login procedure."
$     write x "$! Can be called from LOGIN.COM, SYLOGIN.COM or from"
$     write x "$! whatever DCL sets up your LIBXML2-based environment."
$     write x "$! Automatically created by BUILD_LIBXML.COM"
$     write x "$"
$     write x "$! We're (now) ODS-5 now.  Also required for self-tests."
$     write x "$!"
$     write x "$ Set Process /Parse=Extended"
$     write x "$"
$     write x "$! The following enable Unix-like parsing via the C RTL."
$     write x "$! Also required for the self-tests."
$     write x "$!"
$     write x "$ Define DECC$ARGV_PARSE_STYLE            ENABLE"
$     write x "$ Define DECC$EFS_CASE_PRESERVE           ENABLE"
$     write x "$ Define DECC$EFS_CHARSET                 ENABLE"
$     write x "$"
$     write x "$! The following are for performance..."
$     write x "$!"
$!     write x "$ Define DECC$ENABLE_GETENV_CACHE         ENABLE"
$!     write x "$ Define DECC$ENABLE_TO_VMS_LOGNAME_CACHE ENABLE"
$     write x "$ exit"
$     close/nolog x
$     write sys$output "Example ''procdir'LIBXML2_LOGIN.COM created."
$   else
$     write sys$output "Using existing ''procdir'LIBXML2_LOGIN.COM login procedure."
$   endif
$   write sys$output "Modify and add this procedure to LOGIN.COM or SYLOGIN.COM or"
$   write sys$output "into the DCL that invokes your particular libxml2-based tool."
$   write sys$output " "
$!
$!- set up error handling (such as it is) -------------------------------------
$!
$ exit_status = 1
$ on error then goto ERROR_OUT 
$ on control_y then goto CTRLY_OUT 
$!
$!- move to the source directory and create any necessary subdirs and the 
$!  object library
$!
$ set default xml_srcdir
$ if f$search("''arch_name'_OBJ.DIR") .eqs. "" then create/directory [.'arch_name'_OBJ] /version=5/prot=(s:rwed,o:rwed)
$ if f$search("''arch_name'_OBJ_DEBUG.DIR") .eqs. "" then create/directory [.'arch_name'_OBJ_DEBUG] /version=5/prot=(s:rwed,o:rwed)
$ if f$search("''arch_name'_LIS.DIR") .eqs. "" then create/directory [.'arch_name'_LIS] /version=5/prot=(s:rwed,o:rwed)
$ define/nolog libxml2_dbg [.'arch_name'_OBJ_DEBUG]
$ define/nolog libxml2_obj [.'arch_name'_OBJ]
$ define/nolog libxml2_lis [.'arch_name'_LIS]
$ if debug_flag
$ then
$   define/nolog libxml2_bld [.'arch_name'_OBJ_DEBUG]
$ else
$   define/nolog libxml2_bld [.'arch_name'_OBJ]
$ endif
$ if f$search("XML_LIBDIR:LIBXML.OLB") .eqs. "" 
$ then 
$   write sys$output "Creating new object library XML_LIBDIR:LIBXML.OLB"
$   library/create/object XML_LIBDIR:LIBXML.OLB
$ endif
$!
$ goto start_here
$ start_here:	  ! move this line to debug/rerun parts of this command file
$!
$!- compile modules into the library ------------------------------------------
$!
$ lib_command   = "LIBRARY/REPLACE/OBJECT XML_LIBDIR:LIBXML.OLB"
$ link_command	= ""
$!
$ write sys$output ""
$ write sys$output "Building modules into the LIBXML object library"
$ write sys$output ""
$!
$ index = 0
$ sources = f$edit(sources,"COMPRESS,TRIM")
$!
$ source_loop:
$!
$   next_source = f$edit(f$element( index," ",sources),"COLLAPSE,TRIM")
$   if f$length(next_source) .ne. 0
$   then
$!
$     on error then goto ERROR_OUT 
$     on control_y then goto CTRLY_OUT 
$     call build 'next_source'
$     index = index + 1
$     goto source_loop
$!
$   endif
$!
$!- now build self-test programs ----------------------------------------------
$!
$! these programs are built as ordinary modules into XML_LIBDIR:LIBXML.OLB.  Here they
$! are built a second time with /DEFINE=(STANDALONE) in which case a main()
$! is also compiled into the module
$ 
$ lib_command	= ""
$ link_command	= "LINK"
$!
$!$ library/compress XML_LIBDIR:LIBXML.OLB
$!$ purge XML_LIBDIR:LIBXML.OLB
$!
$ write sys$output ""
$ write sys$output "Building STANDALONE self-test programs"
$ write sys$output ""
$!
$ call build NANOFTP.C	/DEFINE=(STANDALONE)
$ call build NANOHTTP.C	/DEFINE=(STANDALONE)
$ call build TRIONAN.C	/DEFINE=(STANDALONE)
$!
$!- now build main and test programs ------------------------------------------
$!
$!
$ lib_command	= ""
$ link_command	= "LINK"
$!
$ write sys$output ""
$ write sys$output "Building main programs and test programs"
$ write sys$output ""
$!
$ index = 0
$ all_progs = bin_progs + " " + noinst_PROGRAMS
$ all_progs = f$edit(all_progs,"COMPRESS,TRIM")
$!
$ prog_loop:
$!
$   next_prog = f$edit(f$element( index," ",all_progs),"COLLAPSE,TRIM")
$   if f$length(next_prog) .ne. 0
$   then
$!
$     on error then goto ERROR_OUT 
$     on control_y then goto CTRLY_OUT 
$     call build 'next_prog'.c
$     index = index + 1
$     goto prog_loop
$!
$   endif
$!
$!- Th-th-th-th-th-that's all folks! ------------------------------------------
$!
$ goto exit_here ! move this line to avoid parts of this command file
$ exit_here:	  
$!
$ goto exit_out
$!
$!
$EXIT_OUT:
$!
$ write sys$output " "
$ write sys$output "Performing clean-up..."
$ write sys$output " "
$ if f$search("xml_srcdir:config.h.-1") .nes. "" then $ purge/nolog xml_srcdir:config.h
$ if f$search("libxml2_obj:*.*.-1") .nes. "" then $ purge/nolog libxml2_obj:*.*
$ if f$search("libxml2_dbg:*.*.-1") .nes. "" then $ purge/nolog libxml2_dbg:*.*
$ if f$search("libxml2_lis:*.*.-1") .nes. "" then $ purge/nolog libxml2_lis:*.*
$ write sys$output "Exiting."
$ write sys$output " "
$ set default 'saved_default'
$ exit 'exit_status
$!
$
$CTRLY_OUT:
$ exit_status = 44 ! SS$_ABORT
$ write sys$output "CTRL/Y or CTRL/C detected; aborting operations"
$ goto EXIT_OUT
$
$ERROR_OUT:
$ exit_status = $status
$ if f$integer(exit_status) .eq. 44 then goto CTRLY_OUT
$ write sys$output "''f$message(exit_status)'"
$ goto EXIT_OUT
$!
$!- the BUILD subroutine.  Compile then insert into library or link as required
$!
$BUILD: subroutine
$   on warning then goto EXIT_BUILD
$   on control_y then goto EXIT_CTRLY
$   source_file = p1
$   name = f$parse(source_file,,,"NAME")
$   object_file = f$parse("libxml2_bld:.OBJ",name,,,"SYNTAX_ONLY")
$   image_file = f$parse("libxml2_bld:.EXE",name,,,"SYNTAX_ONLY")
$!
$!- compile
$!
$   write sys$output "$ ''cc_command ''p2' -"
$   write sys$output "    /object=''object_file' ''source_file'"
$   cc_command /object='object_file 'p2' 'source_file'
$   write sys$output " "
$!
$!- insert into library if command defined
$!
$   if lib_command .nes. ""  then lib_command 'object_file'
$!
$!- link module if command defined
$   if link_command .nes. "" 
$   then
$	opts = ""
$	if debug_flag then opts = "/DEBUG"
$	write sys$output "$ ''link_command' ''opts' -"
$	write sys$output "    ''object_file', -"
$	write sys$output "    XML_LIBDIR:libxml.olb/library -"
$	write sys$output "    /execut=''image_file'"
$	link_command'opts' 'object_file',-
                XML_LIBDIR:libxml.olb/library -
                /execut='image_file'
$	write sys$output " "
$   endif
$!
$EXIT_BUILD:
$   exit $status
$!
$EXIT_CTRLY:
$   exit 44  ! (SS$_ABORT)
$!
$endsubroutine
