
#ifndef _cfe_tbl_
#define _cfe_tbl_
/*****************************************************************************/
/**
** \brief Load a specified table with data from specified source
**
** \param[in] TblHandle  Handle, previously obtained from #CFE_TBL_Register or #CFE_TBL_Share, that
**                       identifies the Table to be loaded.
**
** \param[in] SrcType    Flag indicating the nature of the given \c SrcDataPtr below.
**                       This value can be any one of the following:
**                          \arg #CFE_TBL_SRC_FILE    - \copydoc CFE_TBL_SRC_FILE
**                          \arg #CFE_TBL_SRC_ADDRESS - \copydoc CFE_TBL_SRC_ADDRESS 
**                                                      
** \param[in] SrcDataPtr Pointer to either a character string specifying a filename or
**                       a memory address of a block of binary data to be loaded into a table or,
**                       if the table was registered with the #CFE_TBL_OPT_USR_DEF_ADDR option,
**                       the address of the active table buffer.
**
** \returns
** \retcode #CFE_SUCCESS                   \retdesc \copydoc CFE_SUCCESS                   \endcode
** \retcode #CFE_TBL_WARN_SHORT_FILE       \retdesc \copydoc CFE_TBL_WARN_SHORT_FILE       \endcode
** \retcode #CFE_TBL_WARN_PARTIAL_LOAD     \retdesc \copydoc CFE_TBL_WARN_PARTIAL_LOAD     \endcode
** \retcode #CFE_TBL_ERR_BAD_APP_ID        \retdesc \copydoc CFE_TBL_ERR_BAD_APP_ID        \endcode
** \retcode #CFE_TBL_ERR_NO_ACCESS         \retdesc \copydoc CFE_TBL_ERR_NO_ACCESS         \endcode
** \retcode #CFE_TBL_ERR_INVALID_HANDLE    \retdesc \copydoc CFE_TBL_ERR_INVALID_HANDLE    \endcode
** \retcode #CFE_TBL_ERR_DUMP_ONLY         \retdesc \copydoc CFE_TBL_ERR_DUMP_ONLY         \endcode
** \retcode #CFE_TBL_ERR_ILLEGAL_SRC_TYPE  \retdesc \copydoc CFE_TBL_ERR_ILLEGAL_SRC_TYPE  \endcode
** \retcode #CFE_TBL_ERR_LOAD_IN_PROGRESS  \retdesc \copydoc CFE_TBL_ERR_LOAD_IN_PROGRESS  \endcode
** \retcode #CFE_TBL_ERR_NO_BUFFER_AVAIL   \retdesc \copydoc CFE_TBL_ERR_NO_BUFFER_AVAIL   \endcode
** \retcode #CFE_TBL_ERR_FILE_NOT_FOUND    \retdesc \copydoc CFE_TBL_ERR_FILE_NOT_FOUND    \endcode
** \retcode #CFE_TBL_ERR_FILE_TOO_LARGE    \retdesc \copydoc CFE_TBL_ERR_FILE_TOO_LARGE    \endcode
** \retcode #CFE_TBL_ERR_BAD_CONTENT_ID    \retdesc \copydoc CFE_TBL_ERR_BAD_CONTENT_ID    \endcode
** \retcode #CFE_TBL_ERR_PARTIAL_LOAD      \retdesc \copydoc CFE_TBL_ERR_PARTIAL_LOAD      \endcode
** \endreturns
**
**
******************************************************************************/
int32 CFE_TBL_Load( CFE_TBL_Handle_t TblHandle,
                    CFE_TBL_SrcEnum_t SrcType,
                    const void *SrcDataPtr );

 
#endif  /* _cfe_tbl_ */
