#ifndef _cfe_error_
#define _cfe_error_

/*
************* COMMON STATUS CODE *************
*/

/**
**  Operation was performed successfully
*/
#define CFE_SUCCESS              (0L)

/*
************* TABLE SERVICES STATUS CODES *************
*/

/**
**  The calling Application attempted to pass a
**  Table handle that represented too large an index or
**  identified a Table Access Descriptor that was not used.
**
*/
#define CFE_TBL_ERR_INVALID_HANDLE (int32)(0xcc000001L)

/** 
**  The calling Application attempted to register a table whose
**  name length exceeded the platform configuration value of
**  #CFE_TBL_MAX_NAME_LENGTH or was zero characters long.
**
*/
#define CFE_TBL_ERR_INVALID_NAME (int32)(0xcc000002L)

/**
**  The calling Application attempted to register a table:
**    a) that was a double buffered table with size greater than #CFE_TBL_MAX_DBL_TABLE_SIZE
**    b) that was a single buffered table with size greater than #CFE_TBL_MAX_SNGL_TABLE_SIZE
**    c) that had a size of zero
**
*/
#define CFE_TBL_ERR_INVALID_SIZE (int32)(0xcc000003L)

/**
**   The calling Application has identified a table that has a load pending.
**
*/
#define CFE_TBL_INFO_UPDATE_PENDING (int32)(0x4c000004L)

/**
**  This is an error indicating that the table has never been loaded from
**  either a file or a copy from a block of memory so the contents that the
**  returned pointer is pointing to are zeros.
**  <B> NOTE: Unlike other most other errors, this error condition still
**  returns a valid table pointer.  This pointer must be released with the
**  #CFE_TBL_ReleaseAddress API before the table can be loaded with data. </B>
**
*/
#define CFE_TBL_ERR_NEVER_LOADED (int32)(0xcc000005L)

/**
**  An application attempted to create a table and the Table
**  registry already contained #CFE_TBL_MAX_NUM_TABLES in it.
**
*/
#define CFE_TBL_ERR_REGISTRY_FULL (int32)(0xcc000006L)

/**
**  This is an error that the registration is trying to replace
**  an existing table with the same name.  The previous table 
**  stays in place and the new table is rejected.
**
*/
#define CFE_TBL_WARN_DUPLICATE (int32)(0x4c000007L)

/**
**   The calling application either failed when calling #CFE_TBL_Register,
**   failed when calling #CFE_TBL_Share or forgot to call either one.
**
*/
#define CFE_TBL_ERR_NO_ACCESS   (int32)(0xcc000008L)

/**
**  The calling application is trying to access a table that has
**  been unregistered.
**
*/
#define CFE_TBL_ERR_UNREGISTERED (int32)(0xcc000009L)

/**
**  The calling application does not have a legitimate Application ID.
**  Most likely cause is a failure to register with the cFE via the
**  #CFE_ES_RegisterApp function.
**
*/
#define CFE_TBL_ERR_BAD_APP_ID (int32)(0xcc00000AL)

/**
**   An application attempted to create a table and the Table
**   Handle Array already used all CFE_TBL_MAX_NUM_HANDLES in it.
**
*/
#define CFE_TBL_ERR_HANDLES_FULL (int32)(0xcc00000BL)

/**
**  An application attempted to register a table with the same name
**  as a table that is already in the registry.  The size of the new
**  table is different from the size already in the registry.
**
*/
#define CFE_TBL_ERR_DUPLICATE_DIFF_SIZE (int32)(0xcc00000CL)

/**
**  An application attempted to register a table with the same name
**  as a table that is already in the registry.  The previously registered
**  table is owned by a different application.
**
*/
#define CFE_TBL_ERR_DUPLICATE_NOT_OWNED (int32)(0xcc00000DL)

/**
**  The calling Application has identified a table that has been updated.<BR>
**  \b NOTE: This is a nominal return code informing the calling application
**  that the table identified in the call has had its contents updated since
**  the last time the application obtained its address or status.
**
*/
#define CFE_TBL_INFO_UPDATED (int32)(0x4c00000EL)

/**
**  The calling Application has tried to allocate a working buffer but
**  none were available.
**
*/
#define CFE_TBL_ERR_NO_BUFFER_AVAIL (int32)(0xcc00000FL)

/**
**  The calling Application has attempted to perform a load on a
**  table that was created with "Dump Only" attributes.
**
*/
#define CFE_TBL_ERR_DUMP_ONLY (int32)(0xcc000010L)

/**
**  The calling Application called #CFE_TBL_Load with an illegal
**  value for the second parameter.
**
*/
#define CFE_TBL_ERR_ILLEGAL_SRC_TYPE (int32)(0xcc000011L)

/**
**  The calling Application called #CFE_TBL_Load when another Application
**  was trying to load the table.
**
*/
#define CFE_TBL_ERR_LOAD_IN_PROGRESS (int32)(0xcc000012L)

/**
**  The calling Application called #CFE_TBL_Load with a bad filename.
**
*/
#define CFE_TBL_ERR_FILE_NOT_FOUND (int32)(0xcc000013L)

/**
**  The calling Application called #CFE_TBL_Load with a filename that specified a file
**  that contained more data than the size of the table OR which contained more data
**  than specified in the table header.
**
*/
#define CFE_TBL_ERR_FILE_TOO_LARGE (int32)(0xcc000014L)

/**
**  The calling Application called #CFE_TBL_Load with a filename that specified a file
**  that started with the first byte of the table but contained less data than the size of the table.
**  It should be noted that #CFE_TBL_WARN_PARTIAL_LOAD also indicates a partial load (one that starts
**  at a non-zero offset).
**
*/
#define CFE_TBL_WARN_SHORT_FILE (int32)(0x4c000015L)

/**
**  The calling Application called #CFE_TBL_Load with a filename that specified a file
**  whose content ID was not that of a table image.
**
*/
#define CFE_TBL_ERR_BAD_CONTENT_ID (int32)(0xcc000016L)

/**
**  The calling Application has attempted to update a table without a pending load.
**
*/
#define CFE_TBL_INFO_NO_UPDATE_PENDING (int32)(0x4c000017L)

/**
**  The calling Application tried to update a table that is locked by another user.
**
*/
#define CFE_TBL_INFO_TABLE_LOCKED (int32)(0x4c000018L)

/**
**   The calling Application should call #CFE_TBL_Validate for the specified table.
**
*/
#define CFE_TBL_INFO_VALIDATION_PENDING (int32)(0x4c000019L)

/**
**  The calling Application tried to validate a table that did not have a validation request pending.
**
*/
#define CFE_TBL_INFO_NO_VALIDATION_PENDING (int32)(0x4c00001AL)

/**
**  The calling Application tried to access a table file whose Subtype identifier indicated it was not
**  a table image file.
**
*/
#define CFE_TBL_ERR_BAD_SUBTYPE_ID (int32)(0xcc00001BL)

/**
**  The calling Application tried to access a table file whose Subtype identifier indicated it was not
**  a table image file.
**
*/
#define CFE_TBL_ERR_FILE_SIZE_INCONSISTENT (int32)(0xcc00001CL)

/**
**  The calling Application tried to access a table file whose standard cFE File Header was the wrong size, etc.
**
*/
#define CFE_TBL_ERR_NO_STD_HEADER (int32)(0xcc00001DL)

/**
**  The calling Application tried to access a table file whose standard cFE
**  Table File Header was the wrong size, etc.
**
*/
#define CFE_TBL_ERR_NO_TBL_HEADER (int32)(0xcc00001EL)


/**
**  The calling Application tried to load a table using a filename
**  that was too long.
**
*/
#define CFE_TBL_ERR_FILENAME_TOO_LONG (int32)(0xcc00001FL)


/**
**  The calling Application tried to load a table using a file whose
**  header indicated that it was for a different table.
**
*/
#define CFE_TBL_ERR_FILE_FOR_WRONG_TABLE (int32)(0xcc000020L)


/**
**  The calling Application tried to load a table file whose header
**  claimed the load was larger than what was actually read from the file.
**
*/
#define CFE_TBL_ERR_LOAD_INCOMPLETE (int32)(0xcc000021L)


/**
**  The calling Application tried to load a table file whose header
**  claimed the load did not start with the first byteIt should be noted
**  that #CFE_TBL_WARN_SHORT_FILE also indicates a partial load.
**
*/
#define CFE_TBL_WARN_PARTIAL_LOAD (int32)(0x4c000022L)


/**
**  The calling Application tried to load a table file whose header
**  claimed the load did not start with the first byte and the table
**  image had NEVER been loaded before.  Partial loads are not allowed
**  on uninitialized tables.  It should be noted that
**  #CFE_TBL_WARN_SHORT_FILE also indicates a partial load.
**
*/
#define CFE_TBL_ERR_PARTIAL_LOAD (int32)(0xcc000023L)


/**
**  The calling Application should call #CFE_TBL_Manage for the specified table.
**  The ground has requested a dump of the Dump-Only table and needs to synchronize
**  with the owning application.
**
*/
#define CFE_TBL_INFO_DUMP_PENDING (int32)(0x4c000024L)


/**
**   The calling Application has used an illegal combination of table options.
**   A summary of the illegal combinations are as follows:
**   \par   #CFE_TBL_OPT_USR_DEF_ADDR cannot be combined with any of the following:
**             -# #CFE_TBL_OPT_DBL_BUFFER
**             -# #CFE_TBL_OPT_LOAD_DUMP
**             -# #CFE_TBL_OPT_CRITICAL
**   \par   #CFE_TBL_OPT_DBL_BUFFER cannot be combined with the following:
**             -# #CFE_TBL_OPT_USR_DEF_ADDR
**             -# #CFE_TBL_OPT_DUMP_ONLY
**
*/
#define CFE_TBL_ERR_INVALID_OPTIONS (int32)(0xcc000025L)


/**
**  The calling Application attempted to register a table as "Critical".
**  Table Services failed to create an appropriate Critical Data Store
**  (See System Log for reason) to save the table contents.  The table
**  will be treated as a normal table from now on.
**
*/
#define CFE_TBL_WARN_NOT_CRITICAL (int32)(0x4c000026L)


/**
**  The calling Application registered a critical table whose previous
**  contents were discovered in the Critical Data Store.  The discovered
**  contents were copied back into the newly registered table as the
**  table's initial contents.<BR>
**  \b NOTE: In this situation, the contents of the table are \b NOT 
**  validated using the table's validation function.
**
*/
#define CFE_TBL_INFO_RECOVERED_TBL (int32)(0x4c000027L)


/**
**  Current version of cFE does not have the function or the feature
**  of the function implemented.  This could be due to either an early
**  build of the cFE for this platform or the platform does not support
**  the specified feature.
**
*/
#define CFE_TBL_NOT_IMPLEMENTED (int32)(0xcc00ffffL)


#endif  /* _cfe_error_ */
